/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.trend.InitializingScoreTrend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScoreDirectorFactory<Solution_, Score_ extends Score<Score_>>
implements InnerScoreDirectorFactory<Solution_, Score_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final SolutionDescriptor<Solution_> solutionDescriptor;
    protected final ListVariableDescriptor<Solution_> listVariableDescriptor;
    protected InitializingScoreTrend initializingScoreTrend;
    protected InnerScoreDirectorFactory<Solution_, Score_> assertionScoreDirectorFactory = null;
    protected boolean assertClonedSolution = false;
    protected boolean trackingWorkingSolution = false;

    public AbstractScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
        this.listVariableDescriptor = solutionDescriptor.getListVariableDescriptor();
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    @Override
    public ScoreDefinition<Score_> getScoreDefinition() {
        return this.solutionDescriptor.getScoreDefinition();
    }

    @Override
    public InitializingScoreTrend getInitializingScoreTrend() {
        return this.initializingScoreTrend;
    }

    public void setInitializingScoreTrend(InitializingScoreTrend initializingScoreTrend) {
        this.initializingScoreTrend = initializingScoreTrend;
    }

    public InnerScoreDirectorFactory<Solution_, Score_> getAssertionScoreDirectorFactory() {
        return this.assertionScoreDirectorFactory;
    }

    public void setAssertionScoreDirectorFactory(InnerScoreDirectorFactory<Solution_, Score_> assertionScoreDirectorFactory) {
        this.assertionScoreDirectorFactory = assertionScoreDirectorFactory;
    }

    public boolean isAssertClonedSolution() {
        return this.assertClonedSolution;
    }

    public void setAssertClonedSolution(boolean assertClonedSolution) {
        this.assertClonedSolution = assertClonedSolution;
    }

    public boolean isTrackingWorkingSolution() {
        return this.trackingWorkingSolution;
    }

    public void setTrackingWorkingSolution(boolean trackingWorkingSolution) {
        this.trackingWorkingSolution = trackingWorkingSolution;
    }

    @Override
    public void assertScoreFromScratch(Solution_ solution) {
        Object score = this.getSolutionDescriptor().getScore(solution);
        try (InnerScoreDirector uncorruptedScoreDirector = this.buildDerivedScoreDirector(false, ConstraintMatchPolicy.ENABLED);){
            uncorruptedScoreDirector.setWorkingSolution(solution);
            Object uncorruptedScore = uncorruptedScoreDirector.calculateScore();
            if (!score.equals(uncorruptedScore)) {
                throw new IllegalStateException("Score corruption (" + score.subtract(uncorruptedScore).toShortString() + "): the solution's score (" + score + ") is not the uncorruptedScore (" + uncorruptedScore + ").");
            }
        }
    }

    public void validateEntity(ScoreDirector<Solution_> scoreDirector, Object entity) {
        if (this.listVariableDescriptor == null) {
            EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            if (entityDescriptor.isMovable(scoreDirector.getWorkingSolution(), entity)) {
                return;
            }
            for (GenuineVariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
                Object value;
                BasicVariableDescriptor basicVariableDescriptor = (BasicVariableDescriptor)variableDescriptor;
                if (basicVariableDescriptor.allowsUnassigned() || (value = basicVariableDescriptor.getValue(entity)) != null) continue;
                throw new IllegalStateException("The entity (%s) has a variable (%s) pinned to null, even though unassigned values are not allowed.".formatted(entity, basicVariableDescriptor.getVariableName()));
            }
        }
    }
}

