/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.calculator.EasyScoreCalculator;
import ai.timefold.solver.core.api.score.calculator.IncrementalScoreCalculator;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.config.score.director.ScoreDirectorFactoryConfig;
import ai.timefold.solver.core.config.score.trend.InitializingScoreTrendLevel;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.easy.EasyScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.incremental.IncrementalScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.stream.BavetConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.trend.InitializingScoreTrend;
import java.util.ArrayList;

public class ScoreDirectorFactoryFactory<Solution_, Score_ extends Score<Score_>> {
    private final ScoreDirectorFactoryConfig config;

    public ScoreDirectorFactoryFactory(ScoreDirectorFactoryConfig config) {
        this.config = config;
    }

    public InnerScoreDirectorFactory<Solution_, Score_> buildScoreDirectorFactory(EnvironmentMode environmentMode, SolutionDescriptor<Solution_> solutionDescriptor) {
        AbstractScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory = this.decideMultipleScoreDirectorFactories(solutionDescriptor, environmentMode);
        ScoreDirectorFactoryConfig assertionScoreDirectorFactory = this.config.getAssertionScoreDirectorFactory();
        if (assertionScoreDirectorFactory != null) {
            if (assertionScoreDirectorFactory.getAssertionScoreDirectorFactory() != null) {
                throw new IllegalArgumentException("A assertionScoreDirectorFactory (%s) cannot have a non-null assertionScoreDirectorFactory (%s).".formatted(assertionScoreDirectorFactory, assertionScoreDirectorFactory.getAssertionScoreDirectorFactory()));
            }
            if (environmentMode.compareTo(EnvironmentMode.FAST_ASSERT) > 0) {
                throw new IllegalArgumentException("A non-null assertionScoreDirectorFactory (%s) requires an environmentMode (%s) of %s or lower.".formatted(new Object[]{assertionScoreDirectorFactory, environmentMode, EnvironmentMode.FAST_ASSERT}));
            }
            ScoreDirectorFactoryFactory<Solution_, Score_> assertionScoreDirectorFactoryFactory = new ScoreDirectorFactoryFactory<Solution_, Score_>(assertionScoreDirectorFactory);
            scoreDirectorFactory.setAssertionScoreDirectorFactory(assertionScoreDirectorFactoryFactory.buildScoreDirectorFactory(EnvironmentMode.NON_REPRODUCIBLE, solutionDescriptor));
        }
        scoreDirectorFactory.setInitializingScoreTrend(InitializingScoreTrend.parseTrend(this.config.getInitializingScoreTrend() == null ? InitializingScoreTrendLevel.ANY.name() : this.config.getInitializingScoreTrend(), solutionDescriptor.getScoreDefinition().getLevelsSize()));
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            scoreDirectorFactory.setAssertClonedSolution(true);
        }
        if (environmentMode.isTracking()) {
            scoreDirectorFactory.setTrackingWorkingSolution(true);
        }
        return scoreDirectorFactory;
    }

    protected AbstractScoreDirectorFactory<Solution_, Score_> decideMultipleScoreDirectorFactories(SolutionDescriptor<Solution_> solutionDescriptor, EnvironmentMode environmentMode) {
        if (!ConfigUtils.isEmptyCollection(this.config.getScoreDrlList())) {
            throw new IllegalStateException("DRL constraints requested via scoreDrlList (%s), but this is no longer supported in Timefold Solver 0.9 and later.\nMaybe upgrade from scoreDRL to ConstraintStreams using this recipe: https://timefold.ai/blog/migrating-score-drl-to-constraint-streams".formatted(this.config.getScoreDrlList()));
        }
        ScoreDirectorFactoryFactory.assertCorrectDirectorFactory(this.config);
        if (this.config.getEasyScoreCalculatorClass() != null) {
            return EasyScoreDirectorFactory.buildScoreDirectorFactory(solutionDescriptor, this.config);
        }
        if (this.config.getIncrementalScoreCalculatorClass() != null) {
            return IncrementalScoreDirectorFactory.buildScoreDirectorFactory(solutionDescriptor, this.config);
        }
        if (this.config.getConstraintProviderClass() != null) {
            return BavetConstraintStreamScoreDirectorFactory.buildScoreDirectorFactory(solutionDescriptor, this.config, environmentMode);
        }
        throw new IllegalArgumentException("The scoreDirectorFactory lacks configuration for either constraintProviderClass, easyScoreCalculatorClass or incrementalScoreCalculatorClass.");
    }

    private static void assertCorrectDirectorFactory(ScoreDirectorFactoryConfig config) {
        boolean hasConstraintProvider;
        boolean hasIncrementalScoreCalculator;
        boolean hasEasyScoreCalculator;
        Class<? extends EasyScoreCalculator> easyScoreCalculatorClass = config.getEasyScoreCalculatorClass();
        boolean bl = hasEasyScoreCalculator = easyScoreCalculatorClass != null;
        if (!hasEasyScoreCalculator && config.getEasyScoreCalculatorCustomProperties() != null) {
            throw new IllegalStateException("If there is no easyScoreCalculatorClass (%s), then there can be no easyScoreCalculatorCustomProperties (%s) either.".formatted(easyScoreCalculatorClass, config.getEasyScoreCalculatorCustomProperties()));
        }
        Class<? extends IncrementalScoreCalculator> incrementalScoreCalculatorClass = config.getIncrementalScoreCalculatorClass();
        boolean bl2 = hasIncrementalScoreCalculator = incrementalScoreCalculatorClass != null;
        if (!hasIncrementalScoreCalculator && config.getIncrementalScoreCalculatorCustomProperties() != null) {
            throw new IllegalStateException("If there is no incrementalScoreCalculatorClass (%s), then there can be no incrementalScoreCalculatorCustomProperties (%s) either.".formatted(incrementalScoreCalculatorClass, config.getIncrementalScoreCalculatorCustomProperties()));
        }
        Class<? extends ConstraintProvider> constraintProviderClass = config.getConstraintProviderClass();
        boolean bl3 = hasConstraintProvider = constraintProviderClass != null;
        if (!hasConstraintProvider && config.getConstraintProviderCustomProperties() != null) {
            throw new IllegalStateException("If there is no constraintProviderClass (%s), then there can be no constraintProviderCustomProperties (%s) either.".formatted(constraintProviderClass, config.getConstraintProviderCustomProperties()));
        }
        if (hasEasyScoreCalculator && (hasIncrementalScoreCalculator || hasConstraintProvider) || hasIncrementalScoreCalculator && hasConstraintProvider) {
            ArrayList<String> scoreDirectorFactoryPropertyList = new ArrayList<String>(3);
            if (hasEasyScoreCalculator) {
                scoreDirectorFactoryPropertyList.add("an easyScoreCalculatorClass (%s)".formatted(easyScoreCalculatorClass.getName()));
            }
            if (hasConstraintProvider) {
                scoreDirectorFactoryPropertyList.add("an constraintProviderClass (%s)".formatted(constraintProviderClass.getName()));
            }
            if (hasIncrementalScoreCalculator) {
                scoreDirectorFactoryPropertyList.add("an incrementalScoreCalculatorClass (%s)".formatted(incrementalScoreCalculatorClass.getName()));
            }
            String joined = String.join((CharSequence)" and ", scoreDirectorFactoryPropertyList);
            throw new IllegalArgumentException("The scoreDirectorFactory cannot have %s together.".formatted(joined));
        }
    }
}

