/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintMetaModel;
import ai.timefold.solver.core.impl.domain.solution.ConstraintWeightSupplier;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraint;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintSession;
import ai.timefold.solver.core.impl.score.stream.bavet.NodeNetwork;
import ai.timefold.solver.core.impl.score.stream.bavet.common.AbstractConcatNode;
import ai.timefold.solver.core.impl.score.stream.bavet.common.AbstractIfExistsNode;
import ai.timefold.solver.core.impl.score.stream.bavet.common.AbstractJoinNode;
import ai.timefold.solver.core.impl.score.stream.bavet.common.AbstractNode;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetConcatConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetIfExistsConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetJoinConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetStreamBinaryOperation;
import ai.timefold.solver.core.impl.score.stream.bavet.common.NodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.common.Propagator;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.AbstractForEachUniNode;
import ai.timefold.solver.core.impl.score.stream.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class BavetConstraintSessionFactory<Solution_, Score_ extends Score<Score_>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BavetConstraintSessionFactory.class);
    private static final Level CONSTRAINT_WEIGHT_LOGGING_LEVEL = Level.DEBUG;
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final ConstraintMetaModel constraintMetaModel;

    public BavetConstraintSessionFactory(SolutionDescriptor<Solution_> solutionDescriptor, ConstraintMetaModel constraintMetaModel) {
        this.solutionDescriptor = Objects.requireNonNull(solutionDescriptor);
        this.constraintMetaModel = Objects.requireNonNull(constraintMetaModel);
    }

    public BavetConstraintSession<Score_> buildSession(Solution_ workingSolution, ConstraintMatchPolicy constraintMatchPolicy, boolean scoreDirectorDerived) {
        ConstraintWeightSupplier constraintWeightSupplier = this.solutionDescriptor.getConstraintWeightSupplier();
        Collection<Constraint> constraints = this.constraintMetaModel.getConstraints();
        if (constraintWeightSupplier != null) {
            Set<ConstraintRef> knownConstraints = constraints.stream().map(Constraint::getConstraintRef).collect(Collectors.toSet());
            constraintWeightSupplier.validate(workingSolution, knownConstraints);
        }
        ScoreDefinition scoreDefinition = this.solutionDescriptor.getScoreDefinition();
        Object zeroScore = scoreDefinition.getZeroScore();
        LinkedHashSet<BavetAbstractConstraintStream<Solution_>> constraintStreamSet = new LinkedHashSet<BavetAbstractConstraintStream<Solution_>>();
        Map constraintWeightMap = CollectionUtils.newHashMap(constraints.size());
        boolean constraintWeightLoggingEnabled = !scoreDirectorDerived && LOGGER.isEnabledForLevel(CONSTRAINT_WEIGHT_LOGGING_LEVEL);
        StringBuilder constraintWeightString = constraintWeightLoggingEnabled ? new StringBuilder("Constraint weights for solution (%s):%n".formatted(workingSolution)) : null;
        for (Constraint constraint : constraints) {
            ConstraintRef constraintRef = constraint.getConstraintRef();
            BavetConstraint castConstraint = (BavetConstraint)constraint;
            Object defaultConstraintWeight = castConstraint.getConstraintWeight();
            Object constraintWeight = castConstraint.extractConstraintWeight(workingSolution);
            if (!constraintWeight.equals(zeroScore)) {
                if (constraintWeightLoggingEnabled) {
                    if (defaultConstraintWeight != null && !defaultConstraintWeight.equals(constraintWeight)) {
                        constraintWeightString.append("  Constraint (%s) weight overridden to (%s) from (%s).%n".formatted(constraintRef, constraintWeight, defaultConstraintWeight));
                    } else {
                        constraintWeightString.append("  Constraint (%s) weight set to (%s).%n".formatted(constraintRef, constraintWeight));
                    }
                }
                castConstraint.collectActiveConstraintStreams(constraintStreamSet);
                constraintWeightMap.put(constraint, constraintWeight);
                continue;
            }
            if (!constraintWeightLoggingEnabled) continue;
            constraintWeightString.append("  Constraint (%s) disabled.%n".formatted(constraintRef));
        }
        Object scoreInliner = AbstractScoreInliner.buildScoreInliner(scoreDefinition, constraintWeightMap, constraintMatchPolicy);
        if (constraintStreamSet.isEmpty()) {
            LOGGER.warn("No constraints enabled for solution ({}).", workingSolution);
            return new BavetConstraintSession(scoreInliner);
        }
        if (constraintWeightLoggingEnabled) {
            LOGGER.atLevel(CONSTRAINT_WEIGHT_LOGGING_LEVEL).log(constraintWeightString.toString().trim());
        }
        return new BavetConstraintSession(scoreInliner, BavetConstraintSessionFactory.buildNodeNetwork(constraintStreamSet, scoreInliner));
    }

    private static <Solution_, Score_ extends Score<Score_>> NodeNetwork buildNodeNetwork(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet, AbstractScoreInliner<Score_> scoreInliner) {
        NodeBuildHelper<Score_> buildHelper = new NodeBuildHelper<Score_>(constraintStreamSet, scoreInliner);
        ArrayList<BavetAbstractConstraintStream<Solution_>> reversedConstraintStreamList = new ArrayList<BavetAbstractConstraintStream<Solution_>>(constraintStreamSet);
        Collections.reverse(reversedConstraintStreamList);
        for (BavetAbstractConstraintStream<Solution_> constraintStream : reversedConstraintStreamList) {
            constraintStream.buildNode(buildHelper);
        }
        List<AbstractNode> nodeList = buildHelper.destroyAndGetNodeList();
        LinkedHashMap declaredClassToNodeMap = new LinkedHashMap();
        long nextNodeId = 0L;
        for (AbstractNode abstractNode : nodeList) {
            abstractNode.setId(nextNodeId++);
            abstractNode.setLayerIndex(BavetConstraintSessionFactory.determineLayerIndex(abstractNode, buildHelper));
            if (!(abstractNode instanceof AbstractForEachUniNode)) continue;
            AbstractForEachUniNode forEachUniNode = (AbstractForEachUniNode)abstractNode;
            Class forEachClass = forEachUniNode.getForEachClass();
            List forEachUniNodeList = declaredClassToNodeMap.computeIfAbsent(forEachClass, k -> new ArrayList());
            if (forEachUniNodeList.size() == 2) {
                throw new IllegalStateException("Impossible state: For class (" + forEachClass + ") there are already 2 nodes (" + forEachUniNodeList + "), not adding another (" + forEachUniNode + ").");
            }
            forEachUniNodeList.add(forEachUniNode);
        }
        TreeMap<Long, List> layerMap = new TreeMap<Long, List>();
        for (AbstractNode node : nodeList) {
            layerMap.computeIfAbsent(node.getLayerIndex(), k -> new ArrayList()).add(node.getPropagator());
        }
        int n = layerMap.size();
        Propagator[][] layeredNodes = new Propagator[n][];
        for (int i = 0; i < n; ++i) {
            List layer = (List)layerMap.get(i);
            layeredNodes[i] = layer.toArray(new Propagator[0]);
        }
        return new NodeNetwork(declaredClassToNodeMap, layeredNodes);
    }

    private static <Score_ extends Score<Score_>> long determineLayerIndex(AbstractNode node, NodeBuildHelper<Score_> buildHelper) {
        if (node instanceof AbstractForEachUniNode) {
            return 0L;
        }
        if (node instanceof AbstractJoinNode) {
            AbstractJoinNode joinNode = (AbstractJoinNode)node;
            return BavetConstraintSessionFactory.determineLayerIndexOfBinaryOperation((BavetJoinConstraintStream)((Object)buildHelper.getNodeCreatingStream(joinNode)), buildHelper);
        }
        if (node instanceof AbstractConcatNode) {
            AbstractConcatNode concatNode = (AbstractConcatNode)node;
            return BavetConstraintSessionFactory.determineLayerIndexOfBinaryOperation((BavetConcatConstraintStream)((Object)buildHelper.getNodeCreatingStream(concatNode)), buildHelper);
        }
        if (node instanceof AbstractIfExistsNode) {
            AbstractIfExistsNode ifExistsNode = (AbstractIfExistsNode)node;
            return BavetConstraintSessionFactory.determineLayerIndexOfBinaryOperation((BavetIfExistsConstraintStream)((Object)buildHelper.getNodeCreatingStream(ifExistsNode)), buildHelper);
        }
        BavetAbstractConstraintStream<?> nodeCreator = buildHelper.getNodeCreatingStream(node);
        AbstractNode parentNode = buildHelper.findParentNode(nodeCreator.getParent());
        return parentNode.getLayerIndex() + 1L;
    }

    private static <Score_ extends Score<Score_>> long determineLayerIndexOfBinaryOperation(BavetStreamBinaryOperation<?> nodeCreator, NodeBuildHelper<Score_> buildHelper) {
        BavetAbstractConstraintStream<?> leftParent = nodeCreator.getLeftParent();
        BavetAbstractConstraintStream<?> rightParent = nodeCreator.getRightParent();
        AbstractNode leftParentNode = buildHelper.findParentNode(leftParent);
        AbstractNode rightParentNode = buildHelper.findParentNode(rightParent);
        return Math.max(leftParentNode.getLayerIndex(), rightParentNode.getLayerIndex()) + 1L;
    }
}

