/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet;

import ai.timefold.solver.core.impl.score.stream.bavet.common.Propagator;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.AbstractForEachUniNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

record NodeNetwork(Map<Class<?>, List<AbstractForEachUniNode<Object>>> declaredClassToNodeMap, Propagator[][] layeredNodes) {
    public static final NodeNetwork EMPTY = new NodeNetwork(Map.of(), new Propagator[0][0]);

    public int forEachNodeCount() {
        return this.declaredClassToNodeMap.size();
    }

    public int layerCount() {
        return this.layeredNodes.length;
    }

    public AbstractForEachUniNode<Object>[] getApplicableForEachNodes(Class<?> factClass) {
        return (AbstractForEachUniNode[])this.declaredClassToNodeMap.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(factClass)).map(Map.Entry::getValue).flatMap(Collection::stream).toArray(AbstractForEachUniNode[]::new);
    }

    public void propagate() {
        for (int layerIndex = 0; layerIndex < this.layerCount(); ++layerIndex) {
            NodeNetwork.propagateInLayer(this.layeredNodes[layerIndex]);
        }
    }

    private static void propagateInLayer(Propagator[] nodesInLayer) {
        int nodeCount = nodesInLayer.length;
        if (nodeCount == 1) {
            nodesInLayer[0].propagateEverything();
        } else {
            for (Propagator node : nodesInLayer) {
                node.propagateRetracts();
            }
            for (Propagator node : nodesInLayer) {
                node.propagateUpdates();
            }
            for (Propagator node : nodesInLayer) {
                node.propagateInserts();
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeNetwork)) {
            return false;
        }
        NodeNetwork that = (NodeNetwork)o;
        return Objects.equals(this.declaredClassToNodeMap, that.declaredClassToNodeMap) && Objects.deepEquals(this.layeredNodes, that.layeredNodes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.declaredClassToNodeMap, Arrays.deepHashCode((Object[])this.layeredNodes));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " with " + this.forEachNodeCount() + " forEach nodes.";
    }
}

