/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.bi;

import ai.timefold.solver.core.impl.score.stream.bavet.common.AbstractMapNode;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.BiTuple;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.QuadTuple;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.TupleLifecycle;
import java.util.Objects;
import java.util.function.BiFunction;

final class MapBiToQuadNode<A, B, NewA, NewB, NewC, NewD>
extends AbstractMapNode<BiTuple<A, B>, QuadTuple<NewA, NewB, NewC, NewD>> {
    private final BiFunction<A, B, NewA> mappingFunctionA;
    private final BiFunction<A, B, NewB> mappingFunctionB;
    private final BiFunction<A, B, NewC> mappingFunctionC;
    private final BiFunction<A, B, NewD> mappingFunctionD;

    MapBiToQuadNode(int mapStoreIndex, BiFunction<A, B, NewA> mappingFunctionA, BiFunction<A, B, NewB> mappingFunctionB, BiFunction<A, B, NewC> mappingFunctionC, BiFunction<A, B, NewD> mappingFunctionD, TupleLifecycle<QuadTuple<NewA, NewB, NewC, NewD>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(mapStoreIndex, nextNodesTupleLifecycle, outputStoreSize);
        this.mappingFunctionA = Objects.requireNonNull(mappingFunctionA);
        this.mappingFunctionB = Objects.requireNonNull(mappingFunctionB);
        this.mappingFunctionC = Objects.requireNonNull(mappingFunctionC);
        this.mappingFunctionD = Objects.requireNonNull(mappingFunctionD);
    }

    @Override
    protected QuadTuple<NewA, NewB, NewC, NewD> map(BiTuple<A, B> tuple) {
        Object factA = tuple.factA;
        Object factB = tuple.factB;
        return new QuadTuple<NewA, NewB, NewC, NewD>(this.mappingFunctionA.apply(factA, factB), this.mappingFunctionB.apply(factA, factB), this.mappingFunctionC.apply(factA, factB), this.mappingFunctionD.apply(factA, factB), this.outputStoreSize);
    }

    @Override
    protected void remap(BiTuple<A, B> inTuple, QuadTuple<NewA, NewB, NewC, NewD> outTuple) {
        Object factA = inTuple.factA;
        Object factB = inTuple.factB;
        NewA newA = this.mappingFunctionA.apply(factA, factB);
        NewB newB = this.mappingFunctionB.apply(factA, factB);
        NewC newC = this.mappingFunctionC.apply(factA, factB);
        NewD newD = this.mappingFunctionD.apply(factA, factB);
        outTuple.factA = newA;
        outTuple.factB = newB;
        outTuple.factC = newC;
        outTuple.factD = newD;
    }
}

