/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.bi;

import ai.timefold.solver.core.impl.score.stream.bavet.common.AbstractMapNode;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.BiTuple;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.UniTuple;
import java.util.Objects;
import java.util.function.BiFunction;

final class MapBiToUniNode<A, B, NewA>
extends AbstractMapNode<BiTuple<A, B>, UniTuple<NewA>> {
    private final BiFunction<A, B, NewA> mappingFunction;

    MapBiToUniNode(int mapStoreIndex, BiFunction<A, B, NewA> mappingFunction, TupleLifecycle<UniTuple<NewA>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(mapStoreIndex, nextNodesTupleLifecycle, outputStoreSize);
        this.mappingFunction = Objects.requireNonNull(mappingFunction);
    }

    @Override
    protected UniTuple<NewA> map(BiTuple<A, B> tuple) {
        Object factA = tuple.factA;
        Object factB = tuple.factB;
        return new UniTuple<NewA>(this.mappingFunction.apply(factA, factB), this.outputStoreSize);
    }

    @Override
    protected void remap(BiTuple<A, B> inTuple, UniTuple<NewA> outTuple) {
        Object factA = inTuple.factA;
        Object factB = inTuple.factB;
        NewA newA = this.mappingFunction.apply(factA, factB);
        outTuple.factA = newA;
    }
}

