/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.common;

import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.score.stream.common.inliner.ScoreContext;
import ai.timefold.solver.core.impl.score.stream.common.inliner.UndoScoreImpacter;
import ai.timefold.solver.core.impl.score.stream.common.inliner.WeightedScoreImpacter;

public abstract class AbstractScorer<Tuple_ extends AbstractTuple>
implements TupleLifecycle<Tuple_> {
    protected final WeightedScoreImpacter<?, ?> weightedScoreImpacter;
    private final int inputStoreIndex;

    protected AbstractScorer(WeightedScoreImpacter<?, ?> weightedScoreImpacter, int inputStoreIndex) {
        this.weightedScoreImpacter = weightedScoreImpacter;
        this.inputStoreIndex = inputStoreIndex;
    }

    @Override
    public final void insert(Tuple_ tuple) {
        if (((AbstractTuple)tuple).getStore(this.inputStoreIndex) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + tuple + ") was already added in the tupleStore.");
        }
        ((AbstractTuple)tuple).setStore(this.inputStoreIndex, this.impact(tuple));
    }

    @Override
    public final void update(Tuple_ tuple) {
        UndoScoreImpacter undoScoreImpacter = (UndoScoreImpacter)((AbstractTuple)tuple).getStore(this.inputStoreIndex);
        if (undoScoreImpacter != null) {
            undoScoreImpacter.run();
        }
        ((AbstractTuple)tuple).setStore(this.inputStoreIndex, this.impact(tuple));
    }

    protected abstract UndoScoreImpacter impact(Tuple_ var1);

    protected RuntimeException createExceptionOnImpact(Tuple_ tuple, Exception cause) {
        return new IllegalStateException("Consequence of a constraint (" + ((ScoreContext)this.weightedScoreImpacter.getContext()).getConstraint().getConstraintRef() + ") threw an exception processing a tuple (" + tuple + ").", cause);
    }

    @Override
    public final void retract(Tuple_ tuple) {
        UndoScoreImpacter undoScoreImpacter = (UndoScoreImpacter)((AbstractTuple)tuple).getStore(this.inputStoreIndex);
        if (undoScoreImpacter != null) {
            undoScoreImpacter.run();
            ((AbstractTuple)tuple).setStore(this.inputStoreIndex, null);
        }
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(" + ((ScoreContext)this.weightedScoreImpacter.getContext()).getConstraint().getConstraintRef() + ") with constraintWeight (" + ((ScoreContext)this.weightedScoreImpacter.getContext()).getConstraintWeight() + ")";
    }
}

