/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.common;

import ai.timefold.solver.core.impl.score.stream.bavet.common.AbstractJoinNode;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.LeftTupleLifecycle;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.RightTupleLifecycle;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.util.ElementAwareList;
import ai.timefold.solver.core.impl.util.ElementAwareListEntry;

public abstract class AbstractUnindexedJoinNode<LeftTuple_ extends AbstractTuple, Right_, OutTuple_ extends AbstractTuple>
extends AbstractJoinNode<LeftTuple_, Right_, OutTuple_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final int inputStoreIndexLeftEntry;
    private final int inputStoreIndexRightEntry;
    private final ElementAwareList<LeftTuple_> leftTupleList = new ElementAwareList();
    private final ElementAwareList<UniTuple<Right_>> rightTupleList = new ElementAwareList();

    protected AbstractUnindexedJoinNode(int inputStoreIndexLeftEntry, int inputStoreIndexLeftOutTupleList, int inputStoreIndexRightEntry, int inputStoreIndexRightOutTupleList, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, boolean isFiltering, int outputStoreIndexLeftOutEntry, int outputStoreIndexRightOutEntry) {
        super(inputStoreIndexLeftOutTupleList, inputStoreIndexRightOutTupleList, nextNodesTupleLifecycle, isFiltering, outputStoreIndexLeftOutEntry, outputStoreIndexRightOutEntry);
        this.inputStoreIndexLeftEntry = inputStoreIndexLeftEntry;
        this.inputStoreIndexRightEntry = inputStoreIndexRightEntry;
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        if (((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftEntry) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + leftTuple + ") was already added in the tupleStore.");
        }
        ElementAwareListEntry<LeftTuple_> leftEntry = this.leftTupleList.add(leftTuple);
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftEntry, leftEntry);
        ElementAwareList outTupleListLeft = new ElementAwareList();
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftOutTupleList, outTupleListLeft);
        for (UniTuple<Right_> tuple : this.rightTupleList) {
            this.insertOutTupleFiltered(leftTuple, tuple);
        }
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        ElementAwareListEntry leftEntry = (ElementAwareListEntry)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftEntry);
        if (leftEntry == null) {
            this.insertLeft(leftTuple);
            return;
        }
        this.innerUpdateLeft(leftTuple, this.rightTupleList::forEach);
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        ElementAwareListEntry leftEntry = (ElementAwareListEntry)((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLeftEntry);
        if (leftEntry == null) {
            return;
        }
        ElementAwareList outTupleListLeft = (ElementAwareList)((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLeftOutTupleList);
        leftEntry.remove();
        outTupleListLeft.forEach(this::retractOutTuple);
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.getStore(this.inputStoreIndexRightEntry) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + rightTuple + ") was already added in the tupleStore.");
        }
        ElementAwareListEntry<UniTuple<Right_>> rightEntry = this.rightTupleList.add(rightTuple);
        rightTuple.setStore(this.inputStoreIndexRightEntry, rightEntry);
        ElementAwareList outTupleListRight = new ElementAwareList();
        rightTuple.setStore(this.inputStoreIndexRightOutTupleList, outTupleListRight);
        for (AbstractTuple tuple : this.leftTupleList) {
            this.insertOutTupleFiltered(tuple, rightTuple);
        }
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        ElementAwareListEntry rightEntry = (ElementAwareListEntry)rightTuple.getStore(this.inputStoreIndexRightEntry);
        if (rightEntry == null) {
            this.insertRight(rightTuple);
            return;
        }
        this.innerUpdateRight(rightTuple, this.leftTupleList::forEach);
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        ElementAwareListEntry rightEntry = (ElementAwareListEntry)rightTuple.removeStore(this.inputStoreIndexRightEntry);
        if (rightEntry == null) {
            return;
        }
        ElementAwareList outTupleListRight = (ElementAwareList)rightTuple.removeStore(this.inputStoreIndexRightOutTupleList);
        rightEntry.remove();
        outTupleListRight.forEach(this::retractOutTuple);
    }
}

