/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.common;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraint;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetScoringConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.NodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.common.TupleSource;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraintStream;
import ai.timefold.solver.core.impl.score.stream.common.RetrievalSemantics;
import ai.timefold.solver.core.impl.score.stream.common.ScoreImpactType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NonNull;

public abstract class BavetAbstractConstraintStream<Solution_>
extends AbstractConstraintStream<Solution_> {
    protected final BavetConstraintFactory<Solution_> constraintFactory;
    protected final BavetAbstractConstraintStream<Solution_> parent;
    protected final List<BavetAbstractConstraintStream<Solution_>> childStreamList = new ArrayList<BavetAbstractConstraintStream<Solution_>>(2);

    protected BavetAbstractConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractConstraintStream<Solution_> parent) {
        super(parent.getRetrievalSemantics());
        this.constraintFactory = constraintFactory;
        this.parent = parent;
    }

    protected BavetAbstractConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, RetrievalSemantics retrievalSemantics) {
        super(retrievalSemantics);
        this.constraintFactory = constraintFactory;
        this.parent = null;
    }

    public boolean guaranteesDistinct() {
        if (this.parent != null) {
            return this.parent.guaranteesDistinct();
        }
        return false;
    }

    protected <Score_ extends Score<Score_>> Constraint buildConstraint(String constraintPackage, String constraintName, String description, String constraintGroup, Score_ constraintWeight, ScoreImpactType impactType, Object justificationFunction, Object indictedObjectsMapping, BavetScoringConstraintStream<Solution_> stream) {
        String resolvedConstraintPackage = Objects.requireNonNullElseGet(constraintPackage, this.constraintFactory::getDefaultConstraintPackage);
        Object resolvedJustificationMapping = Objects.requireNonNullElseGet(justificationFunction, () -> this.getDefaultJustificationMapping());
        Object resolvedIndictedObjectsMapping = Objects.requireNonNullElseGet(indictedObjectsMapping, () -> this.getDefaultIndictedObjectsMapping());
        boolean isConstraintWeightConfigurable = constraintWeight == null;
        ConstraintRef constraintRef = ConstraintRef.of(resolvedConstraintPackage, constraintName);
        BavetConstraint<Solution_> constraint = new BavetConstraint<Solution_>(this.constraintFactory, constraintRef, description, constraintGroup, isConstraintWeightConfigurable ? null : (Score<?>)constraintWeight, impactType, resolvedJustificationMapping, resolvedIndictedObjectsMapping, stream);
        stream.setConstraint(constraint);
        return constraint;
    }

    public final <Stream_ extends BavetAbstractConstraintStream<Solution_>> Stream_ shareAndAddChild(Stream_ stream) {
        return (Stream_)this.constraintFactory.share(stream, this.childStreamList::add);
    }

    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        if (this.parent == null) {
            throw new IllegalStateException("Impossible state: the stream (" + this + ") does not have a parent.");
        }
        this.parent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    public BavetAbstractConstraintStream<Solution_> getTupleSource() {
        if (this instanceof TupleSource) {
            return this;
        }
        if (this.parent == null) {
            throw new IllegalStateException("Impossible state: the stream (" + this + ") does not have a parent.");
        }
        return this.parent.getTupleSource();
    }

    public abstract <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> var1);

    protected void assertEmptyChildStreamList() {
        if (!this.childStreamList.isEmpty()) {
            throw new IllegalStateException("Impossible state: the stream (" + this + ") has a non-empty childStreamList (" + this.childStreamList + ").");
        }
    }

    @Override
    public @NonNull BavetConstraintFactory<Solution_> getConstraintFactory() {
        return this.constraintFactory;
    }

    public final BavetAbstractConstraintStream<Solution_> getParent() {
        return this.parent;
    }

    public final List<BavetAbstractConstraintStream<Solution_>> getChildStreamList() {
        return this.childStreamList;
    }
}

