/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.common;

import ai.timefold.solver.core.impl.score.stream.bavet.common.PropagationQueue;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.TupleState;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;

public final class StaticPropagationQueue<Tuple_ extends AbstractTuple>
implements PropagationQueue<Tuple_> {
    private final Deque<Tuple_> retractQueue;
    private final Deque<Tuple_> updateQueue;
    private final Deque<Tuple_> insertQueue;
    private final Consumer<Tuple_> retractPropagator;
    private final Consumer<Tuple_> updatePropagator;
    private final Consumer<Tuple_> insertPropagator;

    public StaticPropagationQueue(TupleLifecycle<Tuple_> nextNodesTupleLifecycle, int size) {
        this.retractQueue = new ArrayDeque<Tuple_>(size / 20);
        this.updateQueue = new ArrayDeque<Tuple_>(size / 20 * 18);
        this.insertQueue = new ArrayDeque<Tuple_>(size / 20);
        this.retractPropagator = nextNodesTupleLifecycle::retract;
        this.updatePropagator = nextNodesTupleLifecycle::update;
        this.insertPropagator = nextNodesTupleLifecycle::insert;
    }

    public StaticPropagationQueue(TupleLifecycle<Tuple_> nextNodesTupleLifecycle) {
        this(nextNodesTupleLifecycle, 1000);
    }

    @Override
    public void insert(Tuple_ carrier) {
        if (((AbstractTuple)carrier).state == TupleState.CREATING) {
            throw new IllegalStateException("Impossible state: The tuple (" + carrier + ") is already in the insert queue.");
        }
        ((AbstractTuple)carrier).state = TupleState.CREATING;
        this.insertQueue.add(carrier);
    }

    @Override
    public void update(Tuple_ carrier) {
        if (((AbstractTuple)carrier).state == TupleState.UPDATING) {
            return;
        }
        ((AbstractTuple)carrier).state = TupleState.UPDATING;
        this.updateQueue.add(carrier);
    }

    @Override
    public void retract(Tuple_ carrier, TupleState state) {
        if (((AbstractTuple)carrier).state == state) {
            return;
        }
        if (state.isActive() || state == TupleState.DEAD) {
            throw new IllegalArgumentException("Impossible state: The state (" + state + ") is not a valid retract state.");
        }
        if (((AbstractTuple)carrier).state == TupleState.ABORTING || ((AbstractTuple)carrier).state == TupleState.DYING) {
            throw new IllegalStateException("Impossible state: The tuple (" + carrier + ") is already in the retract queue.");
        }
        ((AbstractTuple)carrier).state = state;
        this.retractQueue.add(carrier);
    }

    @Override
    public void propagateRetracts() {
        if (this.retractQueue.isEmpty()) {
            return;
        }
        for (AbstractTuple tuple : this.retractQueue) {
            switch (tuple.state) {
                case DYING: {
                    this.propagate(tuple, this.retractPropagator, TupleState.DEAD);
                    break;
                }
                case ABORTING: {
                    tuple.state = TupleState.DEAD;
                }
            }
        }
        this.retractQueue.clear();
    }

    private void propagate(Tuple_ tuple, Consumer<Tuple_> propagator, TupleState tupleState) {
        ((AbstractTuple)tuple).state = tupleState;
        propagator.accept(tuple);
    }

    @Override
    public void propagateUpdates() {
        this.processAndClear(this.updateQueue, this.updatePropagator);
    }

    private void processAndClear(Deque<Tuple_> dirtyQueue, Consumer<Tuple_> propagator) {
        if (dirtyQueue.isEmpty()) {
            return;
        }
        for (AbstractTuple tuple : dirtyQueue) {
            if (tuple.state == TupleState.DEAD) continue;
            this.propagate(tuple, propagator, TupleState.OK);
        }
        dirtyQueue.clear();
    }

    @Override
    public void propagateInserts() {
        this.processAndClear(this.insertQueue, this.insertPropagator);
        if (!this.retractQueue.isEmpty()) {
            throw new IllegalStateException("Impossible state: The retract queue (" + this.retractQueue + ") is not empty.");
        }
        if (!this.updateQueue.isEmpty()) {
            throw new IllegalStateException("Impossible state: The update queue (" + this.updateQueue + ") is not empty.");
        }
    }
}

