/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.common.index;

import ai.timefold.solver.core.impl.score.stream.bavet.common.index.IndexProperties;
import ai.timefold.solver.core.impl.score.stream.bavet.common.index.Indexer;
import ai.timefold.solver.core.impl.util.ElementAwareListEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class EqualsIndexer<T, Key_>
implements Indexer<T> {
    private final int propertyIndex;
    private final Supplier<Indexer<T>> downstreamIndexerSupplier;
    private final Map<Key_, Indexer<T>> downstreamIndexerMap = new HashMap<Key_, Indexer<T>>();

    public EqualsIndexer(Supplier<Indexer<T>> downstreamIndexerSupplier) {
        this(0, downstreamIndexerSupplier);
    }

    public EqualsIndexer(int propertyIndex, Supplier<Indexer<T>> downstreamIndexerSupplier) {
        this.propertyIndex = propertyIndex;
        this.downstreamIndexerSupplier = Objects.requireNonNull(downstreamIndexerSupplier);
    }

    @Override
    public ElementAwareListEntry<T> put(IndexProperties indexProperties, T tuple) {
        Object indexKey = indexProperties.toKey(this.propertyIndex);
        Indexer<T> downstreamIndexer = this.downstreamIndexerMap.get(indexKey);
        if (downstreamIndexer == null) {
            downstreamIndexer = this.downstreamIndexerSupplier.get();
            this.downstreamIndexerMap.put(indexKey, downstreamIndexer);
        }
        return downstreamIndexer.put(indexProperties, tuple);
    }

    @Override
    public void remove(IndexProperties indexProperties, ElementAwareListEntry<T> entry) {
        Object indexKey = indexProperties.toKey(this.propertyIndex);
        Indexer<T> downstreamIndexer = this.getDownstreamIndexer(indexProperties, indexKey, entry);
        downstreamIndexer.remove(indexProperties, entry);
        if (downstreamIndexer.isEmpty()) {
            this.downstreamIndexerMap.remove(indexKey);
        }
    }

    private Indexer<T> getDownstreamIndexer(IndexProperties indexProperties, Key_ indexerKey, ElementAwareListEntry<T> entry) {
        Indexer<T> downstreamIndexer = this.downstreamIndexerMap.get(indexerKey);
        if (downstreamIndexer == null) {
            throw new IllegalStateException("Impossible state: the tuple (" + entry.getElement() + ") with indexProperties (" + indexProperties + ") doesn't exist in the indexer " + this + ".");
        }
        return downstreamIndexer;
    }

    @Override
    public int size(IndexProperties indexProperties) {
        Object indexKey = indexProperties.toKey(this.propertyIndex);
        Indexer<T> downstreamIndexer = this.downstreamIndexerMap.get(indexKey);
        if (downstreamIndexer == null) {
            return 0;
        }
        return downstreamIndexer.size(indexProperties);
    }

    @Override
    public void forEach(IndexProperties indexProperties, Consumer<T> tupleConsumer) {
        Object indexKey = indexProperties.toKey(this.propertyIndex);
        Indexer<T> downstreamIndexer = this.downstreamIndexerMap.get(indexKey);
        if (downstreamIndexer == null) {
            return;
        }
        downstreamIndexer.forEach(indexProperties, tupleConsumer);
    }

    @Override
    public boolean isEmpty() {
        return this.downstreamIndexerMap.isEmpty();
    }

    public String toString() {
        return "size = " + this.downstreamIndexerMap.size();
    }
}

