/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.common.index;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.impl.score.stream.JoinerType;
import ai.timefold.solver.core.impl.score.stream.bavet.common.index.ComparisonIndexer;
import ai.timefold.solver.core.impl.score.stream.bavet.common.index.EqualsIndexer;
import ai.timefold.solver.core.impl.score.stream.bavet.common.index.IndexProperties;
import ai.timefold.solver.core.impl.score.stream.bavet.common.index.Indexer;
import ai.timefold.solver.core.impl.score.stream.bavet.common.index.IndexerKey;
import ai.timefold.solver.core.impl.score.stream.bavet.common.index.ManyIndexProperties;
import ai.timefold.solver.core.impl.score.stream.bavet.common.index.NoneIndexProperties;
import ai.timefold.solver.core.impl.score.stream.bavet.common.index.NoneIndexer;
import ai.timefold.solver.core.impl.score.stream.bavet.common.index.SingleIndexProperties;
import ai.timefold.solver.core.impl.score.stream.bavet.common.index.ThreeIndexProperties;
import ai.timefold.solver.core.impl.score.stream.bavet.common.index.TwoIndexProperties;
import ai.timefold.solver.core.impl.score.stream.common.AbstractJoiner;
import ai.timefold.solver.core.impl.score.stream.common.bi.DefaultBiJoiner;
import ai.timefold.solver.core.impl.score.stream.common.penta.DefaultPentaJoiner;
import ai.timefold.solver.core.impl.score.stream.common.quad.DefaultQuadJoiner;
import ai.timefold.solver.core.impl.score.stream.common.tri.DefaultTriJoiner;
import ai.timefold.solver.core.impl.util.Pair;
import ai.timefold.solver.core.impl.util.Quadruple;
import ai.timefold.solver.core.impl.util.Triple;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class IndexerFactory<Right_> {
    private final AbstractJoiner<Right_> joiner;
    private final NavigableMap<Integer, JoinerType> joinerTypeMap;

    public IndexerFactory(AbstractJoiner<Right_> joiner) {
        this.joiner = joiner;
        int joinerCount = joiner.getJoinerCount();
        if (joinerCount < 2) {
            this.joinerTypeMap = null;
        } else {
            this.joinerTypeMap = new TreeMap<Integer, JoinerType>();
            for (int i = 1; i <= joinerCount; ++i) {
                JoinerType joinerType = i < joinerCount ? joiner.getJoinerType(i) : null;
                JoinerType previousJoinerType = joiner.getJoinerType(i - 1);
                if (joinerType == JoinerType.EQUAL && previousJoinerType == joinerType) continue;
                this.joinerTypeMap.put(i, previousJoinerType);
            }
        }
    }

    public boolean hasJoiners() {
        return this.joiner.getJoinerCount() > 0;
    }

    public <A> Function<A, IndexProperties> buildUniLeftMapping() {
        int joinerCount = this.joiner.getJoinerCount();
        DefaultBiJoiner castJoiner = (DefaultBiJoiner)this.joiner;
        return switch (joinerCount) {
            case 0 -> a -> NoneIndexProperties.INSTANCE;
            case 1 -> {
                Function mapping = castJoiner.getLeftMapping(0);
                yield a -> new SingleIndexProperties(mapping.apply(a));
            }
            default -> {
                int startIndexInclusive = 0;
                ArrayList keyFunctionList = new ArrayList();
                for (Map.Entry entry : this.joinerTypeMap.entrySet()) {
                    Integer endIndexExclusive = (Integer)entry.getKey();
                    int keyFunctionLength = endIndexExclusive - startIndexInclusive;
                    Function<Object, Object> v1 = switch (keyFunctionLength) {
                        case 1 -> castJoiner.getLeftMapping(startIndexInclusive);
                        case 2 -> {
                            Function mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                            Function mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                            yield a -> new Pair(mapping1.apply(a), mapping2.apply(a));
                        }
                        case 3 -> {
                            Function mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                            Function mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                            Function mapping3 = castJoiner.getLeftMapping(startIndexInclusive + 2);
                            yield a -> new Triple(mapping1.apply(a), mapping2.apply(a), mapping3.apply(a));
                        }
                        case 4 -> {
                            Function mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                            Function mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                            Function mapping3 = castJoiner.getLeftMapping(startIndexInclusive + 2);
                            Function mapping4 = castJoiner.getLeftMapping(startIndexInclusive + 3);
                            yield a -> new Quadruple(mapping1.apply(a), mapping2.apply(a), mapping3.apply(a), mapping4.apply(a));
                        }
                        default -> {
                            Function[] mappings = new Function[joinerCount];
                            for (int i = 0; i < joinerCount; ++i) {
                                Function mapping;
                                mappings[i] = mapping = castJoiner.getLeftMapping(i);
                            }
                            yield a -> {
                                int mappingCount = mappings.length;
                                Object[] result = new Object[mappingCount];
                                for (int i = 0; i < mappingCount; ++i) {
                                    result[i] = mappings[i].apply(a);
                                }
                                return new IndexerKey(result);
                            };
                        }
                    };
                    Function keyFunction = v1;
                    keyFunctionList.add(keyFunction);
                    startIndexInclusive = endIndexExclusive;
                }
                int keyFunctionCount = keyFunctionList.size();
                switch (keyFunctionCount) {
                    case 1: {
                        Function keyFunction = (Function)keyFunctionList.get(0);
                        yield a -> new SingleIndexProperties(keyFunction.apply(a));
                    }
                    case 2: {
                        Function keyFunction1 = (Function)keyFunctionList.get(0);
                        Function keyFunction2 = (Function)keyFunctionList.get(1);
                        yield a -> new TwoIndexProperties(keyFunction1.apply(a), keyFunction2.apply(a));
                    }
                    case 3: {
                        Function keyFunction1 = (Function)keyFunctionList.get(0);
                        Function keyFunction2 = (Function)keyFunctionList.get(1);
                        Function keyFunction3 = (Function)keyFunctionList.get(2);
                        yield a -> new ThreeIndexProperties(keyFunction1.apply(a), keyFunction2.apply(a), keyFunction3.apply(a));
                    }
                }
                yield a -> {
                    Object[] arr = new Object[keyFunctionCount];
                    for (int i = 0; i < keyFunctionCount; ++i) {
                        arr[i] = ((Function)keyFunctionList.get(i)).apply(a);
                    }
                    return new ManyIndexProperties(arr);
                };
            }
        };
    }

    public <A, B> BiFunction<A, B, IndexProperties> buildBiLeftMapping() {
        int joinerCount = this.joiner.getJoinerCount();
        DefaultTriJoiner castJoiner = (DefaultTriJoiner)this.joiner;
        return switch (joinerCount) {
            case 0 -> (a, b) -> NoneIndexProperties.INSTANCE;
            case 1 -> {
                BiFunction mapping = castJoiner.getLeftMapping(0);
                yield (a, b) -> new SingleIndexProperties(mapping.apply(a, b));
            }
            default -> {
                int startIndexInclusive = 0;
                ArrayList keyFunctionList = new ArrayList();
                for (Map.Entry entry : this.joinerTypeMap.entrySet()) {
                    Integer endIndexExclusive = (Integer)entry.getKey();
                    int keyFunctionLength = endIndexExclusive - startIndexInclusive;
                    BiFunction<Object, Object, Object> v1 = switch (keyFunctionLength) {
                        case 1 -> castJoiner.getLeftMapping(startIndexInclusive);
                        case 2 -> {
                            BiFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                            BiFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                            yield (a, b) -> new Pair(mapping1.apply(a, b), mapping2.apply(a, b));
                        }
                        case 3 -> {
                            BiFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                            BiFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                            BiFunction mapping3 = castJoiner.getLeftMapping(startIndexInclusive + 2);
                            yield (a, b) -> new Triple(mapping1.apply(a, b), mapping2.apply(a, b), mapping3.apply(a, b));
                        }
                        case 4 -> {
                            BiFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                            BiFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                            BiFunction mapping3 = castJoiner.getLeftMapping(startIndexInclusive + 2);
                            BiFunction mapping4 = castJoiner.getLeftMapping(startIndexInclusive + 3);
                            yield (a, b) -> new Quadruple(mapping1.apply(a, b), mapping2.apply(a, b), mapping3.apply(a, b), mapping4.apply(a, b));
                        }
                        default -> {
                            BiFunction[] mappings = new BiFunction[joinerCount];
                            for (int i = 0; i < joinerCount; ++i) {
                                BiFunction mapping;
                                mappings[i] = mapping = castJoiner.getLeftMapping(i);
                            }
                            yield (a, b) -> {
                                int mappingCount = mappings.length;
                                Object[] result = new Object[mappingCount];
                                for (int i = 0; i < mappingCount; ++i) {
                                    result[i] = mappings[i].apply(a, b);
                                }
                                return new IndexerKey(result);
                            };
                        }
                    };
                    BiFunction keyFunction = v1;
                    keyFunctionList.add(keyFunction);
                    startIndexInclusive = endIndexExclusive;
                }
                int keyFunctionCount = keyFunctionList.size();
                switch (keyFunctionCount) {
                    case 1: {
                        BiFunction keyFunction = (BiFunction)keyFunctionList.get(0);
                        yield (a, b) -> new SingleIndexProperties(keyFunction.apply(a, b));
                    }
                    case 2: {
                        BiFunction keyFunction1 = (BiFunction)keyFunctionList.get(0);
                        BiFunction keyFunction2 = (BiFunction)keyFunctionList.get(1);
                        yield (a, b) -> new TwoIndexProperties(keyFunction1.apply(a, b), keyFunction2.apply(a, b));
                    }
                    case 3: {
                        BiFunction keyFunction1 = (BiFunction)keyFunctionList.get(0);
                        BiFunction keyFunction2 = (BiFunction)keyFunctionList.get(1);
                        BiFunction keyFunction3 = (BiFunction)keyFunctionList.get(2);
                        yield (a, b) -> new ThreeIndexProperties(keyFunction1.apply(a, b), keyFunction2.apply(a, b), keyFunction3.apply(a, b));
                    }
                }
                yield (a, b) -> {
                    Object[] arr = new Object[keyFunctionCount];
                    for (int i = 0; i < keyFunctionCount; ++i) {
                        arr[i] = ((BiFunction)keyFunctionList.get(i)).apply(a, b);
                    }
                    return new ManyIndexProperties(arr);
                };
            }
        };
    }

    public <A, B, C> TriFunction<A, B, C, IndexProperties> buildTriLeftMapping() {
        int joinerCount = this.joiner.getJoinerCount();
        DefaultQuadJoiner castJoiner = (DefaultQuadJoiner)this.joiner;
        return switch (joinerCount) {
            case 0 -> (a, b, c) -> NoneIndexProperties.INSTANCE;
            case 1 -> {
                TriFunction mapping = castJoiner.getLeftMapping(0);
                yield (a, b, c) -> new SingleIndexProperties(mapping.apply(a, b, c));
            }
            default -> {
                int startIndexInclusive = 0;
                ArrayList keyFunctionList = new ArrayList();
                for (Map.Entry entry : this.joinerTypeMap.entrySet()) {
                    Integer endIndexExclusive = (Integer)entry.getKey();
                    int keyFunctionLength = endIndexExclusive - startIndexInclusive;
                    TriFunction<Object, Object, Object, Object> v1 = switch (keyFunctionLength) {
                        case 1 -> castJoiner.getLeftMapping(startIndexInclusive);
                        case 2 -> {
                            TriFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                            TriFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                            yield (a, b, c) -> new Pair(mapping1.apply(a, b, c), mapping2.apply(a, b, c));
                        }
                        case 3 -> {
                            TriFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                            TriFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                            TriFunction mapping3 = castJoiner.getLeftMapping(startIndexInclusive + 2);
                            yield (a, b, c) -> new Triple(mapping1.apply(a, b, c), mapping2.apply(a, b, c), mapping3.apply(a, b, c));
                        }
                        case 4 -> {
                            TriFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                            TriFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                            TriFunction mapping3 = castJoiner.getLeftMapping(startIndexInclusive + 2);
                            TriFunction mapping4 = castJoiner.getLeftMapping(startIndexInclusive + 3);
                            yield (a, b, c) -> new Quadruple(mapping1.apply(a, b, c), mapping2.apply(a, b, c), mapping3.apply(a, b, c), mapping4.apply(a, b, c));
                        }
                        default -> {
                            TriFunction[] mappings = new TriFunction[joinerCount];
                            for (int i = 0; i < joinerCount; ++i) {
                                TriFunction mapping;
                                mappings[i] = mapping = castJoiner.getLeftMapping(i);
                            }
                            yield (a, b, c) -> {
                                int mappingCount = mappings.length;
                                Object[] result = new Object[mappingCount];
                                for (int i = 0; i < mappingCount; ++i) {
                                    result[i] = mappings[i].apply(a, b, c);
                                }
                                return new IndexerKey(result);
                            };
                        }
                    };
                    TriFunction keyFunction = v1;
                    keyFunctionList.add(keyFunction);
                    startIndexInclusive = endIndexExclusive;
                }
                int keyFunctionCount = keyFunctionList.size();
                switch (keyFunctionCount) {
                    case 1: {
                        TriFunction keyFunction = (TriFunction)keyFunctionList.get(0);
                        yield (a, b, c) -> new SingleIndexProperties(keyFunction.apply(a, b, c));
                    }
                    case 2: {
                        TriFunction keyFunction1 = (TriFunction)keyFunctionList.get(0);
                        TriFunction keyFunction2 = (TriFunction)keyFunctionList.get(1);
                        yield (a, b, c) -> new TwoIndexProperties(keyFunction1.apply(a, b, c), keyFunction2.apply(a, b, c));
                    }
                    case 3: {
                        TriFunction keyFunction1 = (TriFunction)keyFunctionList.get(0);
                        TriFunction keyFunction2 = (TriFunction)keyFunctionList.get(1);
                        TriFunction keyFunction3 = (TriFunction)keyFunctionList.get(2);
                        yield (a, b, c) -> new ThreeIndexProperties(keyFunction1.apply(a, b, c), keyFunction2.apply(a, b, c), keyFunction3.apply(a, b, c));
                    }
                }
                yield (a, b, c) -> {
                    Object[] arr = new Object[keyFunctionCount];
                    for (int i = 0; i < keyFunctionCount; ++i) {
                        arr[i] = ((TriFunction)keyFunctionList.get(i)).apply(a, b, c);
                    }
                    return new ManyIndexProperties(arr);
                };
            }
        };
    }

    public <A, B, C, D> QuadFunction<A, B, C, D, IndexProperties> buildQuadLeftMapping() {
        int joinerCount = this.joiner.getJoinerCount();
        DefaultPentaJoiner castJoiner = (DefaultPentaJoiner)this.joiner;
        return switch (joinerCount) {
            case 0 -> (a, b, c, d) -> NoneIndexProperties.INSTANCE;
            case 1 -> {
                QuadFunction mapping = castJoiner.getLeftMapping(0);
                yield (a, b, c, d) -> new SingleIndexProperties(mapping.apply(a, b, c, d));
            }
            default -> {
                int startIndexInclusive = 0;
                ArrayList keyFunctionList = new ArrayList();
                for (Map.Entry entry : this.joinerTypeMap.entrySet()) {
                    Integer endIndexExclusive = (Integer)entry.getKey();
                    int keyFunctionLength = endIndexExclusive - startIndexInclusive;
                    QuadFunction<Object, Object, Object, Object, Object> v1 = switch (keyFunctionLength) {
                        case 1 -> castJoiner.getLeftMapping(startIndexInclusive);
                        case 2 -> {
                            QuadFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                            QuadFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                            yield (a, b, c, d) -> new Pair(mapping1.apply(a, b, c, d), mapping2.apply(a, b, c, d));
                        }
                        case 3 -> {
                            QuadFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                            QuadFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                            QuadFunction mapping3 = castJoiner.getLeftMapping(startIndexInclusive + 2);
                            yield (a, b, c, d) -> new Triple(mapping1.apply(a, b, c, d), mapping2.apply(a, b, c, d), mapping3.apply(a, b, c, d));
                        }
                        case 4 -> {
                            QuadFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                            QuadFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                            QuadFunction mapping3 = castJoiner.getLeftMapping(startIndexInclusive + 2);
                            QuadFunction mapping4 = castJoiner.getLeftMapping(startIndexInclusive + 3);
                            yield (a, b, c, d) -> new Quadruple(mapping1.apply(a, b, c, d), mapping2.apply(a, b, c, d), mapping3.apply(a, b, c, d), mapping4.apply(a, b, c, d));
                        }
                        default -> {
                            QuadFunction[] mappings = new QuadFunction[joinerCount];
                            for (int i = 0; i < joinerCount; ++i) {
                                QuadFunction mapping;
                                mappings[i] = mapping = castJoiner.getLeftMapping(i);
                            }
                            yield (a, b, c, d) -> {
                                int mappingCount = mappings.length;
                                Object[] result = new Object[mappingCount];
                                for (int i = 0; i < mappingCount; ++i) {
                                    result[i] = mappings[i].apply(a, b, c, d);
                                }
                                return new IndexerKey(result);
                            };
                        }
                    };
                    QuadFunction keyFunction = v1;
                    keyFunctionList.add(keyFunction);
                    startIndexInclusive = endIndexExclusive;
                }
                int keyFunctionCount = keyFunctionList.size();
                switch (keyFunctionList.size()) {
                    case 1: {
                        QuadFunction keyFunction = (QuadFunction)keyFunctionList.get(0);
                        yield (a, b, c, d) -> new SingleIndexProperties(keyFunction.apply(a, b, c, d));
                    }
                    case 2: {
                        QuadFunction keyFunction1 = (QuadFunction)keyFunctionList.get(0);
                        QuadFunction keyFunction2 = (QuadFunction)keyFunctionList.get(1);
                        yield (a, b, c, d) -> new TwoIndexProperties(keyFunction1.apply(a, b, c, d), keyFunction2.apply(a, b, c, d));
                    }
                    case 3: {
                        QuadFunction keyFunction1 = (QuadFunction)keyFunctionList.get(0);
                        QuadFunction keyFunction2 = (QuadFunction)keyFunctionList.get(1);
                        QuadFunction keyFunction3 = (QuadFunction)keyFunctionList.get(2);
                        yield (a, b, c, d) -> new ThreeIndexProperties(keyFunction1.apply(a, b, c, d), keyFunction2.apply(a, b, c, d), keyFunction3.apply(a, b, c, d));
                    }
                }
                yield (a, b, c, d) -> {
                    Object[] arr = new Object[keyFunctionCount];
                    for (int i = 0; i < keyFunctionCount; ++i) {
                        arr[i] = ((QuadFunction)keyFunctionList.get(i)).apply(a, b, c, d);
                    }
                    return new ManyIndexProperties(arr);
                };
            }
        };
    }

    public Function<Right_, IndexProperties> buildRightMapping() {
        int joinerCount = this.joiner.getJoinerCount();
        return switch (joinerCount) {
            case 0 -> a -> NoneIndexProperties.INSTANCE;
            case 1 -> {
                Function mapping = this.joiner.getRightMapping(0);
                yield a -> new SingleIndexProperties(mapping.apply(a));
            }
            default -> {
                int startIndexInclusive = 0;
                ArrayList keyFunctionList = new ArrayList();
                for (Map.Entry entry : this.joinerTypeMap.entrySet()) {
                    Integer endIndexExclusive = (Integer)entry.getKey();
                    int keyFunctionLength = endIndexExclusive - startIndexInclusive;
                    Function<Object, Object> v1 = switch (keyFunctionLength) {
                        case 1 -> this.joiner.getRightMapping(startIndexInclusive);
                        case 2 -> {
                            Function mapping1 = this.joiner.getRightMapping(startIndexInclusive);
                            Function mapping2 = this.joiner.getRightMapping(startIndexInclusive + 1);
                            yield a -> new Pair(mapping1.apply(a), mapping2.apply(a));
                        }
                        case 3 -> {
                            Function mapping1 = this.joiner.getRightMapping(startIndexInclusive);
                            Function mapping2 = this.joiner.getRightMapping(startIndexInclusive + 1);
                            Function mapping3 = this.joiner.getRightMapping(startIndexInclusive + 2);
                            yield a -> new Triple(mapping1.apply(a), mapping2.apply(a), mapping3.apply(a));
                        }
                        case 4 -> {
                            Function mapping1 = this.joiner.getRightMapping(startIndexInclusive);
                            Function mapping2 = this.joiner.getRightMapping(startIndexInclusive + 1);
                            Function mapping3 = this.joiner.getRightMapping(startIndexInclusive + 2);
                            Function mapping4 = this.joiner.getRightMapping(startIndexInclusive + 3);
                            yield a -> new Quadruple(mapping1.apply(a), mapping2.apply(a), mapping3.apply(a), mapping4.apply(a));
                        }
                        default -> {
                            Function[] mappings = new Function[joinerCount];
                            for (int i = 0; i < joinerCount; ++i) {
                                Function<Right_, Object> mapping;
                                mappings[i] = mapping = this.joiner.getRightMapping(i);
                            }
                            yield a -> {
                                int mappingCount = mappings.length;
                                Object[] result = new Object[mappingCount];
                                for (int i = 0; i < mappingCount; ++i) {
                                    result[i] = mappings[i].apply(a);
                                }
                                return new IndexerKey(result);
                            };
                        }
                    };
                    Function<Right_, Object> keyFunction = v1;
                    keyFunctionList.add(keyFunction);
                    startIndexInclusive = endIndexExclusive;
                }
                int keyFunctionCount = keyFunctionList.size();
                switch (keyFunctionCount) {
                    case 1: {
                        Function keyFunction = (Function)keyFunctionList.get(0);
                        yield a -> new SingleIndexProperties(keyFunction.apply(a));
                    }
                    case 2: {
                        Function keyFunction1 = (Function)keyFunctionList.get(0);
                        Function keyFunction2 = (Function)keyFunctionList.get(1);
                        yield a -> new TwoIndexProperties(keyFunction1.apply(a), keyFunction2.apply(a));
                    }
                    case 3: {
                        Function keyFunction1 = (Function)keyFunctionList.get(0);
                        Function keyFunction2 = (Function)keyFunctionList.get(1);
                        Function keyFunction3 = (Function)keyFunctionList.get(2);
                        yield a -> new ThreeIndexProperties(keyFunction1.apply(a), keyFunction2.apply(a), keyFunction3.apply(a));
                    }
                }
                yield a -> {
                    Object[] arr = new Object[keyFunctionCount];
                    for (int i = 0; i < keyFunctionCount; ++i) {
                        arr[i] = ((Function)keyFunctionList.get(i)).apply(a);
                    }
                    return new ManyIndexProperties(arr);
                };
            }
        };
    }

    public <T> Indexer<T> buildIndexer(boolean isLeftBridge) {
        if (!this.hasJoiners()) {
            return new NoneIndexer();
        }
        if (this.joiner.getJoinerCount() == 1) {
            JoinerType joinerType = this.joiner.getJoinerType(0);
            if (joinerType == JoinerType.EQUAL) {
                return new EqualsIndexer(NoneIndexer::new);
            }
            return new ComparisonIndexer(isLeftBridge ? joinerType : joinerType.flip(), NoneIndexer::new);
        }
        NavigableMap<Integer, JoinerType> descendingJoinerTypeMap = this.joinerTypeMap.descendingMap();
        Supplier<Indexer> downstreamIndexerSupplier = NoneIndexer::new;
        int indexPropertyId = descendingJoinerTypeMap.size() - 1;
        for (Map.Entry entry : descendingJoinerTypeMap.entrySet()) {
            JoinerType joinerType = (JoinerType)((Object)entry.getValue());
            Supplier<Indexer> actualDownstreamIndexerSupplier = downstreamIndexerSupplier;
            int effectivelyFinalIndexPropertyId = indexPropertyId;
            if (joinerType == JoinerType.EQUAL) {
                downstreamIndexerSupplier = () -> new EqualsIndexer(effectivelyFinalIndexPropertyId, actualDownstreamIndexerSupplier);
            } else {
                JoinerType actualJoinerType = isLeftBridge ? joinerType : joinerType.flip();
                downstreamIndexerSupplier = () -> new ComparisonIndexer(actualJoinerType, effectivelyFinalIndexPropertyId, actualDownstreamIndexerSupplier);
            }
            --indexPropertyId;
        }
        return downstreamIndexerSupplier.get();
    }
}

