/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.quad;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.common.AbstractConcatNode;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetConcatConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.NodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetForeBridgeBiConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetForeBridgeQuadConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.QuadTuple;
import ai.timefold.solver.core.impl.score.stream.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.score.stream.bavet.quad.BavetAbstractQuadConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.quad.ConcatBiQuadNode;
import ai.timefold.solver.core.impl.score.stream.bavet.quad.ConcatQuadBiNode;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;

public final class BavetBiConcatQuadConstraintStream<Solution_, A, B, C, D>
extends BavetAbstractQuadConstraintStream<Solution_, A, B, C, D>
implements BavetConcatConstraintStream<Solution_> {
    private final BavetAbstractConstraintStream<Solution_> leftParent;
    private final BavetAbstractConstraintStream<Solution_> rightParent;
    private final BiFunction<A, B, C> paddingFunctionC;
    private final BiFunction<A, B, D> paddingFunctionD;
    private final ConcatNodeConstructor<A, B, C, D> nodeConstructor;

    public BavetBiConcatQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeBiConstraintStream<Solution_, A, B> leftParent, BavetForeBridgeQuadConstraintStream<Solution_, A, B, C, D> rightParent, BiFunction<A, B, C> paddingFunctionC, BiFunction<A, B, D> paddingFunctionD) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.paddingFunctionC = paddingFunctionC;
        this.paddingFunctionD = paddingFunctionD;
        this.nodeConstructor = ConcatBiQuadNode::new;
    }

    public BavetBiConcatQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeQuadConstraintStream<Solution_, A, B, C, D> leftParent, BavetForeBridgeBiConstraintStream<Solution_, A, B> rightParent, BiFunction<A, B, C> paddingFunctionC, BiFunction<A, B, D> paddingFunctionD) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.paddingFunctionC = paddingFunctionC;
        this.paddingFunctionD = paddingFunctionD;
        this.nodeConstructor = ConcatQuadBiNode::new;
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.leftParent.guaranteesDistinct() && this.rightParent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.leftParent.collectActiveConstraintStreams(constraintStreamSet);
        this.rightParent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        TupleLifecycle downstream = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        int leftCloneStoreIndex = buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource());
        int rightCloneStoreIndex = buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource());
        int outputStoreSize = buildHelper.extractTupleStoreSize(this);
        AbstractConcatNode<?, ?, ?> node = this.nodeConstructor.apply(this.paddingFunctionC, this.paddingFunctionD, downstream, leftCloneStoreIndex, rightCloneStoreIndex, outputStoreSize);
        buildHelper.addNode(node, this, this.leftParent, this.rightParent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BavetBiConcatQuadConstraintStream other = (BavetBiConcatQuadConstraintStream)o;
        return Objects.equals(this.leftParent.getParent(), other.leftParent.getParent()) && Objects.equals(this.rightParent.getParent(), other.rightParent.getParent());
    }

    public int hashCode() {
        return Objects.hash(this.leftParent.getParent(), this.rightParent.getParent());
    }

    public String toString() {
        return "BiConcat() with " + this.childStreamList.size() + " children";
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getLeftParent() {
        return this.leftParent;
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getRightParent() {
        return this.rightParent;
    }

    private static interface ConcatNodeConstructor<A, B, C, D> {
        public AbstractConcatNode<?, ?, ?> apply(BiFunction<A, B, C> var1, BiFunction<A, B, D> var2, TupleLifecycle<QuadTuple<A, B, C, D>> var3, int var4, int var5, int var6);
    }
}

