/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.tri;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.ToIntTriFunction;
import ai.timefold.solver.core.api.function.ToLongTriFunction;
import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraint;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetScoringConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.NodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.tri.BavetAbstractTriConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.tri.TriScorer;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraint;
import ai.timefold.solver.core.impl.score.stream.common.inliner.ConstraintMatchSupplier;
import ai.timefold.solver.core.impl.score.stream.common.inliner.ScoreContext;
import ai.timefold.solver.core.impl.score.stream.common.inliner.UndoScoreImpacter;
import ai.timefold.solver.core.impl.score.stream.common.inliner.WeightedScoreImpacter;
import java.math.BigDecimal;

final class BavetScoringTriConstraintStream<Solution_, A, B, C>
extends BavetAbstractTriConstraintStream<Solution_, A, B, C>
implements BavetScoringConstraintStream<Solution_> {
    private final ToIntTriFunction<A, B, C> intMatchWeigher;
    private final ToLongTriFunction<A, B, C> longMatchWeigher;
    private final TriFunction<A, B, C, BigDecimal> bigDecimalMatchWeigher;
    private BavetConstraint<Solution_> constraint;

    public BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, ToIntTriFunction<A, B, C> intMatchWeigher) {
        this(constraintFactory, parent, intMatchWeigher, null, null);
        if (intMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, ToLongTriFunction<A, B, C> longMatchWeigher) {
        this(constraintFactory, parent, null, longMatchWeigher, null);
        if (longMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, TriFunction<A, B, C, BigDecimal> bigDecimalMatchWeigher) {
        this(constraintFactory, parent, null, null, bigDecimalMatchWeigher);
        if (bigDecimalMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    private BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, ToIntTriFunction<A, B, C> intMatchWeigher, ToLongTriFunction<A, B, C> longMatchWeigher, TriFunction<A, B, C, BigDecimal> bigDecimalMatchWeigher) {
        super(constraintFactory, parent);
        this.intMatchWeigher = intMatchWeigher;
        this.longMatchWeigher = longMatchWeigher;
        this.bigDecimalMatchWeigher = bigDecimalMatchWeigher;
    }

    @Override
    public void setConstraint(BavetConstraint<Solution_> constraint) {
        this.constraint = constraint;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        this.assertEmptyChildStreamList();
        QuadFunction<WeightedScoreImpacter<?, ?>, A, B, C, UndoScoreImpacter> scoreImpacter = this.buildScoreImpacter(buildHelper.getScoreInliner().getConstraintMatchPolicy());
        WeightedScoreImpacter<Score_, ?> weightedScoreImpacter = buildHelper.getScoreInliner().buildWeightedScoreImpacter(this.constraint);
        TriScorer<A, B, C> scorer = new TriScorer<A, B, C>(weightedScoreImpacter, scoreImpacter, buildHelper.reserveTupleStoreIndex(this.parent.getTupleSource()));
        buildHelper.putInsertUpdateRetract(this, scorer);
    }

    private QuadFunction<WeightedScoreImpacter<?, ?>, A, B, C, UndoScoreImpacter> buildScoreImpacter(ConstraintMatchPolicy constraintMatchPolicy) {
        return switch (constraintMatchPolicy) {
            default -> throw new IncompatibleClassChangeError();
            case ConstraintMatchPolicy.DISABLED -> this.buildScoreImpacter();
            case ConstraintMatchPolicy.ENABLED -> this.buildScoreImpacterWithConstraintMatch();
            case ConstraintMatchPolicy.ENABLED_WITHOUT_JUSTIFICATIONS -> this.buildScoreImpacterWithConstraintMatchNoJustifications();
        };
    }

    private QuadFunction<WeightedScoreImpacter<?, ?>, A, B, C, UndoScoreImpacter> buildScoreImpacter() {
        if (this.intMatchWeigher != null) {
            return (impacter, a, b, c) -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a, b, c);
                return impacter.impactScore(matchWeight, null);
            };
        }
        if (this.longMatchWeigher != null) {
            return (impacter, a, b, c) -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a, b, c);
                return impacter.impactScore(matchWeight, null);
            };
        }
        if (this.bigDecimalMatchWeigher != null) {
            return (impacter, a, b, c) -> {
                BigDecimal matchWeight = this.bigDecimalMatchWeigher.apply(a, b, c);
                return impacter.impactScore(matchWeight, null);
            };
        }
        throw new IllegalStateException("Impossible state: neither of the supported match weighers provided.");
    }

    private QuadFunction<WeightedScoreImpacter<?, ?>, A, B, C, UndoScoreImpacter> buildScoreImpacterWithConstraintMatch() {
        if (this.intMatchWeigher != null) {
            return (impacter, a, b, c) -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a, b, c);
                return BavetScoringTriConstraintStream.impactWithConstraintMatch(impacter, matchWeight, a, b, c);
            };
        }
        if (this.longMatchWeigher != null) {
            return (impacter, a, b, c) -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a, b, c);
                return BavetScoringTriConstraintStream.impactWithConstraintMatch(impacter, matchWeight, a, b, c);
            };
        }
        if (this.bigDecimalMatchWeigher != null) {
            return (impacter, a, b, c) -> {
                BigDecimal matchWeight = this.bigDecimalMatchWeigher.apply(a, b, c);
                return BavetScoringTriConstraintStream.impactWithConstraintMatch(impacter, matchWeight, a, b, c);
            };
        }
        throw new IllegalStateException("Impossible state: neither of the supported match weighers provided.");
    }

    private static <A, B, C, Score_ extends Score<Score_>> UndoScoreImpacter impactWithConstraintMatch(WeightedScoreImpacter<Score_, ?> impacter, int matchWeight, A a, B b, C c) {
        AbstractConstraint<?, ?, ?> constraint = ((ScoreContext)impacter.getContext()).getConstraint();
        ConstraintMatchSupplier constraintMatchSupplier = ConstraintMatchSupplier.of((QuadFunction)constraint.getJustificationMapping(), (TriFunction)constraint.getIndictedObjectsMapping(), a, b, c);
        return impacter.impactScore(matchWeight, constraintMatchSupplier);
    }

    private static <A, B, C, Score_ extends Score<Score_>> UndoScoreImpacter impactWithConstraintMatch(WeightedScoreImpacter<Score_, ?> impacter, long matchWeight, A a, B b, C c) {
        AbstractConstraint<?, ?, ?> constraint = ((ScoreContext)impacter.getContext()).getConstraint();
        ConstraintMatchSupplier constraintMatchSupplier = ConstraintMatchSupplier.of((QuadFunction)constraint.getJustificationMapping(), (TriFunction)constraint.getIndictedObjectsMapping(), a, b, c);
        return impacter.impactScore(matchWeight, constraintMatchSupplier);
    }

    private static <A, B, C, Score_ extends Score<Score_>> UndoScoreImpacter impactWithConstraintMatch(WeightedScoreImpacter<Score_, ?> impacter, BigDecimal matchWeight, A a, B b, C c) {
        AbstractConstraint<?, ?, ?> constraint = ((ScoreContext)impacter.getContext()).getConstraint();
        ConstraintMatchSupplier constraintMatchSupplier = ConstraintMatchSupplier.of((QuadFunction)constraint.getJustificationMapping(), (TriFunction)constraint.getIndictedObjectsMapping(), a, b, c);
        return impacter.impactScore(matchWeight, constraintMatchSupplier);
    }

    private QuadFunction<WeightedScoreImpacter<?, ?>, A, B, C, UndoScoreImpacter> buildScoreImpacterWithConstraintMatchNoJustifications() {
        if (this.intMatchWeigher != null) {
            return (impacter, a, b, c) -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a, b, c);
                return BavetScoringConstraintStream.impactWithConstraintMatchNoJustifications(impacter, matchWeight);
            };
        }
        if (this.longMatchWeigher != null) {
            return (impacter, a, b, c) -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a, b, c);
                return BavetScoringConstraintStream.impactWithConstraintMatchNoJustifications(impacter, matchWeight);
            };
        }
        if (this.bigDecimalMatchWeigher != null) {
            return (impacter, a, b, c) -> {
                BigDecimal matchWeight = this.bigDecimalMatchWeigher.apply(a, b, c);
                return BavetScoringConstraintStream.impactWithConstraintMatchNoJustifications(impacter, matchWeight);
            };
        }
        throw new IllegalStateException("Impossible state: neither of the supported match weighers provided.");
    }

    public String toString() {
        return "Scoring(" + this.constraint.getConstraintRef() + ")";
    }
}

