/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.uni;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.common.NodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetAftBridgeQuadConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.BavetAbstractUniConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.MapUniToQuadNode;
import java.util.Objects;
import java.util.function.Function;

final class BavetQuadMapUniConstraintStream<Solution_, A, NewA, NewB, NewC, NewD>
extends BavetAbstractUniConstraintStream<Solution_, A> {
    private final Function<A, NewA> mappingFunctionA;
    private final Function<A, NewB> mappingFunctionB;
    private final Function<A, NewC> mappingFunctionC;
    private final Function<A, NewD> mappingFunctionD;
    private final boolean guaranteesDistinct;
    private BavetAftBridgeQuadConstraintStream<Solution_, NewA, NewB, NewC, NewD> aftStream;

    public BavetQuadMapUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, Function<A, NewA> mappingFunctionA, Function<A, NewB> mappingFunctionB, Function<A, NewC> mappingFunctionC, Function<A, NewD> mappingFunctionD, boolean isExpand) {
        super(constraintFactory, parent);
        this.mappingFunctionA = mappingFunctionA;
        this.mappingFunctionB = mappingFunctionB;
        this.mappingFunctionC = mappingFunctionC;
        this.mappingFunctionD = mappingFunctionD;
        this.guaranteesDistinct = isExpand && parent.guaranteesDistinct();
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.guaranteesDistinct;
    }

    public void setAftBridge(BavetAftBridgeQuadConstraintStream<Solution_, NewA, NewB, NewC, NewD> aftStream) {
        this.aftStream = aftStream;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        this.assertEmptyChildStreamList();
        int inputStoreIndex = buildHelper.reserveTupleStoreIndex(this.parent.getTupleSource());
        int outputStoreSize = buildHelper.extractTupleStoreSize(this.aftStream);
        MapUniToQuadNode<A, NewA, NewB, NewC, NewD> node = new MapUniToQuadNode<A, NewA, NewB, NewC, NewD>(inputStoreIndex, this.mappingFunctionA, this.mappingFunctionB, this.mappingFunctionC, this.mappingFunctionD, buildHelper.getAggregatedTupleLifecycle(this.aftStream.getChildStreamList()), outputStoreSize);
        buildHelper.addNode(node, this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BavetQuadMapUniConstraintStream that = (BavetQuadMapUniConstraintStream)object;
        return Objects.equals(this.parent, that.parent) && this.guaranteesDistinct == that.guaranteesDistinct && Objects.equals(this.mappingFunctionA, that.mappingFunctionA) && Objects.equals(this.mappingFunctionB, that.mappingFunctionB) && Objects.equals(this.mappingFunctionC, that.mappingFunctionC) && Objects.equals(this.mappingFunctionD, that.mappingFunctionD);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.mappingFunctionA, this.mappingFunctionB, this.mappingFunctionC, this.mappingFunctionD, this.guaranteesDistinct);
    }

    public String toString() {
        return "QuadMap()";
    }
}

