/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.uni;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraint;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetScoringConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.NodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.BavetAbstractUniConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.UniScorer;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraint;
import ai.timefold.solver.core.impl.score.stream.common.inliner.ConstraintMatchSupplier;
import ai.timefold.solver.core.impl.score.stream.common.inliner.ScoreContext;
import ai.timefold.solver.core.impl.score.stream.common.inliner.UndoScoreImpacter;
import ai.timefold.solver.core.impl.score.stream.common.inliner.WeightedScoreImpacter;
import java.math.BigDecimal;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

final class BavetScoringUniConstraintStream<Solution_, A>
extends BavetAbstractUniConstraintStream<Solution_, A>
implements BavetScoringConstraintStream<Solution_> {
    private final ToIntFunction<A> intMatchWeigher;
    private final ToLongFunction<A> longMatchWeigher;
    private final Function<A, BigDecimal> bigDecimalMatchWeigher;
    private BavetConstraint<Solution_> constraint;

    public BavetScoringUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, ToIntFunction<A> intMatchWeigher) {
        this(constraintFactory, parent, intMatchWeigher, null, null);
        if (intMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, ToLongFunction<A> longMatchWeigher) {
        this(constraintFactory, parent, null, longMatchWeigher, null);
        if (longMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, Function<A, BigDecimal> bigDecimalMatchWeigher) {
        this(constraintFactory, parent, null, null, bigDecimalMatchWeigher);
        if (bigDecimalMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    private BavetScoringUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, ToIntFunction<A> intMatchWeigher, ToLongFunction<A> longMatchWeigher, Function<A, BigDecimal> bigDecimalMatchWeigher) {
        super(constraintFactory, parent);
        this.intMatchWeigher = intMatchWeigher;
        this.longMatchWeigher = longMatchWeigher;
        this.bigDecimalMatchWeigher = bigDecimalMatchWeigher;
    }

    @Override
    public void setConstraint(BavetConstraint<Solution_> constraint) {
        this.constraint = constraint;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        this.assertEmptyChildStreamList();
        BiFunction<WeightedScoreImpacter<?, ?>, A, UndoScoreImpacter> scoreImpacter = this.buildScoreImpacter(buildHelper.getScoreInliner().getConstraintMatchPolicy());
        WeightedScoreImpacter<Score_, ?> weightedScoreImpacter = buildHelper.getScoreInliner().buildWeightedScoreImpacter(this.constraint);
        UniScorer<A> scorer = new UniScorer<A>(weightedScoreImpacter, scoreImpacter, buildHelper.reserveTupleStoreIndex(this.parent.getTupleSource()));
        buildHelper.putInsertUpdateRetract(this, scorer);
    }

    private BiFunction<WeightedScoreImpacter<?, ?>, A, UndoScoreImpacter> buildScoreImpacter(ConstraintMatchPolicy constraintMatchPolicy) {
        return switch (constraintMatchPolicy) {
            default -> throw new IncompatibleClassChangeError();
            case ConstraintMatchPolicy.DISABLED -> this.buildScoreImpacter();
            case ConstraintMatchPolicy.ENABLED -> this.buildScoreImpacterWithConstraintMatch();
            case ConstraintMatchPolicy.ENABLED_WITHOUT_JUSTIFICATIONS -> this.buildScoreImpacterWithConstraintMatchNoJustifications();
        };
    }

    private BiFunction<WeightedScoreImpacter<?, ?>, A, UndoScoreImpacter> buildScoreImpacter() {
        if (this.intMatchWeigher != null) {
            return (impacter, a) -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a);
                return impacter.impactScore(matchWeight, null);
            };
        }
        if (this.longMatchWeigher != null) {
            return (impacter, a) -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a);
                return impacter.impactScore(matchWeight, null);
            };
        }
        if (this.bigDecimalMatchWeigher != null) {
            return (impacter, a) -> {
                BigDecimal matchWeight = this.bigDecimalMatchWeigher.apply(a);
                return impacter.impactScore(matchWeight, null);
            };
        }
        throw new IllegalStateException("Impossible state: neither of the supported match weighers provided.");
    }

    private BiFunction<WeightedScoreImpacter<?, ?>, A, UndoScoreImpacter> buildScoreImpacterWithConstraintMatch() {
        if (this.intMatchWeigher != null) {
            return (impacter, a) -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a);
                return BavetScoringUniConstraintStream.impactWithConstraintMatch(impacter, matchWeight, a);
            };
        }
        if (this.longMatchWeigher != null) {
            return (impacter, a) -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a);
                return BavetScoringUniConstraintStream.impactWithConstraintMatch(impacter, matchWeight, a);
            };
        }
        if (this.bigDecimalMatchWeigher != null) {
            return (impacter, a) -> {
                BigDecimal matchWeight = this.bigDecimalMatchWeigher.apply(a);
                return BavetScoringUniConstraintStream.impactWithConstraintMatch(impacter, matchWeight, a);
            };
        }
        throw new IllegalStateException("Impossible state: neither of the supported match weighers provided.");
    }

    private static <A, Score_ extends Score<Score_>> UndoScoreImpacter impactWithConstraintMatch(WeightedScoreImpacter<Score_, ?> impacter, int matchWeight, A a) {
        AbstractConstraint<?, ?, ?> constraint = ((ScoreContext)impacter.getContext()).getConstraint();
        ConstraintMatchSupplier constraintMatchSupplier = ConstraintMatchSupplier.of((BiFunction)constraint.getJustificationMapping(), (Function)constraint.getIndictedObjectsMapping(), a);
        return impacter.impactScore(matchWeight, constraintMatchSupplier);
    }

    private static <A, Score_ extends Score<Score_>> UndoScoreImpacter impactWithConstraintMatch(WeightedScoreImpacter<Score_, ?> impacter, long matchWeight, A a) {
        AbstractConstraint<?, ?, ?> constraint = ((ScoreContext)impacter.getContext()).getConstraint();
        ConstraintMatchSupplier constraintMatchSupplier = ConstraintMatchSupplier.of((BiFunction)constraint.getJustificationMapping(), (Function)constraint.getIndictedObjectsMapping(), a);
        return impacter.impactScore(matchWeight, constraintMatchSupplier);
    }

    private static <A, Score_ extends Score<Score_>> UndoScoreImpacter impactWithConstraintMatch(WeightedScoreImpacter<Score_, ?> impacter, BigDecimal matchWeight, A a) {
        AbstractConstraint<?, ?, ?> constraint = ((ScoreContext)impacter.getContext()).getConstraint();
        ConstraintMatchSupplier constraintMatchSupplier = ConstraintMatchSupplier.of((BiFunction)constraint.getJustificationMapping(), (Function)constraint.getIndictedObjectsMapping(), a);
        return impacter.impactScore(matchWeight, constraintMatchSupplier);
    }

    private BiFunction<WeightedScoreImpacter<?, ?>, A, UndoScoreImpacter> buildScoreImpacterWithConstraintMatchNoJustifications() {
        if (this.intMatchWeigher != null) {
            return (impacter, a) -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a);
                return BavetScoringConstraintStream.impactWithConstraintMatchNoJustifications(impacter, matchWeight);
            };
        }
        if (this.longMatchWeigher != null) {
            return (impacter, a) -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a);
                return BavetScoringConstraintStream.impactWithConstraintMatchNoJustifications(impacter, matchWeight);
            };
        }
        if (this.bigDecimalMatchWeigher != null) {
            return (impacter, a) -> {
                BigDecimal matchWeight = this.bigDecimalMatchWeigher.apply(a);
                return BavetScoringConstraintStream.impactWithConstraintMatchNoJustifications(impacter, matchWeight);
            };
        }
        throw new IllegalStateException("Impossible state: neither of the supported match weighers provided.");
    }

    public String toString() {
        return "Scoring(" + this.constraint.getConstraintRef() + ")";
    }
}

