/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.uni;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.common.NodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetAftBridgeTriConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.BavetAbstractUniConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.MapUniToTriNode;
import java.util.Objects;
import java.util.function.Function;

final class BavetTriMapUniConstraintStream<Solution_, A, NewA, NewB, NewC>
extends BavetAbstractUniConstraintStream<Solution_, A> {
    private final Function<A, NewA> mappingFunctionA;
    private final Function<A, NewB> mappingFunctionB;
    private final Function<A, NewC> mappingFunctionC;
    private final boolean guaranteesDistinct;
    private BavetAftBridgeTriConstraintStream<Solution_, NewA, NewB, NewC> aftStream;

    public BavetTriMapUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, Function<A, NewA> mappingFunctionA, Function<A, NewB> mappingFunctionB, Function<A, NewC> mappingFunctionC, boolean isExpand) {
        super(constraintFactory, parent);
        this.mappingFunctionA = mappingFunctionA;
        this.mappingFunctionB = mappingFunctionB;
        this.mappingFunctionC = mappingFunctionC;
        this.guaranteesDistinct = isExpand && parent.guaranteesDistinct();
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.guaranteesDistinct;
    }

    public void setAftBridge(BavetAftBridgeTriConstraintStream<Solution_, NewA, NewB, NewC> aftStream) {
        this.aftStream = aftStream;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        this.assertEmptyChildStreamList();
        int inputStoreIndex = buildHelper.reserveTupleStoreIndex(this.parent.getTupleSource());
        int outputStoreSize = buildHelper.extractTupleStoreSize(this.aftStream);
        MapUniToTriNode<A, NewA, NewB, NewC> node = new MapUniToTriNode<A, NewA, NewB, NewC>(inputStoreIndex, this.mappingFunctionA, this.mappingFunctionB, this.mappingFunctionC, buildHelper.getAggregatedTupleLifecycle(this.aftStream.getChildStreamList()), outputStoreSize);
        buildHelper.addNode(node, this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BavetTriMapUniConstraintStream that = (BavetTriMapUniConstraintStream)object;
        return Objects.equals(this.parent, that.parent) && this.guaranteesDistinct == that.guaranteesDistinct && Objects.equals(this.mappingFunctionA, that.mappingFunctionA) && Objects.equals(this.mappingFunctionB, that.mappingFunctionB) && Objects.equals(this.mappingFunctionC, that.mappingFunctionC);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.mappingFunctionA, this.mappingFunctionB, this.mappingFunctionC, this.guaranteesDistinct);
    }

    public String toString() {
        return "TriMap()";
    }
}

