/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.consecutive;

import ai.timefold.solver.core.api.score.stream.common.Break;
import ai.timefold.solver.core.impl.score.stream.collector.consecutive.SequenceImpl;
import org.jspecify.annotations.NonNull;

final class BreakImpl<Value_, Point_ extends Comparable<Point_>, Difference_ extends Comparable<Difference_>>
implements Break<Value_, Difference_> {
    private final SequenceImpl<Value_, Point_, Difference_> nextSequence;
    SequenceImpl<Value_, Point_, Difference_> previousSequence;
    private Difference_ length;

    BreakImpl(SequenceImpl<Value_, Point_, Difference_> nextSequence, SequenceImpl<Value_, Point_, Difference_> previousSequence) {
        this.nextSequence = nextSequence;
        this.setPreviousSequence(previousSequence);
    }

    @Override
    public boolean isFirst() {
        return this.previousSequence.isFirst();
    }

    @Override
    public boolean isLast() {
        return this.nextSequence.isLast();
    }

    @Override
    public @NonNull Value_ getPreviousSequenceEnd() {
        return this.previousSequence.lastItem.value();
    }

    @Override
    public @NonNull Value_ getNextSequenceStart() {
        return this.nextSequence.firstItem.value();
    }

    @Override
    public @NonNull Difference_ getLength() {
        return this.length;
    }

    void setPreviousSequence(SequenceImpl<Value_, Point_, Difference_> previousSequence) {
        this.previousSequence = previousSequence;
        this.updateLength();
    }

    void updateLength() {
        this.length = this.previousSequence.computeDifference(this.nextSequence);
    }

    public String toString() {
        return "Break{previousSequence=" + this.previousSequence + ", nextSequence=" + this.nextSequence + ", length=" + this.length + "}";
    }
}

