/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.consecutive;

import ai.timefold.solver.core.api.score.stream.common.Break;
import ai.timefold.solver.core.api.score.stream.common.Sequence;
import ai.timefold.solver.core.api.score.stream.common.SequenceChain;
import ai.timefold.solver.core.impl.score.stream.collector.consecutive.BreakImpl;
import ai.timefold.solver.core.impl.score.stream.collector.consecutive.ComparableValue;
import ai.timefold.solver.core.impl.score.stream.collector.consecutive.SequenceImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ConsecutiveSetTree<Value_, Point_ extends Comparable<Point_>, Difference_ extends Comparable<Difference_>>
implements SequenceChain<Value_, Difference_> {
    final BiFunction<Point_, Point_, Difference_> differenceFunction;
    final BiFunction<Point_, Point_, Difference_> sequenceLengthFunction;
    private final Difference_ maxDifference;
    private final Difference_ zeroDifference;
    private final Map<Value_, ValueCount<ComparableValue<Value_, Point_>>> valueCountMap = new HashMap<Value_, ValueCount<ComparableValue<Value_, Point_>>>();
    private final NavigableMap<ComparableValue<Value_, Point_>, Value_> itemMap = new TreeMap<ComparableValue<Value_, Point_>, Value_>();
    private final NavigableMap<ComparableValue<Value_, Point_>, SequenceImpl<Value_, Point_, Difference_>> startItemToSequence = new TreeMap<ComparableValue<Value_, Point_>, SequenceImpl<Value_, Point_, Difference_>>();
    private final NavigableMap<ComparableValue<Value_, Point_>, BreakImpl<Value_, Point_, Difference_>> startItemToPreviousBreak = new TreeMap<ComparableValue<Value_, Point_>, BreakImpl<Value_, Point_, Difference_>>();
    private ComparableValue<Value_, Point_> firstItem;
    private ComparableValue<Value_, Point_> lastItem;

    public ConsecutiveSetTree(BiFunction<Point_, Point_, Difference_> differenceFunction, BinaryOperator<Difference_> sumFunction, Difference_ maxDifference, Difference_ zeroDifference) {
        this.differenceFunction = differenceFunction;
        this.sequenceLengthFunction = (first, last) -> (Comparable)sumFunction.apply(maxDifference, (Comparable)differenceFunction.apply(first, last));
        this.maxDifference = maxDifference;
        this.zeroDifference = zeroDifference;
    }

    @Override
    public @NonNull Collection<Sequence<Value_, Difference_>> getConsecutiveSequences() {
        return Collections.unmodifiableCollection(this.startItemToSequence.values());
    }

    @Override
    public @NonNull Collection<Break<Value_, Difference_>> getBreaks() {
        return Collections.unmodifiableCollection(this.startItemToPreviousBreak.values());
    }

    @Override
    public @Nullable Sequence<Value_, Difference_> getFirstSequence() {
        if (this.startItemToSequence.isEmpty()) {
            return null;
        }
        return this.startItemToSequence.firstEntry().getValue();
    }

    @Override
    public @Nullable Sequence<Value_, Difference_> getLastSequence() {
        if (this.startItemToSequence.isEmpty()) {
            return null;
        }
        return this.startItemToSequence.lastEntry().getValue();
    }

    @Override
    public @Nullable Break<Value_, Difference_> getFirstBreak() {
        if (this.startItemToSequence.size() <= 1) {
            return null;
        }
        return this.startItemToPreviousBreak.firstEntry().getValue();
    }

    @Override
    public @Nullable Break<Value_, Difference_> getLastBreak() {
        if (this.startItemToSequence.size() <= 1) {
            return null;
        }
        return this.startItemToPreviousBreak.lastEntry().getValue();
    }

    public boolean add(Value_ value, Point_ valueIndex) {
        Map.Entry<ComparableValue<Value_, Point_>, SequenceImpl<Value_, Point_, Difference_>> firstBeforeItemEntry;
        ValueCount<ComparableValue<Value_, Point_>> valueCount = this.valueCountMap.get(value);
        if (valueCount != null) {
            ComparableValue addingItem = (ComparableValue)valueCount.value;
            if (!Objects.equals(addingItem.index(), valueIndex)) {
                throw new IllegalStateException("Impossible state: the item (" + value + ") is already in the bag with a different index (" + addingItem.index() + " vs " + valueIndex + ").\nMaybe the index map function is not deterministic?");
            }
            ++valueCount.count;
            return true;
        }
        ComparableValue<Value_, Point_> addingItem = new ComparableValue<Value_, Point_>(value, valueIndex);
        this.valueCountMap.put(value, new ValueCount<ComparableValue<Value_, Point_>>(addingItem));
        this.itemMap.put(addingItem, addingItem.value());
        if (this.firstItem == null || addingItem.compareTo(this.firstItem) < 0) {
            this.firstItem = addingItem;
        }
        if (this.lastItem == null || addingItem.compareTo(this.lastItem) > 0) {
            this.lastItem = addingItem;
        }
        if ((firstBeforeItemEntry = this.startItemToSequence.floorEntry(addingItem)) != null) {
            ComparableValue<Value_, Point_> firstBeforeItem = firstBeforeItemEntry.getKey();
            ComparableValue endOfBeforeSequenceItem = firstBeforeItemEntry.getValue().lastItem;
            Object endOfBeforeSequenceIndex = endOfBeforeSequenceItem.index();
            if (ConsecutiveSetTree.isInNaturalOrderAndHashOrderIfEqual(valueIndex, value, endOfBeforeSequenceIndex, endOfBeforeSequenceItem.value())) {
                return true;
            }
            ComparableValue<Value_, Point_> firstAfterItem = this.startItemToSequence.higherKey(addingItem);
            if (firstAfterItem != null) {
                this.addBetweenItems(addingItem, firstBeforeItem, endOfBeforeSequenceItem, firstAfterItem);
            } else {
                SequenceImpl prevBag = (SequenceImpl)this.startItemToSequence.get(firstBeforeItem);
                if (this.isFirstSuccessorOfSecond(addingItem, endOfBeforeSequenceItem)) {
                    prevBag.setEnd(addingItem);
                } else {
                    SequenceImpl newBag = new SequenceImpl(this, addingItem);
                    this.startItemToSequence.put(addingItem, newBag);
                    this.startItemToPreviousBreak.put(addingItem, new BreakImpl(newBag, prevBag));
                }
            }
        } else {
            ComparableValue<Value_, Point_> firstAfterItem = this.startItemToSequence.higherKey(addingItem);
            if (firstAfterItem != null) {
                if (this.isFirstSuccessorOfSecond(firstAfterItem, addingItem)) {
                    SequenceImpl afterBag = (SequenceImpl)this.startItemToSequence.remove(firstAfterItem);
                    afterBag.setStart(addingItem);
                    this.startItemToSequence.put(addingItem, afterBag);
                } else {
                    SequenceImpl afterBag = (SequenceImpl)this.startItemToSequence.get(firstAfterItem);
                    SequenceImpl newBag = new SequenceImpl(this, addingItem);
                    this.startItemToSequence.put(addingItem, newBag);
                    this.startItemToPreviousBreak.put(firstAfterItem, new BreakImpl(afterBag, newBag));
                }
            } else {
                SequenceImpl newBag = new SequenceImpl(this, addingItem);
                this.startItemToSequence.put(addingItem, newBag);
            }
        }
        return true;
    }

    private static <T extends Comparable<T>, Value_> boolean isInNaturalOrderAndHashOrderIfEqual(T a, Value_ aItem, T b, Value_ bItem) {
        int difference = a.compareTo(b);
        if (difference != 0) {
            return difference < 0;
        }
        return System.identityHashCode(aItem) - System.identityHashCode(bItem) < 0;
    }

    private void addBetweenItems(ComparableValue<Value_, Point_> comparableItem, ComparableValue<Value_, Point_> firstBeforeItem, ComparableValue<Value_, Point_> endOfBeforeSequenceItem, ComparableValue<Value_, Point_> firstAfterItem) {
        if (this.isFirstSuccessorOfSecond(comparableItem, endOfBeforeSequenceItem)) {
            SequenceImpl prevBag = (SequenceImpl)this.startItemToSequence.get(firstBeforeItem);
            if (this.isFirstSuccessorOfSecond(firstAfterItem, comparableItem)) {
                this.startItemToPreviousBreak.remove(firstAfterItem);
                SequenceImpl afterBag = (SequenceImpl)this.startItemToSequence.remove(firstAfterItem);
                prevBag.merge(afterBag);
                Map.Entry<ComparableValue<Value_, Point_>, BreakImpl<Value_, Point_, Difference_>> maybeNextBreak = this.startItemToPreviousBreak.higherEntry(firstAfterItem);
                if (maybeNextBreak != null) {
                    maybeNextBreak.getValue().setPreviousSequence(prevBag);
                }
            } else {
                prevBag.setEnd(comparableItem);
                ((BreakImpl)this.startItemToPreviousBreak.get(firstAfterItem)).updateLength();
            }
        } else if (this.isFirstSuccessorOfSecond(firstAfterItem, comparableItem)) {
            SequenceImpl afterBag = (SequenceImpl)this.startItemToSequence.remove(firstAfterItem);
            afterBag.setStart(comparableItem);
            this.startItemToSequence.put(comparableItem, afterBag);
            BreakImpl prevBreak = (BreakImpl)this.startItemToPreviousBreak.remove(firstAfterItem);
            prevBreak.updateLength();
            this.startItemToPreviousBreak.put(comparableItem, prevBreak);
        } else {
            SequenceImpl newBag = new SequenceImpl(this, comparableItem);
            this.startItemToSequence.put(comparableItem, newBag);
            ((BreakImpl)this.startItemToPreviousBreak.get(firstAfterItem)).setPreviousSequence(newBag);
            SequenceImpl previousSequence = (SequenceImpl)this.startItemToSequence.get(firstBeforeItem);
            this.startItemToPreviousBreak.put(comparableItem, new BreakImpl(newBag, previousSequence));
        }
    }

    public boolean remove(Value_ value) {
        ValueCount<ComparableValue<Value_, Point_>> valueCount = this.valueCountMap.get(value);
        if (valueCount == null) {
            return false;
        }
        --valueCount.count;
        if (valueCount.count > 0) {
            return true;
        }
        this.valueCountMap.remove(value);
        ComparableValue removingItem = (ComparableValue)valueCount.value;
        this.itemMap.remove(removingItem);
        boolean noMoreItems = this.itemMap.isEmpty();
        if (removingItem.compareTo(this.firstItem) == 0) {
            ComparableValue<Value_, Point_> comparableValue = this.firstItem = noMoreItems ? null : this.itemMap.firstEntry().getKey();
        }
        if (removingItem.compareTo(this.lastItem) == 0) {
            this.lastItem = noMoreItems ? null : this.itemMap.lastEntry().getKey();
        }
        Map.Entry<ComparableValue, SequenceImpl<Value_, Point_, Difference_>> firstBeforeItemEntry = this.startItemToSequence.floorEntry(removingItem);
        ComparableValue firstBeforeItem = firstBeforeItemEntry.getKey();
        SequenceImpl<Value_, Point_, Difference_> bag = firstBeforeItemEntry.getValue();
        if (bag.getFirstItem() == bag.getLastItem()) {
            this.startItemToSequence.remove(firstBeforeItem);
            BreakImpl removedBreak = (BreakImpl)this.startItemToPreviousBreak.remove(firstBeforeItem);
            Map.Entry<ComparableValue, BreakImpl<Value_, Point_, Difference_>> extendedBreakEntry = this.startItemToPreviousBreak.higherEntry(firstBeforeItem);
            if (extendedBreakEntry != null) {
                if (removedBreak != null) {
                    BreakImpl extendedBreak = extendedBreakEntry.getValue();
                    extendedBreak.setPreviousSequence(removedBreak.previousSequence);
                } else {
                    this.startItemToPreviousBreak.remove(extendedBreakEntry.getKey());
                }
            }
        } else {
            this.removeItemFromBag(bag, removingItem, firstBeforeItem, bag.lastItem);
        }
        return true;
    }

    private void removeItemFromBag(SequenceImpl<Value_, Point_, Difference_> bag, ComparableValue<Value_, Point_> item, ComparableValue<Value_, Point_> sequenceStart, ComparableValue<Value_, Point_> sequenceEnd) {
        ComparableValue<Value_, Point_> firstBeforeItem;
        if (item.equals(sequenceStart)) {
            bag.setStart(this.itemMap.higherKey(item));
            this.startItemToSequence.remove(sequenceStart);
            BreakImpl extendedBreak = (BreakImpl)this.startItemToPreviousBreak.remove(sequenceStart);
            ComparableValue bagFirstItem = bag.firstItem;
            this.startItemToSequence.put(bagFirstItem, bag);
            if (extendedBreak != null) {
                extendedBreak.updateLength();
                this.startItemToPreviousBreak.put(bagFirstItem, extendedBreak);
            }
            return;
        }
        if (item.equals(sequenceEnd)) {
            bag.setEnd(this.itemMap.lowerKey(item));
            Map.Entry<ComparableValue<Value_, Point_>, BreakImpl<Value_, Point_, Difference_>> extendedBreakEntry = this.startItemToPreviousBreak.higherEntry(item);
            if (extendedBreakEntry != null) {
                BreakImpl<Value_, Point_, Difference_> extendedBreak = extendedBreakEntry.getValue();
                extendedBreak.updateLength();
            }
            return;
        }
        ComparableValue<Value_, Point_> firstAfterItem = bag.getComparableItems().higherKey(item);
        if (this.isFirstSuccessorOfSecond(firstAfterItem, firstBeforeItem = bag.getComparableItems().lowerKey(item))) {
            return;
        }
        SequenceImpl<Value_, Point_, Difference_> splitBag = bag.split(item);
        ComparableValue firstSplitItem = splitBag.firstItem;
        this.startItemToSequence.put(firstSplitItem, splitBag);
        this.startItemToPreviousBreak.put(firstSplitItem, new BreakImpl<Value_, Point_, Difference_>(splitBag, bag));
        Map.Entry<ComparableValue<Value_, Point_>, BreakImpl<Value_, Point_, Difference_>> maybeNextBreak = this.startItemToPreviousBreak.higherEntry(firstAfterItem);
        if (maybeNextBreak != null) {
            maybeNextBreak.getValue().setPreviousSequence(splitBag);
        }
    }

    Break<Value_, Difference_> getBreakBefore(ComparableValue<Value_, Point_> item) {
        return (Break)this.startItemToPreviousBreak.get(item);
    }

    Break<Value_, Difference_> getBreakAfter(ComparableValue<Value_, Point_> item) {
        Map.Entry<ComparableValue<Value_, Point_>, BreakImpl<Value_, Point_, Difference_>> entry = this.startItemToPreviousBreak.higherEntry(item);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    NavigableMap<ComparableValue<Value_, Point_>, Value_> getComparableItems(ComparableValue<Value_, Point_> firstKey, ComparableValue<Value_, Point_> lastKey) {
        return this.itemMap.subMap(firstKey, true, lastKey, true);
    }

    ComparableValue<Value_, Point_> getFirstItem() {
        return this.firstItem;
    }

    ComparableValue<Value_, Point_> getLastItem() {
        return this.lastItem;
    }

    private boolean isFirstSuccessorOfSecond(ComparableValue<Value_, Point_> first, ComparableValue<Value_, Point_> second) {
        Comparable difference = (Comparable)this.differenceFunction.apply(second.index(), first.index());
        return ConsecutiveSetTree.isInNaturalOrderAndHashOrderIfEqual(this.zeroDifference, second.value(), difference, first.value()) && difference.compareTo(this.maxDifference) <= 0;
    }

    public String toString() {
        return "Sequences {sequenceList=" + this.getConsecutiveSequences() + ", breakList=" + this.getBreaks() + "}";
    }

    private static final class ValueCount<Value_> {
        private final Value_ value;
        private int count;

        public ValueCount(Value_ value) {
            this.value = value;
            this.count = 1;
        }
    }
}

