/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.common;

import ai.timefold.solver.core.api.domain.constraintweight.ConstraintConfiguration;
import ai.timefold.solver.core.api.score.IBendableScore;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.impl.domain.score.descriptor.ScoreDescriptor;
import ai.timefold.solver.core.impl.domain.solution.ConstraintWeightSupplier;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.definition.AbstractBendableScoreDefinition;
import ai.timefold.solver.core.impl.score.stream.common.InnerConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.common.ScoreImpactType;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.NonNull;

public abstract class AbstractConstraint<Solution_, Constraint_ extends AbstractConstraint<Solution_, Constraint_, ConstraintFactory_>, ConstraintFactory_ extends InnerConstraintFactory<Solution_, Constraint_>>
implements Constraint {
    private static final String CONSTRAINT_GROUP_REGEX = "^[\\p{L}][\\p{L}\\p{N}\\p{M}_-]*$";
    private static final Pattern CONSTRAINT_GROUP_REGEX_PATTERN = Pattern.compile("^[\\p{L}][\\p{L}\\p{N}\\p{M}_-]*$");
    private final ConstraintFactory_ constraintFactory;
    private final ConstraintRef constraintRef;
    private final String description;
    private final String constraintGroup;
    private final Score<?> defaultConstraintWeight;
    private final ScoreImpactType scoreImpactType;
    private final Object justificationMapping;
    private final Object indictedObjectsMapping;

    protected AbstractConstraint(ConstraintFactory_ constraintFactory, ConstraintRef constraintRef, String description, String constraintGroup, Score<?> defaultConstraintWeight, ScoreImpactType scoreImpactType, Object justificationMapping, Object indictedObjectsMapping) {
        this.constraintFactory = (InnerConstraintFactory)Objects.requireNonNull(constraintFactory);
        this.constraintRef = Objects.requireNonNull(constraintRef);
        this.description = Objects.requireNonNull(description);
        this.constraintGroup = Objects.requireNonNull(constraintGroup);
        Matcher matcher = CONSTRAINT_GROUP_REGEX_PATTERN.matcher(constraintGroup);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The constraintGroup (%s) contains invalid characters.\nOnly alphanumeric characters, \"-\" and \"_\" are allowed.\nThe string must start with an alphabetic character.\n".formatted(constraintGroup));
        }
        this.defaultConstraintWeight = defaultConstraintWeight;
        this.scoreImpactType = Objects.requireNonNull(scoreImpactType);
        this.justificationMapping = justificationMapping;
        this.indictedObjectsMapping = indictedObjectsMapping;
    }

    public final <Score_ extends Score<Score_>> Score_ extractConstraintWeight(Solution_ solution) {
        return this.adjustConstraintWeight(this.determineConstraintWeight(solution));
    }

    private <Score_ extends Score<Score_>> Score_ adjustConstraintWeight(Score_ constraintWeight) {
        return switch (this.scoreImpactType) {
            default -> throw new IncompatibleClassChangeError();
            case ScoreImpactType.PENALTY -> constraintWeight.negate();
            case ScoreImpactType.REWARD, ScoreImpactType.MIXED -> constraintWeight;
        };
    }

    private <Score_ extends Score<Score_>> Score_ determineConstraintWeight(Solution_ solution) {
        Object weight;
        boolean hasConstraintWeightSupplier;
        SolutionDescriptor solutionDescriptor = ((InnerConstraintFactory)this.constraintFactory).getSolutionDescriptor();
        boolean hasConstraintWeight = this.defaultConstraintWeight != null;
        ConstraintWeightSupplier constraintWeightSupplier = solutionDescriptor.getConstraintWeightSupplier();
        boolean bl = hasConstraintWeightSupplier = constraintWeightSupplier != null;
        if (!hasConstraintWeight) {
            if (solution == null) {
                return solutionDescriptor.getScoreDefinition().getOneSoftestScore();
            }
            if (hasConstraintWeightSupplier) {
                return constraintWeightSupplier.getConstraintWeight(this.constraintRef, solution);
            }
            throw new UnsupportedOperationException("Impossible state: no %s for constraint (%s).".formatted(ConstraintConfiguration.class.getSimpleName(), this.constraintRef));
        }
        if (hasConstraintWeightSupplier && (weight = constraintWeightSupplier.getConstraintWeight(this.constraintRef, solution)) != null) {
            return weight;
        }
        AbstractConstraint.validateWeight(solutionDescriptor, this.constraintRef, this.defaultConstraintWeight);
        return (Score_)this.defaultConstraintWeight;
    }

    public final void assertCorrectImpact(int impact) {
        if (impact >= 0) {
            return;
        }
        if (this.scoreImpactType != ScoreImpactType.MIXED) {
            throw new IllegalStateException("Negative match weight (" + impact + ") for constraint (" + this.constraintRef + "). Check constraint provider implementation.");
        }
    }

    public final void assertCorrectImpact(long impact) {
        if (impact >= 0L) {
            return;
        }
        if (this.scoreImpactType != ScoreImpactType.MIXED) {
            throw new IllegalStateException("Negative match weight (" + impact + ") for constraint (" + this.getConstraintRef() + "). Check constraint provider implementation.");
        }
    }

    public final void assertCorrectImpact(BigDecimal impact) {
        if (impact.signum() >= 0) {
            return;
        }
        if (this.scoreImpactType != ScoreImpactType.MIXED) {
            throw new IllegalStateException("Negative match weight (" + impact + ") for constraint (" + this.getConstraintRef() + "). Check constraint provider implementation.");
        }
    }

    public final ConstraintFactory_ getConstraintFactory() {
        return this.constraintFactory;
    }

    @Override
    public ConstraintRef getConstraintRef() {
        return this.constraintRef;
    }

    @Override
    public @NonNull String getDescription() {
        return this.description;
    }

    @Override
    public @NonNull String getConstraintGroup() {
        return this.constraintGroup;
    }

    @Override
    public <Score_ extends Score<Score_>> Score_ getConstraintWeight() {
        if (this.defaultConstraintWeight == null) {
            return null;
        }
        return (Score_)this.adjustConstraintWeight(this.defaultConstraintWeight);
    }

    public final ScoreImpactType getScoreImpactType() {
        return this.scoreImpactType;
    }

    public <JustificationMapping_> JustificationMapping_ getJustificationMapping() {
        return (JustificationMapping_)this.justificationMapping;
    }

    public <IndictedObjectsMapping_> IndictedObjectsMapping_ getIndictedObjectsMapping() {
        return (IndictedObjectsMapping_)this.indictedObjectsMapping;
    }

    public static <Solution_, Score_ extends Score<Score_>> void validateWeight(SolutionDescriptor<Solution_> solutionDescriptor, ConstraintRef constraintRef, Score_ constraintWeight) {
        if (constraintWeight == null) {
            throw new IllegalArgumentException("The constraintWeight (null) for constraint (%s) must not be null.\nMaybe check your constraint implementation.".formatted(constraintRef));
        }
        ScoreDescriptor scoreDescriptor = solutionDescriptor.getScoreDescriptor();
        if (!constraintWeight.getClass().isAssignableFrom(constraintWeight.getClass())) {
            throw new IllegalArgumentException("The constraintWeight (%s) of class (%s) for constraint (%s) must be of the scoreClass (%s).\nMaybe check your constraint implementation.".formatted(constraintWeight, constraintWeight.getClass(), constraintRef, scoreDescriptor.getScoreDefinition().getScoreClass()));
        }
        if (constraintWeight.initScore() != 0) {
            throw new IllegalArgumentException("The constraintWeight (%s) for constraint (%s) must have an initScore (%d) equal to 0.\nMaybe check your constraint implementation.".formatted(constraintWeight, constraintRef, constraintWeight.initScore()));
        }
        if (!scoreDescriptor.getScoreDefinition().isPositiveOrZero(constraintWeight)) {
            throw new IllegalArgumentException("The constraintWeight (%s) for constraint (%s) must be positive or zero.\nMaybe check your constraint implementation.".formatted(constraintWeight, constraintRef));
        }
        if (constraintWeight instanceof IBendableScore) {
            IBendableScore bendableConstraintWeight = (IBendableScore)constraintWeight;
            AbstractBendableScoreDefinition bendableScoreDefinition = (AbstractBendableScoreDefinition)scoreDescriptor.getScoreDefinition();
            if (bendableConstraintWeight.hardLevelsSize() != bendableScoreDefinition.getHardLevelsSize() || bendableConstraintWeight.softLevelsSize() != bendableScoreDefinition.getSoftLevelsSize()) {
                throw new IllegalArgumentException("The bendable constraintWeight (%s) for constraint (%s) has a hardLevelsSize (%d) or a softLevelsSize (%d) that doesn't match the score definition's hardLevelsSize (%d) or softLevelsSize (%d).\nMaybe check your constraint implementation.".formatted(constraintWeight, constraintRef, bendableConstraintWeight.hardLevelsSize(), bendableConstraintWeight.softLevelsSize(), bendableScoreDefinition.getHardLevelsSize(), bendableScoreDefinition.getSoftLevelsSize()));
            }
        }
    }
}

