/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.common;

import ai.timefold.solver.core.api.domain.lookup.PlanningId;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintFactory;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.api.score.stream.Joiners;
import ai.timefold.solver.core.api.score.stream.bi.BiConstraintStream;
import ai.timefold.solver.core.api.score.stream.bi.BiJoiner;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.stream.common.bi.BiJoinerComber;
import ai.timefold.solver.core.impl.score.stream.common.bi.DefaultBiJoiner;
import ai.timefold.solver.core.impl.score.stream.common.uni.InnerUniConstraintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

public abstract class InnerConstraintFactory<Solution_, Constraint_ extends Constraint>
implements ConstraintFactory {
    @Override
    public <A> @NonNull BiConstraintStream<A, A> forEachUniquePair(@NonNull Class<A> sourceClass, BiJoiner<A, A> ... joiners) {
        BiJoinerComber<A, A> joinerComber = BiJoinerComber.comb(joiners);
        joinerComber.addJoiner(this.buildLessThanId(sourceClass));
        return ((InnerUniConstraintStream)this.forEach(sourceClass)).join(this.forEach(sourceClass), joinerComber);
    }

    private <A> DefaultBiJoiner<A, A> buildLessThanId(Class<A> sourceClass) {
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        MemberAccessor planningIdMemberAccessor = solutionDescriptor.getPlanningIdAccessor(sourceClass);
        if (planningIdMemberAccessor == null) {
            throw new IllegalArgumentException("The fromClass (%s) has no member with a @%s annotation, so the pairs cannot be made unique ([A,B] vs [B,A]).".formatted(sourceClass, PlanningId.class.getSimpleName()));
        }
        Function planningIdGetter = planningIdMemberAccessor.getGetterFunction();
        return (DefaultBiJoiner)Joiners.lessThan(planningIdGetter);
    }

    @Override
    public <A> @NonNull BiConstraintStream<A, A> fromUniquePair(@NonNull Class<A> fromClass, BiJoiner<A, A> ... joiners) {
        BiJoinerComber<A, A> joinerComber = BiJoinerComber.comb(joiners);
        joinerComber.addJoiner(this.buildLessThanId(fromClass));
        return ((InnerUniConstraintStream)this.from(fromClass)).join(this.from(fromClass), joinerComber);
    }

    public <A> void assertValidFromType(Class<A> fromType) {
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        Set<Class<?>> problemFactOrEntityClassSet = solutionDescriptor.getProblemFactOrEntityClassSet();
        boolean hasMatchingType = problemFactOrEntityClassSet.stream().anyMatch(factType -> fromType.isAssignableFrom((Class<?>)factType) || factType.isAssignableFrom(fromType));
        if (!hasMatchingType) {
            List<String> canonicalClassNameList = problemFactOrEntityClassSet.stream().map(Class::getCanonicalName).sorted().toList();
            throw new IllegalArgumentException("Cannot use class (%s) in a constraint stream as it is neither the same as, nor a superclass or superinterface of one of planning entities or problem facts.\nEnsure that all from(), join(), ifExists() and ifNotExists() building blocks only reference classes assignable from planning entities or problem facts (%s) annotated on the planning solution (%s).".formatted(fromType.getCanonicalName(), canonicalClassNameList, solutionDescriptor.getSolutionClass().getCanonicalName()));
        }
    }

    public List<Constraint_> buildConstraints(ConstraintProvider constraintProvider) {
        Constraint[] constraints = Objects.requireNonNull(constraintProvider.defineConstraints(this), () -> "The constraintProvider class (%s)'s defineConstraints() must not return null.\"\nMaybe return an empty array instead if there are no constraints.".formatted(constraintProvider.getClass()));
        if (Arrays.stream(constraints).anyMatch(Objects::isNull)) {
            throw new IllegalStateException("The constraintProvider class (%s)'s defineConstraints() must not contain an element that is null.\nMaybe don't include any null elements in the %s array.".formatted(constraintProvider.getClass(), Constraint.class.getSimpleName()));
        }
        Map<ConstraintRef, List<Constraint>> constraintsPerIdMap = Arrays.stream(constraints).collect(Collectors.groupingBy(Constraint::getConstraintRef));
        constraintsPerIdMap.forEach((? super K constraintRef, ? super V duplicateConstraintList) -> {
            if (duplicateConstraintList.size() > 1) {
                throw new IllegalStateException("There are multiple constraints with the same ID (%s).".formatted(constraintRef));
            }
        });
        return Arrays.stream(constraints).map(c -> c).collect(Collectors.toList());
    }

    public abstract SolutionDescriptor<Solution_> getSolutionDescriptor();
}

