/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.common.inliner;

import ai.timefold.solver.core.api.function.PentaFunction;
import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatch;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

@FunctionalInterface
public interface ConstraintMatchSupplier<Score_ extends Score<Score_>>
extends BiFunction<Constraint, Score_, ConstraintMatch<Score_>> {
    public static <Score_ extends Score<Score_>> ConstraintMatchSupplier<Score_> empty() {
        return (constraint, impact) -> new ConstraintMatch<Score>(constraint.getConstraintRef(), null, (Collection<Object>)Collections.emptyList(), (Score)impact);
    }

    public static <A, Score_ extends Score<Score_>> ConstraintMatchSupplier<Score_> of(BiFunction<A, Score<?>, ConstraintJustification> justificationMapping, Function<A, Collection<Object>> indictedObjectsMapping, A a) {
        return (constraint, impact) -> {
            Collection indictedObjectCollection;
            ConstraintJustification justification;
            try {
                justification = (ConstraintJustification)justificationMapping.apply(a, (Score<?>)impact);
            }
            catch (Exception e) {
                throw ConstraintMatchSupplier.createJustificationException(constraint, e, a);
            }
            try {
                indictedObjectCollection = (Collection)indictedObjectsMapping.apply(a);
            }
            catch (Exception e) {
                throw ConstraintMatchSupplier.createIndictmentException(constraint, e, a);
            }
            return new ConstraintMatch<Score>(constraint.getConstraintRef(), justification, (Collection<Object>)indictedObjectCollection, (Score)impact);
        };
    }

    private static RuntimeException createJustificationException(Constraint constraint, Exception cause, Object ... facts) {
        throw new IllegalStateException("Consequence of a constraint (" + constraint.getConstraintRef() + ") threw an exception creating constraint justification from a tuple (" + ConstraintMatchSupplier.factsToString(facts) + ").", cause);
    }

    private static String factsToString(Object ... facts) {
        return Arrays.stream(facts).map(Objects::toString).collect(Collectors.joining(", ", "{", "}"));
    }

    private static RuntimeException createIndictmentException(Constraint constraint, Exception cause, Object ... facts) {
        throw new IllegalStateException("Consequence of a constraint (" + constraint.getConstraintRef() + ") threw an exception collecting indicted objects from a tuple (" + ConstraintMatchSupplier.factsToString(facts) + ").", cause);
    }

    public static <A, B, Score_ extends Score<Score_>> ConstraintMatchSupplier<Score_> of(TriFunction<A, B, Score_, ConstraintJustification> justificationMapping, BiFunction<A, B, Collection<Object>> indictedObjectsMapping, A a, B b) {
        return (constraint, impact) -> {
            Collection indictedObjectCollection;
            ConstraintJustification justification;
            try {
                justification = (ConstraintJustification)justificationMapping.apply(a, b, impact);
            }
            catch (Exception e) {
                throw ConstraintMatchSupplier.createJustificationException(constraint, e, a, b);
            }
            try {
                indictedObjectCollection = (Collection)indictedObjectsMapping.apply(a, b);
            }
            catch (Exception e) {
                throw ConstraintMatchSupplier.createIndictmentException(constraint, e, a, b);
            }
            return new ConstraintMatch<Score>(constraint.getConstraintRef(), justification, (Collection<Object>)indictedObjectCollection, (Score)impact);
        };
    }

    public static <A, B, C, Score_ extends Score<Score_>> ConstraintMatchSupplier<Score_> of(QuadFunction<A, B, C, Score_, ConstraintJustification> justificationMapping, TriFunction<A, B, C, Collection<Object>> indictedObjectsMapping, A a, B b, C c) {
        return (constraint, impact) -> {
            Collection indictedObjectCollection;
            ConstraintJustification justification;
            try {
                justification = (ConstraintJustification)justificationMapping.apply(a, b, c, impact);
            }
            catch (Exception e) {
                throw ConstraintMatchSupplier.createJustificationException(constraint, e, a, b, c);
            }
            try {
                indictedObjectCollection = (Collection)indictedObjectsMapping.apply(a, b, c);
            }
            catch (Exception e) {
                throw ConstraintMatchSupplier.createIndictmentException(constraint, e, a, b, c);
            }
            return new ConstraintMatch<Score>(constraint.getConstraintRef(), justification, (Collection<Object>)indictedObjectCollection, (Score)impact);
        };
    }

    public static <A, B, C, D, Score_ extends Score<Score_>> ConstraintMatchSupplier<Score_> of(PentaFunction<A, B, C, D, Score_, ConstraintJustification> justificationMapping, QuadFunction<A, B, C, D, Collection<Object>> indictedObjectsMapping, A a, B b, C c, D d) {
        return (constraint, impact) -> {
            Collection indictedObjectCollection;
            ConstraintJustification justification;
            try {
                justification = (ConstraintJustification)justificationMapping.apply(a, b, c, d, impact);
            }
            catch (Exception e) {
                throw ConstraintMatchSupplier.createJustificationException(constraint, e, a, b, c, d);
            }
            try {
                indictedObjectCollection = (Collection)indictedObjectsMapping.apply(a, b, c, d);
            }
            catch (Exception e) {
                throw ConstraintMatchSupplier.createIndictmentException(constraint, e, a, b, c, d);
            }
            return new ConstraintMatch<Score>(constraint.getConstraintRef(), justification, (Collection<Object>)indictedObjectCollection, (Score)impact);
        };
    }
}

