/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.analysis.ScoreAnalysis;
import ai.timefold.solver.core.api.solver.ScoreAnalysisFetchPolicy;
import ai.timefold.solver.core.impl.constructionheuristic.DefaultConstructionHeuristicPhase;
import ai.timefold.solver.core.impl.constructionheuristic.placer.EntityPlacer;
import ai.timefold.solver.core.impl.constructionheuristic.placer.Placement;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicPhaseScope;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicStepScope;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateDemand;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.heuristic.move.LegacyMoveAdapter;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.ChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.chained.ChainedChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ListUnassignMove;
import ai.timefold.solver.core.impl.move.director.EphemeralMoveDirector;
import ai.timefold.solver.core.impl.move.director.MoveDirector;
import ai.timefold.solver.core.impl.phase.Phase;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.DefaultSolver;
import ai.timefold.solver.core.impl.solver.DefaultSolverFactory;
import ai.timefold.solver.core.impl.solver.RecommendationConstructor;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementLocation;
import ai.timefold.solver.core.preview.api.domain.metamodel.LocationInList;
import ai.timefold.solver.core.preview.api.move.Move;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;

final class AssignmentProcessor<Solution_, Score_ extends Score<Score_>, Recommendation_, In_, Out_>
implements Function<InnerScoreDirector<Solution_, Score_>, List<Recommendation_>> {
    private final DefaultSolverFactory<Solution_> solverFactory;
    private final Function<In_, Out_> valueResultFunction;
    private final RecommendationConstructor<Score_, Recommendation_, Out_> recommendationConstructor;
    private final ScoreAnalysisFetchPolicy fetchPolicy;
    private final ScoreAnalysis<Score_> originalScoreAnalysis;
    private final In_ clonedElement;

    public AssignmentProcessor(DefaultSolverFactory<Solution_> solverFactory, Function<In_, Out_> valueResultFunction, RecommendationConstructor<Score_, Recommendation_, Out_> recommendationConstructor, ScoreAnalysisFetchPolicy fetchPolicy, In_ clonedElement, ScoreAnalysis<Score_> originalScoreAnalysis) {
        this.solverFactory = Objects.requireNonNull(solverFactory);
        this.valueResultFunction = valueResultFunction;
        this.recommendationConstructor = Objects.requireNonNull(recommendationConstructor);
        this.fetchPolicy = Objects.requireNonNull(fetchPolicy);
        this.originalScoreAnalysis = Objects.requireNonNull(originalScoreAnalysis);
        this.clonedElement = clonedElement;
    }

    @Override
    public List<Recommendation_> apply(InnerScoreDirector<Solution_, Score_> scoreDirector) {
        MoveDirector<Solution_> moveDirector = scoreDirector.getMoveDirector();
        SupplyManager supplyManager = scoreDirector.getSupplyManager();
        SolutionDescriptor<Solution_> solutionDescriptor = this.solverFactory.getSolutionDescriptor();
        ListVariableDescriptor<Solution_> listVariableDescriptor = solutionDescriptor.getListVariableDescriptor();
        if (listVariableDescriptor != null) {
            ListVariableStateDemand<Solution_> demand = listVariableDescriptor.getStateDemand();
            ListVariableStateSupply listVariableStateSupply = (ListVariableStateSupply)supplyManager.demand(demand);
            ElementLocation elementLocation = listVariableStateSupply.getLocationInList(this.clonedElement);
            if (elementLocation instanceof LocationInList) {
                LocationInList locationInList = (LocationInList)elementLocation;
                Object entity = locationInList.entity();
                int index = locationInList.index();
                this.wrapAndExecute(moveDirector, new ListUnassignMove<Solution_>(listVariableDescriptor, entity, index));
            }
            supplyManager.cancel(demand);
        } else {
            EntityDescriptor<Solution_> entityDescriptor = solutionDescriptor.findEntityDescriptorOrFail(this.clonedElement.getClass());
            for (GenuineVariableDescriptor genuineVariableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
                BasicVariableDescriptor basicVariableDescriptor = (BasicVariableDescriptor)genuineVariableDescriptor;
                if (basicVariableDescriptor.getValue(this.clonedElement) == null) continue;
                if (basicVariableDescriptor.isChained()) {
                    SingletonInverseVariableDemand demand = new SingletonInverseVariableDemand(basicVariableDescriptor);
                    SingletonInverseVariableSupply supply = supplyManager.demand(demand);
                    this.wrapAndExecute(moveDirector, new ChainedChangeMove(basicVariableDescriptor, this.clonedElement, null, supply));
                    supplyManager.cancel(demand);
                    continue;
                }
                this.wrapAndExecute(moveDirector, new ChangeMove(basicVariableDescriptor, this.clonedElement, null));
            }
        }
        scoreDirector.triggerVariableListeners();
        EntityPlacer entityPlacer = this.buildEntityPlacer().rebuildWithFilter((solution, selection) -> selection == this.clonedElement);
        SolverScope<Solution_> solverScope = new SolverScope<Solution_>();
        solverScope.setWorkingRandom(new Random(0L));
        solverScope.setScoreDirector(scoreDirector);
        ConstructionHeuristicPhaseScope constructionHeuristicPhaseScope = new ConstructionHeuristicPhaseScope(solverScope, -1);
        ConstructionHeuristicStepScope stepScope = new ConstructionHeuristicStepScope(constructionHeuristicPhaseScope);
        entityPlacer.solvingStarted(solverScope);
        entityPlacer.phaseStarted(constructionHeuristicPhaseScope);
        entityPlacer.stepStarted(stepScope);
        try {
            InnerScoreDirector<Solution_, Score_> innerScoreDirector = scoreDirector;
            try {
                Iterator placementIterator = entityPlacer.iterator();
                if (!placementIterator.hasNext()) {
                    throw new IllegalStateException("Impossible state: entity placer (%s) has no placements.\n".formatted(entityPlacer));
                }
                Placement placement = (Placement)placementIterator.next();
                ArrayList<Object> recommendedAssignmentList = new ArrayList<Object>();
                long moveIndex = 0L;
                for (Move move : placement) {
                    recommendedAssignmentList.add(this.execute(scoreDirector, move, moveIndex, this.clonedElement, this.valueResultFunction));
                    ++moveIndex;
                }
                recommendedAssignmentList.sort(null);
                ArrayList<Object> arrayList = recommendedAssignmentList;
                if (innerScoreDirector != null) {
                    innerScoreDirector.close();
                }
                return arrayList;
            }
            catch (Throwable throwable) {
                if (innerScoreDirector != null) {
                    try {
                        innerScoreDirector.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            entityPlacer.stepEnded(stepScope);
            entityPlacer.phaseEnded(constructionHeuristicPhaseScope);
            entityPlacer.solvingEnded(solverScope);
        }
    }

    private void wrapAndExecute(MoveDirector<Solution_> moveDirector, ai.timefold.solver.core.impl.heuristic.move.Move<Solution_> move) {
        new LegacyMoveAdapter<Solution_>(move).execute(moveDirector);
    }

    private EntityPlacer<Solution_> buildEntityPlacer() {
        DefaultSolver solver = (DefaultSolver)this.solverFactory.buildSolver();
        List phaseList = solver.getPhaseList();
        long constructionHeuristicCount = phaseList.stream().filter(DefaultConstructionHeuristicPhase.class::isInstance).count();
        if (constructionHeuristicCount != 1L) {
            throw new IllegalStateException("Assignment Recommendation API requires the solver config to have exactly one construction heuristic phase, but it has (%s) instead.".formatted(constructionHeuristicCount));
        }
        Phase phase = phaseList.get(0);
        if (phase instanceof DefaultConstructionHeuristicPhase) {
            DefaultConstructionHeuristicPhase constructionHeuristicPhase = (DefaultConstructionHeuristicPhase)phase;
            return constructionHeuristicPhase.getEntityPlacer();
        }
        throw new IllegalStateException("Assignment Recommendation API requires the first solver phase (%s) in the solver config to be a construction heuristic.".formatted(phase));
    }

    private Recommendation_ execute(InnerScoreDirector<Solution_, Score_> scoreDirector, Move<Solution_> move, long moveIndex, In_ clonedElement, Function<In_, Out_> propositionFunction) {
        try (EphemeralMoveDirector<Solution_> ephemeralMoveDirector = scoreDirector.getMoveDirector().ephemeral();){
            move.execute(ephemeralMoveDirector);
            ScoreAnalysis<Score_> newScoreAnalysis = scoreDirector.buildScoreAnalysis(this.fetchPolicy);
            ScoreAnalysis<Score_> newScoreDifference = newScoreAnalysis.diff(this.originalScoreAnalysis);
            Out_ result = propositionFunction.apply(clonedElement);
            Recommendation_ Recommendation_ = this.recommendationConstructor.apply(moveIndex, result, newScoreDifference);
            return Recommendation_;
        }
    }
}

