/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.ScoreExplanation;
import ai.timefold.solver.core.api.score.analysis.ScoreAnalysis;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.api.solver.RecommendedAssignment;
import ai.timefold.solver.core.api.solver.RecommendedFit;
import ai.timefold.solver.core.api.solver.ScoreAnalysisFetchPolicy;
import ai.timefold.solver.core.api.solver.SolutionManager;
import ai.timefold.solver.core.api.solver.SolutionUpdatePolicy;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.api.solver.SolverManager;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.score.DefaultScoreExplanation;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirectorFactory;
import ai.timefold.solver.core.impl.solver.Assigner;
import ai.timefold.solver.core.impl.solver.DefaultRecommendedAssignment;
import ai.timefold.solver.core.impl.solver.DefaultRecommendedFit;
import ai.timefold.solver.core.impl.solver.DefaultSolverFactory;
import ai.timefold.solver.core.impl.solver.DefaultSolverManager;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class DefaultSolutionManager<Solution_, Score_ extends Score<Score_>>
implements SolutionManager<Solution_, Score_> {
    private final DefaultSolverFactory<Solution_> solverFactory;
    private final InnerScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory;

    public <ProblemId_> DefaultSolutionManager(SolverManager<Solution_, ProblemId_> solverManager) {
        this(((DefaultSolverManager)solverManager).getSolverFactory());
    }

    public DefaultSolutionManager(SolverFactory<Solution_> solverFactory) {
        this.solverFactory = (DefaultSolverFactory)solverFactory;
        this.scoreDirectorFactory = this.solverFactory.getScoreDirectorFactory();
    }

    public InnerScoreDirectorFactory<Solution_, Score_> getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    @Override
    public @Nullable Score_ update(@NonNull Solution_ solution, @NonNull SolutionUpdatePolicy solutionUpdatePolicy) {
        if (solutionUpdatePolicy == SolutionUpdatePolicy.NO_UPDATE) {
            throw new IllegalArgumentException("Can not call " + this.getClass().getSimpleName() + ".update() with this solutionUpdatePolicy (" + solutionUpdatePolicy + ").");
        }
        return (Score_)this.callScoreDirector(solution, solutionUpdatePolicy, s -> s.getSolutionDescriptor().getScore(s.getWorkingSolution()), ConstraintMatchPolicy.DISABLED, false);
    }

    private <Result_> Result_ callScoreDirector(Solution_ solution, SolutionUpdatePolicy solutionUpdatePolicy, Function<InnerScoreDirector<Solution_, Score_>, Result_> function, ConstraintMatchPolicy constraintMatchPolicy, boolean cloneSolution) {
        boolean isShadowVariableUpdateEnabled = solutionUpdatePolicy.isShadowVariableUpdateEnabled();
        Solution_ nonNullSolution = Objects.requireNonNull(solution);
        try (ScoreDirector scoreDirector = this.getScoreDirectorFactory().buildScoreDirector(cloneSolution, constraintMatchPolicy, !isShadowVariableUpdateEnabled);){
            nonNullSolution = cloneSolution ? scoreDirector.cloneSolution(nonNullSolution) : nonNullSolution;
            scoreDirector.setWorkingSolution(nonNullSolution);
            if (constraintMatchPolicy.isEnabled() && !scoreDirector.getConstraintMatchPolicy().isEnabled()) {
                throw new IllegalStateException("Requested constraint matching but score director doesn't support it.\nMaybe use Constraint Streams instead of Easy or Incremental score calculator?");
            }
            if (isShadowVariableUpdateEnabled) {
                scoreDirector.forceTriggerVariableListeners();
            }
            if (solutionUpdatePolicy.isScoreUpdateEnabled()) {
                scoreDirector.calculateScore();
            }
            Result_ Result_ = function.apply((InnerScoreDirector<Solution_, Score_>)scoreDirector);
            return Result_;
        }
    }

    @Override
    public @NonNull ScoreExplanation<Solution_, Score_> explain(@NonNull Solution_ solution, @NonNull SolutionUpdatePolicy solutionUpdatePolicy) {
        Object currentScore = this.scoreDirectorFactory.getSolutionDescriptor().getScore(solution);
        DefaultScoreExplanation explanation = this.callScoreDirector(solution, solutionUpdatePolicy, DefaultScoreExplanation::new, ConstraintMatchPolicy.ENABLED, false);
        this.assertFreshScore(solution, currentScore, explanation.getScore(), solutionUpdatePolicy);
        return explanation;
    }

    private void assertFreshScore(Solution_ solution, Score_ currentScore, Score_ calculatedScore, SolutionUpdatePolicy solutionUpdatePolicy) {
        if (!solutionUpdatePolicy.isScoreUpdateEnabled() && currentScore != null && !calculatedScore.equals(currentScore)) {
            throw new IllegalStateException("Current score (%s) and freshly calculated score (%s) for solution (%s) do not match.\nMaybe run %s environment mode to check for score corruptions.\nOtherwise enable %s.%s to update the stale score.\n".formatted(new Object[]{currentScore, calculatedScore, solution, EnvironmentMode.TRACKED_FULL_ASSERT, SolutionUpdatePolicy.class.getSimpleName(), SolutionUpdatePolicy.UPDATE_ALL}));
        }
    }

    @Override
    public @NonNull ScoreAnalysis<Score_> analyze(@NonNull Solution_ solution, @NonNull ScoreAnalysisFetchPolicy fetchPolicy, @NonNull SolutionUpdatePolicy solutionUpdatePolicy) {
        Objects.requireNonNull(fetchPolicy, "fetchPolicy");
        Object currentScore = this.scoreDirectorFactory.getSolutionDescriptor().getScore(solution);
        ScoreAnalysis analysis = this.callScoreDirector(solution, solutionUpdatePolicy, scoreDirector -> scoreDirector.buildScoreAnalysis(fetchPolicy), ConstraintMatchPolicy.match(fetchPolicy), false);
        this.assertFreshScore(solution, currentScore, analysis.score(), solutionUpdatePolicy);
        return analysis;
    }

    @Override
    public <In_, Out_> @NonNull List<RecommendedAssignment<Out_, Score_>> recommendAssignment(@NonNull Solution_ solution, @NonNull In_ evaluatedEntityOrElement, @NonNull Function<In_, Out_> propositionFunction, @NonNull ScoreAnalysisFetchPolicy fetchPolicy) {
        Assigner assigner = new Assigner(this.solverFactory, propositionFunction, DefaultRecommendedAssignment::new, fetchPolicy, solution, evaluatedEntityOrElement);
        return (List)this.callScoreDirector(solution, SolutionUpdatePolicy.UPDATE_ALL, assigner, ConstraintMatchPolicy.match(fetchPolicy), true);
    }

    @Override
    public <In_, Out_> List<RecommendedFit<Out_, Score_>> recommendFit(Solution_ solution, In_ fittedEntityOrElement, Function<In_, Out_> propositionFunction, ScoreAnalysisFetchPolicy fetchPolicy) {
        Assigner assigner = new Assigner(this.solverFactory, propositionFunction, DefaultRecommendedFit::new, fetchPolicy, solution, fittedEntityOrElement);
        return (List)this.callScoreDirector(solution, SolutionUpdatePolicy.UPDATE_ALL, assigner, ConstraintMatchPolicy.match(fetchPolicy), true);
    }
}

