/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.api.solver.ProblemSizeStatistics;
import ai.timefold.solver.core.api.solver.Solver;
import ai.timefold.solver.core.api.solver.SolverJob;
import ai.timefold.solver.core.api.solver.SolverStatus;
import ai.timefold.solver.core.api.solver.change.ProblemChange;
import ai.timefold.solver.core.api.solver.event.BestSolutionChangedEvent;
import ai.timefold.solver.core.impl.phase.AbstractPhase;
import ai.timefold.solver.core.impl.phase.Phase;
import ai.timefold.solver.core.impl.phase.event.PhaseLifecycleListenerAdapter;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.BestSolutionHolder;
import ai.timefold.solver.core.impl.solver.ConsumerSupport;
import ai.timefold.solver.core.impl.solver.DefaultSolver;
import ai.timefold.solver.core.impl.solver.DefaultSolverManager;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSolverJob<Solution_, ProblemId_>
implements SolverJob<Solution_, ProblemId_>,
Callable<Solution_> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSolverJob.class);
    private final DefaultSolverManager<Solution_, ProblemId_> solverManager;
    private final DefaultSolver<Solution_> solver;
    private final ProblemId_ problemId;
    private final Function<? super ProblemId_, ? extends Solution_> problemFinder;
    private final Consumer<? super Solution_> bestSolutionConsumer;
    private final Consumer<? super Solution_> finalBestSolutionConsumer;
    private final Consumer<? super Solution_> firstInitializedSolutionConsumer;
    private final Consumer<? super Solution_> solverJobStartedConsumer;
    private final BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler;
    private volatile SolverStatus solverStatus;
    private final CountDownLatch terminatedLatch;
    private final ReentrantLock solverStatusModifyingLock;
    private Future<Solution_> finalBestSolutionFuture;
    private ConsumerSupport<Solution_, ProblemId_> consumerSupport;
    private final AtomicBoolean terminatedEarly = new AtomicBoolean(false);
    private final BestSolutionHolder<Solution_> bestSolutionHolder = new BestSolutionHolder();

    public DefaultSolverJob(DefaultSolverManager<Solution_, ProblemId_> solverManager, Solver<Solution_> solver, ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> bestSolutionConsumer, Consumer<? super Solution_> finalBestSolutionConsumer, Consumer<? super Solution_> firstInitializedSolutionConsumer, Consumer<? super Solution_> solverJobStartedConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        this.solverManager = solverManager;
        this.problemId = problemId;
        if (!(solver instanceof DefaultSolver)) {
            throw new IllegalStateException("Impossible state: solver is not instance of %s.".formatted(DefaultSolver.class.getSimpleName()));
        }
        this.solver = (DefaultSolver)solver;
        this.problemFinder = problemFinder;
        this.bestSolutionConsumer = bestSolutionConsumer;
        this.finalBestSolutionConsumer = finalBestSolutionConsumer;
        this.firstInitializedSolutionConsumer = firstInitializedSolutionConsumer;
        this.solverJobStartedConsumer = solverJobStartedConsumer;
        this.exceptionHandler = exceptionHandler;
        this.solverStatus = SolverStatus.SOLVING_SCHEDULED;
        this.terminatedLatch = new CountDownLatch(1);
        this.solverStatusModifyingLock = new ReentrantLock();
    }

    public void setFinalBestSolutionFuture(Future<Solution_> finalBestSolutionFuture) {
        this.finalBestSolutionFuture = finalBestSolutionFuture;
    }

    @Override
    public @NonNull ProblemId_ getProblemId() {
        return this.problemId;
    }

    @Override
    public @NonNull SolverStatus getSolverStatus() {
        return this.solverStatus;
    }

    @Override
    public Solution_ call() {
        this.solverStatusModifyingLock.lock();
        if (this.solverStatus != SolverStatus.SOLVING_SCHEDULED) {
            this.solverStatusModifyingLock.unlock();
            return this.problemFinder.apply(this.problemId);
        }
        try {
            this.solverStatus = SolverStatus.SOLVING_ACTIVE;
            this.consumerSupport = new ConsumerSupport<Solution_, ProblemId_>(this.getProblemId(), this.bestSolutionConsumer, this.finalBestSolutionConsumer, this.firstInitializedSolutionConsumer, this.solverJobStartedConsumer, this.exceptionHandler, this.bestSolutionHolder);
            Solution_ problem = this.problemFinder.apply(this.problemId);
            this.solver.addPhaseLifecycleListener(new UnlockLockPhaseLifecycleListener());
            this.solver.addPhaseLifecycleListener(new FirstInitializedSolutionPhaseLifecycleListener(this.consumerSupport));
            this.solver.addPhaseLifecycleListener(new StartSolverJobPhaseLifecycleListener(this.consumerSupport));
            this.solver.addEventListener(this::onBestSolutionChangedEvent);
            Solution_ finalBestSolution = this.solver.solve(problem);
            this.consumerSupport.consumeFinalBestSolution(finalBestSolution);
            Solution_ Solution_ = finalBestSolution;
            return Solution_;
        }
        catch (Throwable e) {
            this.exceptionHandler.accept(this.problemId, e);
            this.bestSolutionHolder.cancelPendingChanges();
            throw new IllegalStateException("Solving failed for problemId (%s).".formatted(this.problemId), e);
        }
        finally {
            if (this.solverStatusModifyingLock.isHeldByCurrentThread()) {
                this.solverStatusModifyingLock.unlock();
            }
            this.solvingTerminated();
        }
    }

    private void onBestSolutionChangedEvent(BestSolutionChangedEvent<Solution_> bestSolutionChangedEvent) {
        this.consumerSupport.consumeIntermediateBestSolution(bestSolutionChangedEvent.getNewBestSolution(), () -> bestSolutionChangedEvent.isEveryProblemChangeProcessed());
    }

    private void solvingTerminated() {
        this.solverStatus = SolverStatus.NOT_SOLVING;
        this.solverManager.unregisterSolverJob(this.problemId);
        this.terminatedLatch.countDown();
        this.close();
    }

    @Override
    public @NonNull CompletableFuture<Void> addProblemChange(@NonNull ProblemChange<Solution_> problemChange) {
        Objects.requireNonNull(problemChange, () -> "A problem change (%s) must not be null.".formatted(this.problemId));
        if (this.solverStatus == SolverStatus.NOT_SOLVING) {
            throw new IllegalStateException("Cannot add the problem change (%s) because the solver job (%s) is not solving.".formatted(new Object[]{problemChange, this.solverStatus}));
        }
        return this.bestSolutionHolder.addProblemChange(this.solver, problemChange);
    }

    @Override
    public void terminateEarly() {
        this.terminatedEarly.set(true);
        try {
            this.solverStatusModifyingLock.lock();
            switch (this.solverStatus) {
                case SOLVING_SCHEDULED: {
                    this.finalBestSolutionFuture.cancel(false);
                    this.solvingTerminated();
                    break;
                }
                case SOLVING_ACTIVE: {
                    this.solver.terminateEarly();
                    break;
                }
                case NOT_SOLVING: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported solverStatus (%s).".formatted(new Object[]{this.solverStatus}));
                }
            }
            try {
                this.terminatedLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("The terminateEarly() call is interrupted.", (Throwable)e);
            }
        }
        finally {
            this.solverStatusModifyingLock.unlock();
        }
    }

    @Override
    public boolean isTerminatedEarly() {
        return this.terminatedEarly.get();
    }

    @Override
    public @NonNull Solution_ getFinalBestSolution() throws InterruptedException, ExecutionException {
        try {
            return this.finalBestSolutionFuture.get();
        }
        catch (CancellationException cancellationException) {
            LOGGER.debug("The terminateEarly() has been called before the solver job started solving. Retrieving the input problem instead.");
            return this.problemFinder.apply(this.problemId);
        }
    }

    @Override
    public @NonNull Duration getSolvingDuration() {
        return Duration.ofMillis(this.solver.getTimeMillisSpent());
    }

    @Override
    public long getScoreCalculationCount() {
        return this.solver.getScoreCalculationCount();
    }

    @Override
    public long getMoveEvaluationCount() {
        return this.solver.getMoveEvaluationCount();
    }

    @Override
    public long getScoreCalculationSpeed() {
        return this.solver.getScoreCalculationSpeed();
    }

    @Override
    public long getMoveEvaluationSpeed() {
        return this.solver.getMoveEvaluationSpeed();
    }

    @Override
    public @NonNull ProblemSizeStatistics getProblemSizeStatistics() {
        ProblemSizeStatistics problemSizeStatistics = this.solver.getSolverScope().getProblemSizeStatistics();
        if (problemSizeStatistics != null) {
            return problemSizeStatistics;
        }
        return this.solver.getSolverScope().getSolutionDescriptor().getProblemSizeStatistics(this.problemFinder.apply(this.problemId));
    }

    public Termination<Solution_> getSolverTermination() {
        return this.solver.solverTermination;
    }

    void close() {
        if (this.consumerSupport != null) {
            this.consumerSupport.close();
            this.consumerSupport = null;
        }
    }

    private final class UnlockLockPhaseLifecycleListener
    extends PhaseLifecycleListenerAdapter<Solution_> {
        private UnlockLockPhaseLifecycleListener() {
        }

        @Override
        public void solvingStarted(SolverScope<Solution_> solverScope) {
            if (DefaultSolverJob.this.solverStatusModifyingLock.isLocked()) {
                DefaultSolverJob.this.solverStatusModifyingLock.unlock();
            }
        }
    }

    private final class FirstInitializedSolutionPhaseLifecycleListener
    extends PhaseLifecycleListenerAdapter<Solution_> {
        private final ConsumerSupport<Solution_, ProblemId_> consumerSupport;

        public FirstInitializedSolutionPhaseLifecycleListener(ConsumerSupport<Solution_, ProblemId_> consumerSupport) {
            this.consumerSupport = consumerSupport;
        }

        @Override
        public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
            Phase eventPhase = DefaultSolverJob.this.solver.getPhaseList().stream().filter(phase -> ((AbstractPhase)phase).getPhaseIndex() == phaseScope.getPhaseIndex()).findFirst().orElseThrow(() -> new IllegalStateException("Solving failed for problemId (%s) because the phase id %d was not found.".formatted(DefaultSolverJob.this.problemId, phaseScope.getPhaseIndex())));
            if (eventPhase.triggersFirstInitializedSolutionEvent()) {
                this.consumerSupport.consumeFirstInitializedSolution(phaseScope.getWorkingSolution());
            }
        }
    }

    private final class StartSolverJobPhaseLifecycleListener
    extends PhaseLifecycleListenerAdapter<Solution_> {
        private final ConsumerSupport<Solution_, ProblemId_> consumerSupport;

        public StartSolverJobPhaseLifecycleListener(ConsumerSupport<Solution_, ProblemId_> consumerSupport) {
            this.consumerSupport = consumerSupport;
        }

        @Override
        public void solvingStarted(SolverScope<Solution_> solverScope) {
            this.consumerSupport.consumeStartSolverJob(solverScope.getWorkingSolution());
        }
    }
}

