/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.api.solver.Solver;
import ai.timefold.solver.core.api.solver.SolverConfigOverride;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.api.solver.SolverJob;
import ai.timefold.solver.core.api.solver.SolverJobBuilder;
import ai.timefold.solver.core.api.solver.SolverManager;
import ai.timefold.solver.core.api.solver.SolverStatus;
import ai.timefold.solver.core.api.solver.change.ProblemChange;
import ai.timefold.solver.core.config.solver.SolverManagerConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.solver.DefaultSolver;
import ai.timefold.solver.core.impl.solver.DefaultSolverJob;
import ai.timefold.solver.core.impl.solver.DefaultSolverJobBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSolverManager<Solution_, ProblemId_>
implements SolverManager<Solution_, ProblemId_> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSolverManager.class);
    private final BiConsumer<ProblemId_, Throwable> defaultExceptionHandler = (problemId, throwable) -> LOGGER.error("Solving failed for problemId ({}).", problemId, throwable);
    private final SolverFactory<Solution_> solverFactory;
    private final ExecutorService solverThreadPool;
    private final ConcurrentMap<Object, DefaultSolverJob<Solution_, ProblemId_>> problemIdToSolverJobMap;

    public DefaultSolverManager(SolverFactory<Solution_> solverFactory, SolverManagerConfig solverManagerConfig) {
        this.solverFactory = solverFactory;
        this.validateSolverFactory();
        Integer parallelSolverCount = solverManagerConfig.resolveParallelSolverCount();
        Class<? extends ThreadFactory> threadFactoryClass = solverManagerConfig.getThreadFactoryClass();
        ThreadFactory threadFactory = threadFactoryClass == null ? Executors.defaultThreadFactory() : ConfigUtils.newInstance(solverManagerConfig, "threadFactoryClass", threadFactoryClass);
        this.solverThreadPool = Executors.newFixedThreadPool(parallelSolverCount, threadFactory);
        this.problemIdToSolverJobMap = new ConcurrentHashMap<Object, DefaultSolverJob<Solution_, ProblemId_>>(parallelSolverCount * 10);
    }

    public SolverFactory<Solution_> getSolverFactory() {
        return this.solverFactory;
    }

    private void validateSolverFactory() {
        this.solverFactory.buildSolver();
    }

    private ProblemId_ getProblemIdOrThrow(ProblemId_ problemId) {
        return Objects.requireNonNull(problemId, "Invalid problemId (null) given to SolverManager.");
    }

    private DefaultSolverJob<Solution_, ProblemId_> getSolverJob(ProblemId_ problemId) {
        return (DefaultSolverJob)this.problemIdToSolverJobMap.get(this.getProblemIdOrThrow(problemId));
    }

    @Override
    public @NonNull SolverJobBuilder<Solution_, ProblemId_> solveBuilder() {
        return new DefaultSolverJobBuilder(this);
    }

    protected SolverJob<Solution_, ProblemId_> solveAndListen(ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> bestSolutionConsumer, Consumer<? super Solution_> finalBestSolutionConsumer, Consumer<? super Solution_> initializedSolutionConsumer, Consumer<? super Solution_> solverJobStartedConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler, SolverConfigOverride<Solution_> solverConfigOverride) {
        if (bestSolutionConsumer == null) {
            throw new IllegalStateException("The consumer bestSolutionConsumer is required.");
        }
        return this.solve(this.getProblemIdOrThrow(problemId), problemFinder, bestSolutionConsumer, finalBestSolutionConsumer, initializedSolutionConsumer, solverJobStartedConsumer, exceptionHandler, solverConfigOverride);
    }

    protected SolverJob<Solution_, ProblemId_> solve(ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> bestSolutionConsumer, Consumer<? super Solution_> finalBestSolutionConsumer, Consumer<? super Solution_> initializedSolutionConsumer, Consumer<? super Solution_> solverJobStartedConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler, SolverConfigOverride<Solution_> configOverride) {
        Solver<Solution_> solver = this.solverFactory.buildSolver(configOverride);
        ((DefaultSolver)solver).setMonitorTagMap(Map.of("problem.id", problemId.toString()));
        BiConsumer<Object, Throwable> finalExceptionHandler = exceptionHandler != null ? exceptionHandler : this.defaultExceptionHandler;
        DefaultSolverJob solverJob = this.problemIdToSolverJobMap.compute(problemId, (key, oldSolverJob) -> {
            if (oldSolverJob != null) {
                throw new IllegalStateException("The problemId (" + problemId + ") is already solving.");
            }
            return new DefaultSolverJob(this, solver, problemId, problemFinder, bestSolutionConsumer, finalBestSolutionConsumer, initializedSolutionConsumer, solverJobStartedConsumer, finalExceptionHandler);
        });
        Future future = this.solverThreadPool.submit(solverJob);
        solverJob.setFinalBestSolutionFuture(future);
        return solverJob;
    }

    @Override
    public @NonNull SolverStatus getSolverStatus(@NonNull ProblemId_ problemId) {
        DefaultSolverJob<Solution_, ProblemId_> solverJob = this.getSolverJob(problemId);
        if (solverJob == null) {
            return SolverStatus.NOT_SOLVING;
        }
        return solverJob.getSolverStatus();
    }

    @Override
    public @NonNull CompletableFuture<Void> addProblemChange(@NonNull ProblemId_ problemId, @NonNull ProblemChange<Solution_> problemChange) {
        DefaultSolverJob<Solution_, ProblemId_> solverJob = this.getSolverJob(problemId);
        if (solverJob == null) {
            throw new IllegalStateException("Cannot add the problem change (" + problemChange + ") because there is no solver solving the problemId (" + problemId + ").");
        }
        return solverJob.addProblemChange(problemChange);
    }

    @Override
    public void terminateEarly(@NonNull ProblemId_ problemId) {
        DefaultSolverJob<Solution_, ProblemId_> solverJob = this.getSolverJob(problemId);
        if (solverJob == null) {
            LOGGER.debug("Ignoring terminateEarly() call because problemId ({}) is not solving.", problemId);
            return;
        }
        solverJob.terminateEarly();
    }

    @Override
    public void close() {
        this.solverThreadPool.shutdownNow();
        this.problemIdToSolverJobMap.values().forEach(DefaultSolverJob::close);
    }

    void unregisterSolverJob(ProblemId_ problemId) {
        this.problemIdToSolverJobMap.remove(this.getProblemIdOrThrow(problemId));
    }
}

