/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.AbstractCompositeTermination;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;
import java.util.List;

public final class AndCompositeTermination<Solution_>
extends AbstractCompositeTermination<Solution_> {
    public AndCompositeTermination(List<Termination<Solution_>> terminationList) {
        super(terminationList);
    }

    public AndCompositeTermination(Termination<Solution_> ... terminations) {
        super(terminations);
    }

    @Override
    public boolean isSolverTerminated(SolverScope<Solution_> solverScope) {
        for (Termination termination : this.terminationList) {
            if (termination.isSolverTerminated(solverScope)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope<Solution_> phaseScope) {
        for (Termination termination : this.terminationList) {
            if (termination.isPhaseTerminated(phaseScope)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double calculateSolverTimeGradient(SolverScope<Solution_> solverScope) {
        double timeGradient = 1.0;
        for (Termination termination : this.terminationList) {
            double nextTimeGradient = termination.calculateSolverTimeGradient(solverScope);
            if (!(nextTimeGradient >= 0.0)) continue;
            timeGradient = Math.min(timeGradient, nextTimeGradient);
        }
        return timeGradient;
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope<Solution_> phaseScope) {
        double timeGradient = 1.0;
        for (Termination termination : this.terminationList) {
            double nextTimeGradient = termination.calculatePhaseTimeGradient(phaseScope);
            if (!(nextTimeGradient >= 0.0)) continue;
            timeGradient = Math.min(timeGradient, nextTimeGradient);
        }
        return timeGradient;
    }

    @Override
    public AndCompositeTermination<Solution_> createChildThreadTermination(SolverScope<Solution_> solverScope, ChildThreadType childThreadType) {
        return new AndCompositeTermination<Solution_>(this.createChildThreadTerminationList(solverScope, childThreadType));
    }

    public String toString() {
        return "And(" + this.terminationList + ")";
    }
}

