/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.AbstractTermination;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;

public final class MoveCountTermination<Solution_>
extends AbstractTermination<Solution_> {
    private final long moveCountLimit;

    public MoveCountTermination(long moveCountLimit) {
        this.moveCountLimit = moveCountLimit;
        if (moveCountLimit < 0L) {
            throw new IllegalArgumentException("The moveCountLimit (%d) cannot be negative.".formatted(moveCountLimit));
        }
    }

    public long getMoveCountLimit() {
        return this.moveCountLimit;
    }

    @Override
    public boolean isSolverTerminated(SolverScope<Solution_> solverScope) {
        return this.isTerminated(solverScope);
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope<Solution_> phaseScope) {
        return this.isTerminated(phaseScope.getSolverScope());
    }

    private boolean isTerminated(SolverScope<Solution_> solverScope) {
        long moveEvaluationCount = solverScope.getMoveEvaluationCount();
        return moveEvaluationCount >= this.moveCountLimit;
    }

    @Override
    public double calculateSolverTimeGradient(SolverScope<Solution_> solverScope) {
        return this.calculateTimeGradient(solverScope);
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope<Solution_> phaseScope) {
        return this.calculateTimeGradient(phaseScope.getSolverScope());
    }

    private double calculateTimeGradient(SolverScope<Solution_> solverScope) {
        long moveEvaluationCount = solverScope.getMoveEvaluationCount();
        double timeGradient = (double)moveEvaluationCount / (double)this.moveCountLimit;
        return Math.min(timeGradient, 1.0);
    }

    @Override
    public MoveCountTermination<Solution_> createChildThreadTermination(SolverScope<Solution_> solverScope, ChildThreadType childThreadType) {
        return new MoveCountTermination<Solution_>(this.moveCountLimit);
    }

    public String toString() {
        return "MoveCount(%d)".formatted(this.moveCountLimit);
    }
}

