/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.config.solver.termination.TerminationCompositionStyle;
import ai.timefold.solver.core.config.solver.termination.TerminationConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.solver.termination.AbstractCompositeTermination;
import ai.timefold.solver.core.impl.solver.termination.AndCompositeTermination;
import ai.timefold.solver.core.impl.solver.termination.BestScoreFeasibleTermination;
import ai.timefold.solver.core.impl.solver.termination.BestScoreTermination;
import ai.timefold.solver.core.impl.solver.termination.MoveCountTermination;
import ai.timefold.solver.core.impl.solver.termination.OrCompositeTermination;
import ai.timefold.solver.core.impl.solver.termination.ScoreCalculationCountTermination;
import ai.timefold.solver.core.impl.solver.termination.StepCountTermination;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import ai.timefold.solver.core.impl.solver.termination.TimeMillisSpentTermination;
import ai.timefold.solver.core.impl.solver.termination.UnimprovedStepCountTermination;
import ai.timefold.solver.core.impl.solver.termination.UnimprovedTimeMillisSpentScoreDifferenceThresholdTermination;
import ai.timefold.solver.core.impl.solver.termination.UnimprovedTimeMillisSpentTermination;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TerminationFactory<Solution_> {
    private final TerminationConfig terminationConfig;

    public static <Solution_> TerminationFactory<Solution_> create(TerminationConfig terminationConfig) {
        return new TerminationFactory<Solution_>(terminationConfig);
    }

    private TerminationFactory(TerminationConfig terminationConfig) {
        this.terminationConfig = terminationConfig;
    }

    public Termination<Solution_> buildTermination(HeuristicConfigPolicy<Solution_> configPolicy, Termination<Solution_> chainedTermination) {
        Termination<Solution_> termination = this.buildTermination(configPolicy);
        if (termination == null) {
            return chainedTermination;
        }
        return new OrCompositeTermination(chainedTermination, termination);
    }

    public <Score_ extends Score<Score_>> Termination<Solution_> buildTermination(HeuristicConfigPolicy<Solution_> configPolicy) {
        Boolean bestScoreFeasible;
        ArrayList<Termination<Solution_>> terminationList = new ArrayList<Termination<Solution_>>();
        if (this.terminationConfig.getTerminationClass() != null) {
            Termination termination = ConfigUtils.newInstance(this.terminationConfig, "terminationClass", this.terminationConfig.getTerminationClass());
            terminationList.add(termination);
        }
        terminationList.addAll(this.buildTimeBasedTermination(configPolicy));
        if (this.terminationConfig.getBestScoreLimit() != null) {
            ScoreDefinition scoreDefinition = configPolicy.getScoreDefinition();
            Object bestScoreLimit_ = scoreDefinition.parseScore(this.terminationConfig.getBestScoreLimit());
            double[] timeGradientWeightNumbers = new double[scoreDefinition.getLevelsSize() - 1];
            Arrays.fill(timeGradientWeightNumbers, 0.5);
            terminationList.add(new BestScoreTermination(scoreDefinition, (Score<?>)bestScoreLimit_, timeGradientWeightNumbers));
        }
        if ((bestScoreFeasible = this.terminationConfig.getBestScoreFeasible()) != null) {
            ScoreDefinition scoreDefinition = configPolicy.getScoreDefinition();
            if (!bestScoreFeasible.booleanValue()) {
                throw new IllegalArgumentException("The termination bestScoreFeasible (%s) cannot be false.".formatted(bestScoreFeasible));
            }
            int feasibleLevelsSize = scoreDefinition.getFeasibleLevelsSize();
            if (feasibleLevelsSize < 1) {
                throw new IllegalStateException("The termination with bestScoreFeasible (%s) can only be used with a score type that has at least 1 feasible level but the scoreDefinition (%s) has feasibleLevelsSize (%s), which is less than 1.".formatted(bestScoreFeasible, scoreDefinition, feasibleLevelsSize));
            }
            double[] timeGradientWeightFeasibleNumbers = new double[feasibleLevelsSize - 1];
            Arrays.fill(timeGradientWeightFeasibleNumbers, 0.5);
            terminationList.add(new BestScoreFeasibleTermination(scoreDefinition, timeGradientWeightFeasibleNumbers));
        }
        if (this.terminationConfig.getStepCountLimit() != null) {
            terminationList.add(new StepCountTermination(this.terminationConfig.getStepCountLimit()));
        }
        if (this.terminationConfig.getScoreCalculationCountLimit() != null) {
            terminationList.add(new ScoreCalculationCountTermination(this.terminationConfig.getScoreCalculationCountLimit()));
        }
        if (this.terminationConfig.getUnimprovedStepCountLimit() != null) {
            terminationList.add(new UnimprovedStepCountTermination(this.terminationConfig.getUnimprovedStepCountLimit()));
        }
        if (this.terminationConfig.getMoveCountLimit() != null) {
            terminationList.add(new MoveCountTermination(this.terminationConfig.getMoveCountLimit()));
        }
        terminationList.addAll(this.buildInnerTermination(configPolicy));
        return this.buildTerminationFromList(terminationList);
    }

    protected <Score_ extends Score<Score_>> List<Termination<Solution_>> buildTimeBasedTermination(HeuristicConfigPolicy<Solution_> configPolicy) {
        Long unimprovedTimeMillisSpentLimit;
        ArrayList<Termination<Solution_>> terminationList = new ArrayList<Termination<Solution_>>();
        Long timeMillisSpentLimit = this.terminationConfig.calculateTimeMillisSpentLimit();
        if (timeMillisSpentLimit != null) {
            terminationList.add(new TimeMillisSpentTermination(timeMillisSpentLimit));
        }
        if ((unimprovedTimeMillisSpentLimit = this.terminationConfig.calculateUnimprovedTimeMillisSpentLimit()) != null) {
            if (this.terminationConfig.getUnimprovedScoreDifferenceThreshold() == null) {
                terminationList.add(new UnimprovedTimeMillisSpentTermination(unimprovedTimeMillisSpentLimit));
            } else {
                Object unimprovedScoreDifferenceThreshold_;
                ScoreDefinition scoreDefinition = configPolicy.getScoreDefinition();
                if (scoreDefinition.isNegativeOrZero(unimprovedScoreDifferenceThreshold_ = scoreDefinition.parseScore(this.terminationConfig.getUnimprovedScoreDifferenceThreshold()))) {
                    throw new IllegalStateException("The unimprovedScoreDifferenceThreshold (" + this.terminationConfig.getUnimprovedScoreDifferenceThreshold() + ") must be positive.");
                }
                terminationList.add(new UnimprovedTimeMillisSpentScoreDifferenceThresholdTermination(unimprovedTimeMillisSpentLimit, (Score<?>)unimprovedScoreDifferenceThreshold_));
            }
        } else if (this.terminationConfig.getUnimprovedScoreDifferenceThreshold() != null) {
            throw new IllegalStateException("The unimprovedScoreDifferenceThreshold (" + this.terminationConfig.getUnimprovedScoreDifferenceThreshold() + ") can only be used if an unimproved*SpentLimit (" + unimprovedTimeMillisSpentLimit + ") is used too.");
        }
        return terminationList;
    }

    protected List<Termination<Solution_>> buildInnerTermination(HeuristicConfigPolicy<Solution_> configPolicy) {
        List<TerminationConfig> terminationConfigList = this.terminationConfig.getTerminationConfigList();
        if (ConfigUtils.isEmptyCollection(terminationConfigList)) {
            return Collections.emptyList();
        }
        return terminationConfigList.stream().map(config -> TerminationFactory.create(config).buildTermination(configPolicy)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected Termination<Solution_> buildTerminationFromList(List<Termination<Solution_>> terminationList) {
        AbstractCompositeTermination compositeTermination;
        if (terminationList.isEmpty()) {
            return null;
        }
        if (terminationList.size() == 1) {
            return terminationList.get(0);
        }
        if (this.terminationConfig.getTerminationCompositionStyle() == null || this.terminationConfig.getTerminationCompositionStyle() == TerminationCompositionStyle.OR) {
            compositeTermination = new OrCompositeTermination<Solution_>(terminationList);
        } else if (this.terminationConfig.getTerminationCompositionStyle() == TerminationCompositionStyle.AND) {
            compositeTermination = new AndCompositeTermination<Solution_>(terminationList);
        } else {
            throw new IllegalStateException("The terminationCompositionStyle (" + this.terminationConfig.getTerminationCompositionStyle() + ") is not implemented.");
        }
        return compositeTermination;
    }
}

