/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.AbstractTermination;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;
import java.time.Clock;

public final class UnimprovedTimeMillisSpentTermination<Solution_>
extends AbstractTermination<Solution_> {
    private final long unimprovedTimeMillisSpentLimit;
    private final Clock clock;
    private boolean currentPhaseSendsBestSolutionEvents = false;
    private long phaseStartedTimeMillis = -1L;

    public UnimprovedTimeMillisSpentTermination(long unimprovedTimeMillisSpentLimit) {
        this(unimprovedTimeMillisSpentLimit, Clock.systemUTC());
    }

    UnimprovedTimeMillisSpentTermination(long unimprovedTimeMillisSpentLimit, Clock clock) {
        this.unimprovedTimeMillisSpentLimit = unimprovedTimeMillisSpentLimit;
        if (unimprovedTimeMillisSpentLimit < 0L) {
            throw new IllegalArgumentException("The unimprovedTimeMillisSpentLimit (%d) cannot be negative.".formatted(unimprovedTimeMillisSpentLimit));
        }
        this.clock = clock;
    }

    public long getUnimprovedTimeMillisSpentLimit() {
        return this.unimprovedTimeMillisSpentLimit;
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        this.currentPhaseSendsBestSolutionEvents = phaseScope.isPhaseSendingBestSolutionEvents();
        this.phaseStartedTimeMillis = this.clock.millis();
    }

    @Override
    public boolean isSolverTerminated(SolverScope<Solution_> solverScope) {
        long bestSolutionTimeMillis = solverScope.getBestSolutionTimeMillis();
        return this.isTerminated(bestSolutionTimeMillis);
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope<Solution_> phaseScope) {
        long bestSolutionTimeMillis = phaseScope.getPhaseBestSolutionTimeMillis();
        return this.isTerminated(bestSolutionTimeMillis);
    }

    private boolean isTerminated(long bestSolutionTimeMillis) {
        if (!this.currentPhaseSendsBestSolutionEvents) {
            return false;
        }
        return this.getUnimprovedTimeMillisSpent(bestSolutionTimeMillis) >= this.unimprovedTimeMillisSpentLimit;
    }

    private long getUnimprovedTimeMillisSpent(long bestSolutionTimeMillis) {
        long now = this.clock.millis();
        return now - Math.max(bestSolutionTimeMillis, this.phaseStartedTimeMillis);
    }

    @Override
    public double calculateSolverTimeGradient(SolverScope<Solution_> solverScope) {
        long bestSolutionTimeMillis = solverScope.getBestSolutionTimeMillis();
        return this.calculateTimeGradient(bestSolutionTimeMillis);
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope<Solution_> phaseScope) {
        long bestSolutionTimeMillis = phaseScope.getPhaseBestSolutionTimeMillis();
        return this.calculateTimeGradient(bestSolutionTimeMillis);
    }

    private double calculateTimeGradient(long bestSolutionTimeMillis) {
        if (!this.currentPhaseSendsBestSolutionEvents) {
            return 0.0;
        }
        double timeGradient = (double)this.getUnimprovedTimeMillisSpent(bestSolutionTimeMillis) / (double)this.unimprovedTimeMillisSpentLimit;
        return Math.min(timeGradient, 1.0);
    }

    @Override
    public UnimprovedTimeMillisSpentTermination<Solution_> createChildThreadTermination(SolverScope<Solution_> solverScope, ChildThreadType childThreadType) {
        return new UnimprovedTimeMillisSpentTermination<Solution_>(this.unimprovedTimeMillisSpentLimit);
    }

    public String toString() {
        return "UnimprovedTimeMillisSpent(" + this.unimprovedTimeMillisSpentLimit + ")";
    }
}

