/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.statistic;

import ai.timefold.solver.core.api.solver.Solver;
import ai.timefold.solver.core.api.solver.event.SolverEventListener;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.solver.DefaultSolver;
import ai.timefold.solver.core.impl.statistic.SolverStatistic;
import io.micrometer.core.instrument.Tags;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class BestScoreStatistic<Solution_>
implements SolverStatistic<Solution_> {
    private final Map<Tags, List<AtomicReference<Number>>> tagsToBestScoreMap = new ConcurrentHashMap<Tags, List<AtomicReference<Number>>>();
    private final Map<Solver<Solution_>, SolverEventListener<Solution_>> solverToEventListenerMap = new WeakHashMap<Solver<Solution_>, SolverEventListener<Solution_>>();

    @Override
    public void unregister(Solver<Solution_> solver) {
        SolverEventListener<Solution_> listener = this.solverToEventListenerMap.remove(solver);
        if (listener != null) {
            solver.removeEventListener(listener);
        }
    }

    @Override
    public void register(Solver<Solution_> solver) {
        DefaultSolver defaultSolver = (DefaultSolver)solver;
        ScoreDefinition scoreDefinition = defaultSolver.getSolverScope().getScoreDefinition();
        SolverEventListener listener = event -> SolverMetric.registerScoreMetrics(SolverMetric.BEST_SCORE, defaultSolver.getSolverScope().getMonitoringTags(), scoreDefinition, this.tagsToBestScoreMap, event.getNewBestScore());
        this.solverToEventListenerMap.put(defaultSolver, listener);
        defaultSolver.addEventListener(listener);
    }
}

