/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.statistic;

import ai.timefold.solver.core.api.solver.Solver;
import ai.timefold.solver.core.api.solver.event.BestSolutionChangedEvent;
import ai.timefold.solver.core.api.solver.event.SolverEventListener;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.solution.mutation.MutationCounter;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirectorFactory;
import ai.timefold.solver.core.impl.solver.DefaultSolver;
import ai.timefold.solver.core.impl.statistic.SolverStatistic;
import io.micrometer.core.instrument.Metrics;
import java.util.Map;
import java.util.WeakHashMap;
import org.jspecify.annotations.NonNull;

public class BestSolutionMutationCountStatistic<Solution_>
implements SolverStatistic<Solution_> {
    private final Map<Solver<Solution_>, SolverEventListener<Solution_>> solverToEventListenerMap = new WeakHashMap<Solver<Solution_>, SolverEventListener<Solution_>>();

    @Override
    public void unregister(Solver<Solution_> solver) {
        SolverEventListener<Solution_> listener = this.solverToEventListenerMap.remove(solver);
        if (listener != null) {
            solver.removeEventListener(listener);
        }
    }

    @Override
    public void register(Solver<Solution_> solver) {
        DefaultSolver defaultSolver = (DefaultSolver)solver;
        InnerScoreDirectorFactory innerScoreDirectorFactory = defaultSolver.getScoreDirectorFactory();
        SolutionDescriptor solutionDescriptor = innerScoreDirectorFactory.getSolutionDescriptor();
        MutationCounter mutationCounter = new MutationCounter(solutionDescriptor);
        BestSolutionMutationCountStatisticListener listener = (BestSolutionMutationCountStatisticListener)Metrics.gauge((String)SolverMetric.BEST_SOLUTION_MUTATION.getMeterId(), (Iterable)defaultSolver.getSolverScope().getMonitoringTags(), new BestSolutionMutationCountStatisticListener(mutationCounter), BestSolutionMutationCountStatisticListener::getMutationCount);
        this.solverToEventListenerMap.put(solver, listener);
        solver.addEventListener(listener);
    }

    private static class BestSolutionMutationCountStatisticListener<Solution_>
    implements SolverEventListener<Solution_> {
        final MutationCounter<Solution_> mutationCounter;
        int mutationCount = 0;
        Solution_ oldBestSolution = null;

        public BestSolutionMutationCountStatisticListener(MutationCounter<Solution_> mutationCounter) {
            this.mutationCounter = mutationCounter;
        }

        public int getMutationCount() {
            return this.mutationCount;
        }

        @Override
        public void bestSolutionChanged(@NonNull BestSolutionChangedEvent<Solution_> event) {
            Solution_ newBestSolution = event.getNewBestSolution();
            this.mutationCount = this.oldBestSolution == null ? 0 : this.mutationCounter.countMutations(this.oldBestSolution, newBestSolution);
            this.oldBestSolution = newBestSolution;
        }
    }
}

