/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.util;

import ai.timefold.solver.core.impl.util.ElementAwareListEntry;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;

public final class ElementAwareList<T>
implements Iterable<T> {
    private int size = 0;
    private ElementAwareListEntry<T> first = null;
    private ElementAwareListEntry<T> last = null;

    public ElementAwareListEntry<T> add(T tuple) {
        ElementAwareListEntry<T> entry = new ElementAwareListEntry<T>(this, tuple, this.last);
        if (this.first == null) {
            this.first = entry;
        } else {
            this.last.next = entry;
        }
        this.last = entry;
        ++this.size;
        return entry;
    }

    public ElementAwareListEntry<T> addFirst(T tuple) {
        if (this.first != null) {
            ElementAwareListEntry<T> entry = new ElementAwareListEntry<T>(this, tuple, null);
            this.first.previous = entry;
            entry.next = this.first;
            this.first = entry;
            ++this.size;
            return entry;
        }
        return this.add(tuple);
    }

    public ElementAwareListEntry<T> addAfter(T tuple, ElementAwareListEntry<T> previous) {
        Objects.requireNonNull(previous);
        if (this.first == null || previous == this.last) {
            return this.add(tuple);
        }
        ElementAwareListEntry<T> entry = new ElementAwareListEntry<T>(this, tuple, previous);
        ElementAwareListEntry currentNext = previous.next;
        if (currentNext != null) {
            currentNext.previous = entry;
        } else {
            this.last = entry;
        }
        previous.next = entry;
        entry.next = currentNext;
        ++this.size;
        return entry;
    }

    public void remove(ElementAwareListEntry<T> entry) {
        if (this.first == entry) {
            this.first = entry.next;
        } else {
            entry.previous.next = entry.next;
        }
        if (this.last == entry) {
            this.last = entry.previous;
        } else {
            entry.next.previous = entry.previous;
        }
        entry.previous = null;
        entry.next = null;
        --this.size;
    }

    public ElementAwareListEntry<T> first() {
        return this.first;
    }

    public ElementAwareListEntry<T> last() {
        return this.last;
    }

    public int size() {
        return this.size;
    }

    @Override
    public void forEach(Consumer<? super T> tupleConsumer) {
        ElementAwareListEntry<T> entry = this.first;
        while (entry != null) {
            ElementAwareListEntry next = entry.next;
            tupleConsumer.accept(entry.getElement());
            entry = next;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new ElementAwareListIterator<T>(this.first);
    }

    public String toString() {
        switch (this.size) {
            case 0: {
                return "[]";
            }
            case 1: {
                return "[" + this.first.getElement() + "]";
            }
        }
        StringBuilder builder = new StringBuilder("[");
        for (T entry : this) {
            builder.append(entry).append(", ");
        }
        builder.replace(builder.length() - 2, builder.length(), "");
        return builder.append("]").toString();
    }

    private static final class ElementAwareListIterator<T>
    implements Iterator<T> {
        private ElementAwareListEntry<T> nextEntry;

        public ElementAwareListIterator(ElementAwareListEntry<T> nextEntry) {
            this.nextEntry = nextEntry;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T element = this.nextEntry.getElement();
            this.nextEntry = this.nextEntry.next;
            return element;
        }
    }
}

