/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.preview.api.domain.metamodel;

import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningSolutionMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.List;
import org.jspecify.annotations.NonNull;

public interface PlanningEntityMetaModel<Solution_, Entity_> {
    public @NonNull PlanningSolutionMetaModel<Solution_> solution();

    public @NonNull Class<Entity_> type();

    public @NonNull List<VariableMetaModel<Solution_, Entity_, ?>> variables();

    default public @NonNull List<VariableMetaModel<Solution_, Entity_, ?>> genuineVariables() {
        return this.variables().stream().filter(VariableMetaModel::isGenuine).toList();
    }

    default public <Value_> @NonNull VariableMetaModel<Solution_, Entity_, Value_> variable(@NonNull String variableName) {
        for (VariableMetaModel<Solution_, Entity_, ?> variableMetaModel : this.variables()) {
            if (!variableMetaModel.name().equals(variableName)) continue;
            return variableMetaModel;
        }
        throw new IllegalArgumentException("The variableName (%s) does not exist in the variables (%s).".formatted(variableName, this.variables()));
    }

    default public <Value_> @NonNull PlanningVariableMetaModel<Solution_, Entity_, Value_> planningVariable(@NonNull String variableName) {
        return (PlanningVariableMetaModel)this.variable(variableName);
    }

    default public <Value_> @NonNull PlanningListVariableMetaModel<Solution_, Entity_, Value_> planningListVariable(@NonNull String variableName) {
        return (PlanningListVariableMetaModel)this.variable(variableName);
    }

    default public boolean isGenuine() {
        for (VariableMetaModel<Solution_, Entity_, ?> variableMetaModel : this.variables()) {
            if (!variableMetaModel.isGenuine()) continue;
            return true;
        }
        return false;
    }
}

