/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.analysis;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public record MatchAnalysis<Score_ extends Score<Score_>>(@NonNull ConstraintRef constraintRef, @NonNull Score_ score, @NonNull ConstraintJustification justification) implements Comparable<MatchAnalysis<Score_>>
{
    public MatchAnalysis(@NonNull ConstraintRef constraintRef, @NonNull Score_ score, @NonNull ConstraintJustification justification) {
        Objects.requireNonNull(constraintRef);
        Objects.requireNonNull(score);
        Objects.requireNonNull(justification, () -> "Impossible state: Received a null justification.\nMaybe check your %s's justifyWith() implementation for that constraint?".formatted(ConstraintProvider.class));
    }

    MatchAnalysis<Score_> negate() {
        return new MatchAnalysis(this.constraintRef, this.score.negate(), this.justification);
    }

    @Override
    public int compareTo(MatchAnalysis<Score_> other) {
        int constraintRefComparison = this.constraintRef.compareTo(other.constraintRef);
        if (constraintRefComparison != 0) {
            return constraintRefComparison;
        }
        int scoreComparison = this.score.compareTo(other.score);
        if (scoreComparison != 0) {
            return scoreComparison;
        }
        ConstraintJustification constraintJustification = this.justification;
        if (constraintJustification instanceof Comparable) {
            Comparable comparableJustification = (Comparable)((Object)constraintJustification);
            constraintJustification = other.justification;
            if (constraintJustification instanceof Comparable) {
                Comparable otherComparableJustification = (Comparable)((Object)constraintJustification);
                return comparableJustification.compareTo(otherComparableJustification);
            }
        }
        return 0;
    }
}

