/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.buildin.hardsoftbigdecimal;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.ScoreUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HardSoftBigDecimalScore
implements Score<HardSoftBigDecimalScore> {
    public static final HardSoftBigDecimalScore ZERO = new HardSoftBigDecimalScore(BigDecimal.ZERO, BigDecimal.ZERO);
    public static final HardSoftBigDecimalScore ONE_HARD = new HardSoftBigDecimalScore(BigDecimal.ONE, BigDecimal.ZERO);
    public static final HardSoftBigDecimalScore ONE_SOFT = new HardSoftBigDecimalScore(BigDecimal.ZERO, BigDecimal.ONE);
    private final BigDecimal hardScore;
    private final BigDecimal softScore;

    public static HardSoftBigDecimalScore parseScore(String scoreString) {
        String[] scoreTokens = ScoreUtil.parseScoreTokens(HardSoftBigDecimalScore.class, scoreString, "hard", "soft");
        BigDecimal hardScore = ScoreUtil.parseLevelAsBigDecimal(HardSoftBigDecimalScore.class, scoreString, scoreTokens[0]);
        BigDecimal softScore = ScoreUtil.parseLevelAsBigDecimal(HardSoftBigDecimalScore.class, scoreString, scoreTokens[1]);
        return HardSoftBigDecimalScore.of(hardScore, softScore);
    }

    @Deprecated(forRemoval=true, since="1.22.0")
    public static HardSoftBigDecimalScore ofUninitialized(int initScore, BigDecimal hardScore, BigDecimal softScore) {
        return HardSoftBigDecimalScore.of(hardScore, softScore);
    }

    public static HardSoftBigDecimalScore of(BigDecimal hardScore, BigDecimal softScore) {
        if (hardScore.signum() == 0) {
            if (softScore.signum() == 0) {
                return ZERO;
            }
            if (Objects.equals(softScore, BigDecimal.ONE)) {
                return ONE_SOFT;
            }
        } else if (Objects.equals(hardScore, BigDecimal.ONE) && softScore.signum() == 0) {
            return ONE_HARD;
        }
        return new HardSoftBigDecimalScore(hardScore, softScore);
    }

    public static HardSoftBigDecimalScore ofHard(BigDecimal hardScore) {
        if (hardScore.signum() == 0) {
            return ZERO;
        }
        if (Objects.equals(hardScore, BigDecimal.ONE)) {
            return ONE_HARD;
        }
        return new HardSoftBigDecimalScore(hardScore, BigDecimal.ZERO);
    }

    public static HardSoftBigDecimalScore ofSoft(BigDecimal softScore) {
        if (softScore.signum() == 0) {
            return ZERO;
        }
        if (Objects.equals(softScore, BigDecimal.ONE)) {
            return ONE_SOFT;
        }
        return new HardSoftBigDecimalScore(BigDecimal.ZERO, softScore);
    }

    private HardSoftBigDecimalScore() {
        this(BigDecimal.ZERO, BigDecimal.ZERO);
    }

    private HardSoftBigDecimalScore(BigDecimal hardScore, BigDecimal softScore) {
        this.hardScore = hardScore;
        this.softScore = softScore;
    }

    public BigDecimal hardScore() {
        return this.hardScore;
    }

    @Deprecated(forRemoval=true)
    public BigDecimal getHardScore() {
        return this.hardScore;
    }

    public BigDecimal softScore() {
        return this.softScore;
    }

    @Deprecated(forRemoval=true)
    public BigDecimal getSoftScore() {
        return this.softScore;
    }

    @Override
    public boolean isFeasible() {
        return this.hardScore.signum() >= 0;
    }

    @Override
    public HardSoftBigDecimalScore add(HardSoftBigDecimalScore addend) {
        return HardSoftBigDecimalScore.of(this.hardScore.add(addend.hardScore()), this.softScore.add(addend.softScore()));
    }

    @Override
    public HardSoftBigDecimalScore subtract(HardSoftBigDecimalScore subtrahend) {
        return HardSoftBigDecimalScore.of(this.hardScore.subtract(subtrahend.hardScore()), this.softScore.subtract(subtrahend.softScore()));
    }

    @Override
    public HardSoftBigDecimalScore multiply(double multiplicand) {
        BigDecimal multiplicandBigDecimal = BigDecimal.valueOf(multiplicand);
        return HardSoftBigDecimalScore.of(this.hardScore.multiply(multiplicandBigDecimal).setScale(this.hardScore.scale(), RoundingMode.FLOOR), this.softScore.multiply(multiplicandBigDecimal).setScale(this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public HardSoftBigDecimalScore divide(double divisor) {
        BigDecimal divisorBigDecimal = BigDecimal.valueOf(divisor);
        return HardSoftBigDecimalScore.of(this.hardScore.divide(divisorBigDecimal, this.hardScore.scale(), RoundingMode.FLOOR), this.softScore.divide(divisorBigDecimal, this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public HardSoftBigDecimalScore power(double exponent) {
        BigDecimal exponentBigDecimal = BigDecimal.valueOf(exponent);
        return HardSoftBigDecimalScore.of(this.hardScore.pow(exponentBigDecimal.intValue()).setScale(this.hardScore.scale(), RoundingMode.FLOOR), this.softScore.pow(exponentBigDecimal.intValue()).setScale(this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public HardSoftBigDecimalScore abs() {
        return HardSoftBigDecimalScore.of(this.hardScore.abs(), this.softScore.abs());
    }

    @Override
    public HardSoftBigDecimalScore zero() {
        return ZERO;
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.hardScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (o instanceof HardSoftBigDecimalScore) {
            HardSoftBigDecimalScore other = (HardSoftBigDecimalScore)o;
            return this.hardScore.stripTrailingZeros().equals(other.hardScore().stripTrailingZeros()) && this.softScore.stripTrailingZeros().equals(other.softScore().stripTrailingZeros());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.hardScore.stripTrailingZeros(), this.softScore.stripTrailingZeros());
    }

    @Override
    public int compareTo(HardSoftBigDecimalScore other) {
        int hardScoreComparison = this.hardScore.compareTo(other.hardScore());
        if (hardScoreComparison != 0) {
            return hardScoreComparison;
        }
        return this.softScore.compareTo(other.softScore());
    }

    @Override
    public String toShortString() {
        return ScoreUtil.buildShortString(this, n -> ((BigDecimal)n).compareTo(BigDecimal.ZERO) != 0, "hard", "soft");
    }

    public String toString() {
        return String.valueOf(this.hardScore) + "hard/" + String.valueOf(this.softScore) + "soft";
    }
}

