/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.constructionheuristic.placer;

import ai.timefold.solver.core.config.constructionheuristic.placer.EntityPlacerConfig;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.composite.CartesianProductMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.factory.MoveIteratorFactoryConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.factory.MoveListFactoryConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.PillarChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.PillarSwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.SwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.chained.SubChainChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.chained.SubChainSwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.chained.TailChainSwapMoveSelectorConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@XmlType(propOrder={"entitySelectorConfig", "moveSelectorConfigList"})
public class QueuedEntityPlacerConfig
extends EntityPlacerConfig<QueuedEntityPlacerConfig> {
    @XmlElement(name="entitySelector")
    protected EntitySelectorConfig entitySelectorConfig = null;
    @XmlElements(value={@XmlElement(name="cartesianProductMoveSelector", type=CartesianProductMoveSelectorConfig.class), @XmlElement(name="changeMoveSelector", type=ChangeMoveSelectorConfig.class), @XmlElement(name="moveIteratorFactory", type=MoveIteratorFactoryConfig.class), @XmlElement(name="moveListFactory", type=MoveListFactoryConfig.class), @XmlElement(name="pillarChangeMoveSelector", type=PillarChangeMoveSelectorConfig.class), @XmlElement(name="pillarSwapMoveSelector", type=PillarSwapMoveSelectorConfig.class), @XmlElement(name="subChainChangeMoveSelector", type=SubChainChangeMoveSelectorConfig.class), @XmlElement(name="subChainSwapMoveSelector", type=SubChainSwapMoveSelectorConfig.class), @XmlElement(name="swapMoveSelector", type=SwapMoveSelectorConfig.class), @XmlElement(name="tailChainSwapMoveSelector", type=TailChainSwapMoveSelectorConfig.class), @XmlElement(name="unionMoveSelector", type=UnionMoveSelectorConfig.class)})
    protected List<MoveSelectorConfig> moveSelectorConfigList = null;

    public @Nullable EntitySelectorConfig getEntitySelectorConfig() {
        return this.entitySelectorConfig;
    }

    public void setEntitySelectorConfig(@Nullable EntitySelectorConfig entitySelectorConfig) {
        this.entitySelectorConfig = entitySelectorConfig;
    }

    public @Nullable List<@NonNull MoveSelectorConfig> getMoveSelectorConfigList() {
        return this.moveSelectorConfigList;
    }

    public void setMoveSelectorConfigList(@Nullable List<@NonNull MoveSelectorConfig> moveSelectorConfigList) {
        this.moveSelectorConfigList = moveSelectorConfigList;
    }

    public @NonNull QueuedEntityPlacerConfig withEntitySelectorConfig(@NonNull EntitySelectorConfig entitySelectorConfig) {
        this.setEntitySelectorConfig(entitySelectorConfig);
        return this;
    }

    public @NonNull QueuedEntityPlacerConfig withMoveSelectorConfigList(@NonNull List<@NonNull MoveSelectorConfig> moveSelectorConfigList) {
        this.setMoveSelectorConfigList(moveSelectorConfigList);
        return this;
    }

    public @NonNull QueuedEntityPlacerConfig withMoveSelectorConfigs(MoveSelectorConfig ... moveSelectorConfigs) {
        return this.withMoveSelectorConfigList(Arrays.asList(moveSelectorConfigs));
    }

    @Override
    public @NonNull QueuedEntityPlacerConfig inherit(@NonNull QueuedEntityPlacerConfig inheritedConfig) {
        this.entitySelectorConfig = ConfigUtils.inheritConfig(this.entitySelectorConfig, inheritedConfig.getEntitySelectorConfig());
        this.moveSelectorConfigList = ConfigUtils.inheritMergeableListConfig(this.moveSelectorConfigList, inheritedConfig.getMoveSelectorConfigList());
        return this;
    }

    @Override
    public @NonNull QueuedEntityPlacerConfig copyConfig() {
        return new QueuedEntityPlacerConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(@NonNull Consumer<Class<?>> classVisitor) {
        if (this.entitySelectorConfig != null) {
            this.entitySelectorConfig.visitReferencedClasses(classVisitor);
        }
        if (this.moveSelectorConfigList != null) {
            this.moveSelectorConfigList.forEach(ms -> ms.visitReferencedClasses(classVisitor));
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.entitySelectorConfig) + ", " + String.valueOf(this.moveSelectorConfigList) + ")";
    }
}

