/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.solver;

import jakarta.xml.bind.annotation.XmlEnum;

@XmlEnum
public enum EnvironmentMode {
    TRACKED_FULL_ASSERT(true),
    FULL_ASSERT(true),
    NON_INTRUSIVE_FULL_ASSERT(true),
    FAST_ASSERT(true),
    STEP_ASSERT(true),
    PHASE_ASSERT(true),
    REPRODUCIBLE(false),
    NO_ASSERT(false),
    NON_REPRODUCIBLE(false);

    private final boolean asserted;

    private EnvironmentMode(boolean asserted) {
        this.asserted = asserted;
    }

    public boolean isStepAssertOrMore() {
        if (!this.isAsserted()) {
            return false;
        }
        return this != PHASE_ASSERT;
    }

    public boolean isAsserted() {
        return this.asserted;
    }

    public boolean isFullyAsserted() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case TRACKED_FULL_ASSERT, FULL_ASSERT, NON_INTRUSIVE_FULL_ASSERT -> true;
            case STEP_ASSERT, FAST_ASSERT, PHASE_ASSERT, REPRODUCIBLE, NO_ASSERT, NON_REPRODUCIBLE -> false;
        };
    }

    @Deprecated(forRemoval=true, since="1.20.0")
    public boolean isNonIntrusiveFullAsserted() {
        return this.isFullyAsserted();
    }

    public boolean isIntrusivelyAsserted() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case TRACKED_FULL_ASSERT, FULL_ASSERT, STEP_ASSERT, FAST_ASSERT -> true;
            case NON_INTRUSIVE_FULL_ASSERT, PHASE_ASSERT, REPRODUCIBLE, NO_ASSERT, NON_REPRODUCIBLE -> false;
        };
    }

    @Deprecated(forRemoval=true, since="1.20.0")
    public boolean isIntrusiveFastAsserted() {
        return this.isIntrusivelyAsserted();
    }

    public boolean isReproducible() {
        return this != NON_REPRODUCIBLE;
    }

    public boolean isTracking() {
        return this == TRACKED_FULL_ASSERT;
    }
}

