/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.solver.termination;

import ai.timefold.solver.core.config.AbstractConfig;
import ai.timefold.solver.core.config.solver.termination.TerminationConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.io.jaxb.adapter.JaxbDurationAdapter;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.Duration;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@XmlType(propOrder={"slidingWindowDuration", "slidingWindowMilliseconds", "slidingWindowSeconds", "slidingWindowMinutes", "slidingWindowHours", "slidingWindowDays", "minimumImprovementRatio"})
public class DiminishedReturnsTerminationConfig
extends AbstractConfig<DiminishedReturnsTerminationConfig> {
    @XmlJavaTypeAdapter(value=JaxbDurationAdapter.class)
    private Duration slidingWindowDuration = null;
    private Long slidingWindowMilliseconds = null;
    private Long slidingWindowSeconds = null;
    private Long slidingWindowMinutes = null;
    private Long slidingWindowHours = null;
    private Long slidingWindowDays = null;
    private Double minimumImprovementRatio = null;

    public @Nullable Duration getSlidingWindowDuration() {
        return this.slidingWindowDuration;
    }

    public void setSlidingWindowDuration(@Nullable Duration slidingWindowDuration) {
        this.slidingWindowDuration = slidingWindowDuration;
    }

    public @Nullable Long getSlidingWindowMilliseconds() {
        return this.slidingWindowMilliseconds;
    }

    public void setSlidingWindowMilliseconds(@Nullable Long slidingWindowMilliseconds) {
        this.slidingWindowMilliseconds = slidingWindowMilliseconds;
    }

    public @Nullable Long getSlidingWindowSeconds() {
        return this.slidingWindowSeconds;
    }

    public void setSlidingWindowSeconds(@Nullable Long slidingWindowSeconds) {
        this.slidingWindowSeconds = slidingWindowSeconds;
    }

    public @Nullable Long getSlidingWindowMinutes() {
        return this.slidingWindowMinutes;
    }

    public void setSlidingWindowMinutes(@Nullable Long slidingWindowMinutes) {
        this.slidingWindowMinutes = slidingWindowMinutes;
    }

    public @Nullable Long getSlidingWindowHours() {
        return this.slidingWindowHours;
    }

    public void setSlidingWindowHours(@Nullable Long slidingWindowHours) {
        this.slidingWindowHours = slidingWindowHours;
    }

    public @Nullable Long getSlidingWindowDays() {
        return this.slidingWindowDays;
    }

    public void setSlidingWindowDays(@Nullable Long slidingWindowDays) {
        this.slidingWindowDays = slidingWindowDays;
    }

    public @Nullable Double getMinimumImprovementRatio() {
        return this.minimumImprovementRatio;
    }

    public void setMinimumImprovementRatio(@Nullable Double minimumImprovementRatio) {
        this.minimumImprovementRatio = minimumImprovementRatio;
    }

    public @NonNull DiminishedReturnsTerminationConfig withSlidingWindowDuration(@NonNull Duration slidingWindowDuration) {
        this.slidingWindowDuration = slidingWindowDuration;
        return this;
    }

    public @NonNull DiminishedReturnsTerminationConfig withSlidingWindowMilliseconds(@NonNull Long slidingWindowMilliseconds) {
        this.slidingWindowMilliseconds = slidingWindowMilliseconds;
        return this;
    }

    public @NonNull DiminishedReturnsTerminationConfig withSlidingWindowSeconds(@NonNull Long slidingWindowSeconds) {
        this.slidingWindowSeconds = slidingWindowSeconds;
        return this;
    }

    public @NonNull DiminishedReturnsTerminationConfig withSlidingWindowMinutes(@NonNull Long slidingWindowMinutes) {
        this.slidingWindowMinutes = slidingWindowMinutes;
        return this;
    }

    public @NonNull DiminishedReturnsTerminationConfig withSlidingWindowHours(@NonNull Long slidingWindowHours) {
        this.slidingWindowHours = slidingWindowHours;
        return this;
    }

    public @NonNull DiminishedReturnsTerminationConfig withSlidingWindowDays(@NonNull Long slidingWindowDays) {
        this.slidingWindowDays = slidingWindowDays;
        return this;
    }

    public @NonNull DiminishedReturnsTerminationConfig withMinimumImprovementRatio(@NonNull Double minimumImprovementRatio) {
        this.minimumImprovementRatio = minimumImprovementRatio;
        return this;
    }

    @Override
    public @NonNull DiminishedReturnsTerminationConfig inherit(@NonNull DiminishedReturnsTerminationConfig inheritedConfig) {
        if (!this.slidingWindowIsSet()) {
            this.inheritSlidingWindow(inheritedConfig);
        }
        this.minimumImprovementRatio = ConfigUtils.inheritOverwritableProperty(this.minimumImprovementRatio, inheritedConfig.getMinimumImprovementRatio());
        return this;
    }

    private void inheritSlidingWindow(@NonNull DiminishedReturnsTerminationConfig parent) {
        this.slidingWindowDuration = ConfigUtils.inheritOverwritableProperty(this.slidingWindowDuration, parent.getSlidingWindowDuration());
        this.slidingWindowMilliseconds = ConfigUtils.inheritOverwritableProperty(this.slidingWindowMilliseconds, parent.getSlidingWindowMilliseconds());
        this.slidingWindowSeconds = ConfigUtils.inheritOverwritableProperty(this.slidingWindowSeconds, parent.getSlidingWindowSeconds());
        this.slidingWindowMinutes = ConfigUtils.inheritOverwritableProperty(this.slidingWindowMinutes, parent.getSlidingWindowMinutes());
        this.slidingWindowHours = ConfigUtils.inheritOverwritableProperty(this.slidingWindowHours, parent.getSlidingWindowHours());
        this.slidingWindowDays = ConfigUtils.inheritOverwritableProperty(this.slidingWindowDays, parent.getSlidingWindowDays());
    }

    @Override
    public @NonNull DiminishedReturnsTerminationConfig copyConfig() {
        return new DiminishedReturnsTerminationConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(@NonNull Consumer<Class<?>> classVisitor) {
    }

    public boolean slidingWindowIsSet() {
        return this.slidingWindowDuration != null || this.slidingWindowMilliseconds != null || this.slidingWindowSeconds != null || this.slidingWindowMinutes != null || this.slidingWindowHours != null || this.slidingWindowDays != null;
    }

    public @Nullable Long calculateSlidingWindowMilliseconds() {
        if (this.slidingWindowMilliseconds == null && this.slidingWindowSeconds == null && this.slidingWindowMinutes == null && this.slidingWindowHours == null && this.slidingWindowDays == null) {
            if (this.slidingWindowDuration != null) {
                if (this.slidingWindowDuration.getNano() % 1000 != 0) {
                    throw new IllegalArgumentException("The termination slidingWindowDuration (" + String.valueOf(this.slidingWindowDuration) + ") cannot use nanoseconds.");
                }
                return this.slidingWindowDuration.toMillis();
            }
            return null;
        }
        if (this.slidingWindowDuration != null) {
            throw new IllegalArgumentException("The termination slidingWindowDuration (" + String.valueOf(this.slidingWindowDuration) + ") cannot be combined with slidingWindowMilliseconds (" + this.slidingWindowMilliseconds + "), slidingWindowSeconds (" + this.slidingWindowSeconds + "), slidingWindowMinutes (" + this.slidingWindowMinutes + "), slidingWindowHours (" + this.slidingWindowHours + "),) or slidingWindowDays (" + this.slidingWindowDays + ").");
        }
        long slidingWindowMillis = 0L + TerminationConfig.requireNonNegative(this.slidingWindowMilliseconds, "slidingWindowMilliseconds") + TerminationConfig.requireNonNegative(this.slidingWindowSeconds, "slidingWindowSeconds") * 1000L + TerminationConfig.requireNonNegative(this.slidingWindowMinutes, "slidingWindowMinutes") * 60000L + TerminationConfig.requireNonNegative(this.slidingWindowHours, "slidingWindowHours") * 3600000L + TerminationConfig.requireNonNegative(this.slidingWindowDays, "slidingWindowDays") * 86400000L;
        return slidingWindowMillis;
    }
}

