/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common;

import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.bavet.common.AbstractNode;
import ai.timefold.solver.core.impl.bavet.common.DynamicPropagationQueue;
import ai.timefold.solver.core.impl.bavet.common.Group;
import ai.timefold.solver.core.impl.bavet.common.Propagator;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleState;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class AbstractGroupNode<InTuple_ extends AbstractTuple, OutTuple_ extends AbstractTuple, GroupKey_, ResultContainer_, Result_>
extends AbstractNode
implements TupleLifecycle<InTuple_> {
    private final int groupStoreIndex;
    private final int undoStoreIndex;
    private final Function<InTuple_, GroupKey_> groupKeyFunction;
    private final Supplier<ResultContainer_> supplier;
    private final Function<ResultContainer_, Result_> finisher;
    private final boolean hasMultipleGroups;
    private final boolean hasCollector;
    private final Map<Object, Group<OutTuple_, ResultContainer_>> groupMap;
    private Group<OutTuple_, ResultContainer_> singletonGroup;
    private final DynamicPropagationQueue<OutTuple_, Group<OutTuple_, ResultContainer_>> propagationQueue;
    private final boolean useAssertingGroupKey;

    protected AbstractGroupNode(int groupStoreIndex, int undoStoreIndex, Function<InTuple_, GroupKey_> groupKeyFunction, Supplier<ResultContainer_> supplier, Function<ResultContainer_, Result_> finisher, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, EnvironmentMode environmentMode) {
        this.groupStoreIndex = groupStoreIndex;
        this.undoStoreIndex = undoStoreIndex;
        this.groupKeyFunction = groupKeyFunction;
        this.supplier = supplier;
        this.finisher = finisher;
        this.hasMultipleGroups = groupKeyFunction != null;
        this.hasCollector = supplier != null;
        this.groupMap = this.hasMultipleGroups ? new HashMap() : null;
        this.propagationQueue = this.hasCollector ? new DynamicPropagationQueue<OutTuple_, Group>(nextNodesTupleLifecycle, group -> {
            Object outTuple = group.getTuple();
            TupleState state = ((AbstractTuple)outTuple).state;
            if (state == TupleState.CREATING || state == TupleState.UPDATING) {
                this.updateOutTupleToFinisher(outTuple, group.getResultContainer());
            }
        }) : new DynamicPropagationQueue(nextNodesTupleLifecycle);
        this.useAssertingGroupKey = environmentMode.isStepAssertOrMore();
    }

    protected AbstractGroupNode(int groupStoreIndex, Function<InTuple_, GroupKey_> groupKeyFunction, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, EnvironmentMode environmentMode) {
        this(groupStoreIndex, -1, groupKeyFunction, null, null, nextNodesTupleLifecycle, environmentMode);
    }

    @Override
    public final void insert(InTuple_ tuple) {
        if (((AbstractTuple)tuple).getStore(this.groupStoreIndex) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + String.valueOf(tuple) + ") was already added in the tupleStore.");
        }
        GroupKey_ userSuppliedKey = this.hasMultipleGroups ? (GroupKey_)this.groupKeyFunction.apply(tuple) : null;
        this.createTuple(tuple, userSuppliedKey);
    }

    private void createTuple(InTuple_ tuple, GroupKey_ userSuppliedKey) {
        Group<OutTuple_, ResultContainer_> newGroup = this.getOrCreateGroup(userSuppliedKey);
        OutTuple_ outTuple = this.accumulate(tuple, newGroup);
        switch (((AbstractTuple)outTuple).state) {
            case CREATING: 
            case UPDATING: {
                break;
            }
            case OK: 
            case DYING: {
                this.propagationQueue.update(newGroup);
                break;
            }
            case ABORTING: {
                this.propagationQueue.insert(newGroup);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The group (" + String.valueOf(newGroup) + ") in node (" + String.valueOf(this) + ") is in an unexpected state (" + String.valueOf((Object)((AbstractTuple)outTuple).state) + ").");
            }
        }
    }

    private OutTuple_ accumulate(InTuple_ tuple, Group<OutTuple_, ResultContainer_> group) {
        if (this.hasCollector) {
            Runnable undoAccumulator = this.accumulate(group.getResultContainer(), tuple);
            ((AbstractTuple)tuple).setStore(this.undoStoreIndex, undoAccumulator);
        }
        ((AbstractTuple)tuple).setStore(this.groupStoreIndex, group);
        return group.getTuple();
    }

    private Group<OutTuple_, ResultContainer_> getOrCreateGroup(GroupKey_ userSuppliedKey) {
        Object groupMapKey;
        Object object = groupMapKey = this.useAssertingGroupKey ? new AssertingGroupKey<GroupKey_>(userSuppliedKey) : userSuppliedKey;
        if (this.hasMultipleGroups) {
            Group<OutTuple_, ResultContainer_> group = this.groupMap.get(groupMapKey);
            if (group == null) {
                group = this.createGroupWithGroupKey(groupMapKey);
                this.groupMap.put(groupMapKey, group);
            } else {
                ++group.parentCount;
            }
            return group;
        }
        if (this.singletonGroup == null) {
            this.singletonGroup = this.createGroupWithoutGroupKey();
        } else {
            ++this.singletonGroup.parentCount;
        }
        return this.singletonGroup;
    }

    private Group<OutTuple_, ResultContainer_> createGroupWithGroupKey(Object groupMapKey) {
        GroupKey_ userSuppliedKey = this.extractUserSuppliedKey(groupMapKey);
        OutTuple_ outTuple = this.createOutTuple(userSuppliedKey);
        Group group = this.hasCollector ? Group.create(groupMapKey, this.supplier.get(), outTuple) : Group.createWithoutAccumulate(groupMapKey, outTuple);
        this.propagationQueue.insert(group);
        return group;
    }

    private Group<OutTuple_, ResultContainer_> createGroupWithoutGroupKey() {
        OutTuple_ outTuple = this.createOutTuple(null);
        if (!this.hasCollector) {
            throw new IllegalStateException("Impossible state: The node (" + String.valueOf(this) + ") has no collector, but it is still trying to create a group without a group key.");
        }
        Group<OutTuple_, ResultContainer_> group = Group.createWithoutGroupKey(this.supplier.get(), outTuple);
        this.propagationQueue.insert(group);
        return group;
    }

    private GroupKey_ extractUserSuppliedKey(Object groupMapKey) {
        return (GroupKey_)(this.useAssertingGroupKey ? ((AssertingGroupKey)groupMapKey).key() : groupMapKey);
    }

    @Override
    public final void update(InTuple_ tuple) {
        GroupKey_ newUserSuppliedGroupKey;
        Group oldGroup = (Group)((AbstractTuple)tuple).getStore(this.groupStoreIndex);
        if (oldGroup == null) {
            this.insert(tuple);
            return;
        }
        if (this.hasCollector) {
            Runnable undoAccumulator = (Runnable)((AbstractTuple)tuple).getStore(this.undoStoreIndex);
            undoAccumulator.run();
        }
        Object oldUserSuppliedGroupKey = this.hasMultipleGroups ? this.extractUserSuppliedKey(oldGroup.getGroupKey()) : null;
        GroupKey_ GroupKey_ = newUserSuppliedGroupKey = this.hasMultipleGroups ? (GroupKey_)this.groupKeyFunction.apply(tuple) : null;
        if (Objects.equals(newUserSuppliedGroupKey, oldUserSuppliedGroupKey)) {
            OutTuple_ outTuple = this.accumulate(tuple, oldGroup);
            switch (((AbstractTuple)outTuple).state) {
                case CREATING: 
                case UPDATING: {
                    break;
                }
                case OK: {
                    this.propagationQueue.update(oldGroup);
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible state: The group (" + String.valueOf(oldGroup) + ") in node (" + String.valueOf(this) + ") is in an unexpected state (" + String.valueOf((Object)((AbstractTuple)outTuple).state) + ").");
                }
            }
        } else {
            this.killTuple(oldGroup);
            this.createTuple(tuple, newUserSuppliedGroupKey);
        }
    }

    private void killTuple(Group<OutTuple_, ResultContainer_> group) {
        Object groupKey;
        Group<OutTuple_, ResultContainer_> oldGroup;
        int newParentCount;
        boolean killGroup;
        boolean bl = killGroup = (newParentCount = --group.parentCount) == 0;
        if (killGroup && (oldGroup = this.removeGroup(groupKey = this.hasMultipleGroups ? group.getGroupKey() : null)) == null) {
            throw new IllegalStateException("Impossible state: the group for the groupKey (" + String.valueOf(groupKey) + ") doesn't exist in the groupMap.\nMaybe groupKey hashcode changed while it shouldn't have?");
        }
        OutTuple_ outTuple = group.getTuple();
        switch (((AbstractTuple)outTuple).state) {
            case CREATING: {
                if (!killGroup) break;
                this.propagationQueue.retract(group, TupleState.ABORTING);
                break;
            }
            case UPDATING: {
                if (!killGroup) break;
                this.propagationQueue.retract(group, TupleState.DYING);
                break;
            }
            case OK: {
                if (killGroup) {
                    this.propagationQueue.retract(group, TupleState.DYING);
                    break;
                }
                this.propagationQueue.update(group);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The group (" + String.valueOf(group) + ") in node (" + String.valueOf(this) + ") is in an unexpected state (" + String.valueOf((Object)((AbstractTuple)outTuple).state) + ").");
            }
        }
    }

    private Group<OutTuple_, ResultContainer_> removeGroup(Object groupKey) {
        if (this.hasMultipleGroups) {
            return this.groupMap.remove(groupKey);
        }
        Group<OutTuple_, ResultContainer_> oldGroup = this.singletonGroup;
        this.singletonGroup = null;
        return oldGroup;
    }

    @Override
    public final void retract(InTuple_ tuple) {
        Group group = (Group)((AbstractTuple)tuple).removeStore(this.groupStoreIndex);
        if (group == null) {
            return;
        }
        if (this.hasCollector) {
            Runnable undoAccumulator = (Runnable)((AbstractTuple)tuple).removeStore(this.undoStoreIndex);
            undoAccumulator.run();
        }
        this.killTuple(group);
    }

    protected abstract Runnable accumulate(ResultContainer_ var1, InTuple_ var2);

    @Override
    public Propagator getPropagator() {
        return this.propagationQueue;
    }

    protected abstract OutTuple_ createOutTuple(GroupKey_ var1);

    private void updateOutTupleToFinisher(OutTuple_ outTuple, ResultContainer_ resultContainer) {
        this.updateOutTupleToResult(outTuple, this.finisher.apply(resultContainer));
    }

    protected abstract void updateOutTupleToResult(OutTuple_ var1, Result_ var2);

    private record AssertingGroupKey<GroupKey_>(GroupKey_ key, int initialHashCode) {
        private final GroupKey_ key;

        public AssertingGroupKey(GroupKey_ key) {
            this(key, key == null ? 0 : key.hashCode());
        }

        public GroupKey_ key() {
            if (this.key != null && this.key.hashCode() != this.initialHashCode) {
                throw new IllegalStateException("hashCode of object (%s) of class (%s) has changed while it was being used as a group key.\nGroup key hashCode must consistently return the same integer, as required by the general hashCode contract.".formatted(this.key, this.key.getClass().getName()));
            }
            return this.key;
        }
    }
}

