/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common;

import ai.timefold.solver.core.impl.bavet.NodeNetwork;
import ai.timefold.solver.core.impl.bavet.common.AbstractNode;
import ai.timefold.solver.core.impl.bavet.common.AbstractTwoInputNode;
import ai.timefold.solver.core.impl.bavet.common.BavetStream;
import ai.timefold.solver.core.impl.bavet.common.BavetStreamBinaryOperation;
import ai.timefold.solver.core.impl.bavet.common.Propagator;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.LeftTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.RightTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.uni.AbstractForEachUniNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public abstract class AbstractNodeBuildHelper<Stream_ extends BavetStream> {
    private final Set<Stream_> activeStreamSet;
    private final Map<AbstractNode, Stream_> nodeCreatorMap;
    private final Map<Stream_, TupleLifecycle<? extends AbstractTuple>> tupleLifecycleMap;
    private final Map<Stream_, Integer> storeIndexMap;
    private List<AbstractNode> reversedNodeList;

    protected AbstractNodeBuildHelper(Set<Stream_> activeStreamSet) {
        this.activeStreamSet = activeStreamSet;
        int activeStreamSetSize = activeStreamSet.size();
        this.nodeCreatorMap = new HashMap<AbstractNode, Stream_>(Math.max(16, activeStreamSetSize));
        this.tupleLifecycleMap = new HashMap<Stream_, TupleLifecycle<? extends AbstractTuple>>(Math.max(16, activeStreamSetSize));
        this.storeIndexMap = new HashMap<Stream_, Integer>(Math.max(16, activeStreamSetSize / 2));
        this.reversedNodeList = new ArrayList<AbstractNode>(activeStreamSetSize);
    }

    public boolean isStreamActive(Stream_ stream) {
        return this.activeStreamSet.contains(stream);
    }

    public void addNode(AbstractNode node, Stream_ creator) {
        this.addNode(node, creator, creator);
    }

    public void addNode(AbstractNode node, Stream_ creator, Stream_ parent) {
        this.reversedNodeList.add(node);
        this.nodeCreatorMap.put(node, creator);
        if (!(node instanceof AbstractForEachUniNode)) {
            if (parent == null) {
                throw new IllegalStateException("Impossible state: The node (%s) has no parent (%s).".formatted(node, parent));
            }
            this.putInsertUpdateRetract(parent, (TupleLifecycle)((Object)node));
        }
    }

    public void addNode(AbstractNode node, Stream_ creator, Stream_ leftParent, Stream_ rightParent) {
        this.reversedNodeList.add(node);
        this.nodeCreatorMap.put(node, creator);
        this.putInsertUpdateRetract(leftParent, TupleLifecycle.ofLeft((LeftTupleLifecycle)((Object)node)));
        this.putInsertUpdateRetract(rightParent, TupleLifecycle.ofRight((RightTupleLifecycle)((Object)node)));
    }

    public <Tuple_ extends AbstractTuple> void putInsertUpdateRetract(Stream_ stream, TupleLifecycle<Tuple_> tupleLifecycle) {
        this.tupleLifecycleMap.put(stream, tupleLifecycle);
    }

    public <Tuple_ extends AbstractTuple> void putInsertUpdateRetract(Stream_ stream, List<? extends Stream_> childStreamList, UnaryOperator<TupleLifecycle<Tuple_>> tupleLifecycleFunction) {
        TupleLifecycle<Tuple_> tupleLifecycle = this.getAggregatedTupleLifecycle(childStreamList);
        this.putInsertUpdateRetract(stream, (TupleLifecycle)tupleLifecycleFunction.apply(tupleLifecycle));
    }

    public <Tuple_ extends AbstractTuple> TupleLifecycle<Tuple_> getAggregatedTupleLifecycle(List<? extends Stream_> streamList) {
        TupleLifecycle[] tupleLifecycles = (TupleLifecycle[])streamList.stream().filter(this::isStreamActive).map(s -> AbstractNodeBuildHelper.getTupleLifecycle(s, this.tupleLifecycleMap)).toArray(TupleLifecycle[]::new);
        return switch (tupleLifecycles.length) {
            case 0 -> throw new IllegalStateException("Impossible state: None of the streamList (%s) are active.".formatted(streamList));
            case 1 -> tupleLifecycles[0];
            default -> TupleLifecycle.aggregate(tupleLifecycles);
        };
    }

    private static <Stream_, Tuple_ extends AbstractTuple> TupleLifecycle<Tuple_> getTupleLifecycle(Stream_ stream, Map<Stream_, TupleLifecycle<? extends AbstractTuple>> tupleLifecycleMap) {
        TupleLifecycle<? extends AbstractTuple> tupleLifecycle = tupleLifecycleMap.get(stream);
        if (tupleLifecycle == null) {
            throw new IllegalStateException("Impossible state: the stream (%s) hasn't built a node yet.".formatted(stream));
        }
        return tupleLifecycle;
    }

    public int reserveTupleStoreIndex(Stream_ tupleSourceStream) {
        return this.storeIndexMap.compute(tupleSourceStream, (k, index) -> {
            if (index == null) {
                return 0;
            }
            if (index < 0) {
                throw new IllegalStateException("Impossible state: the tupleSourceStream (%s) is reserving a store after it has been extracted.".formatted(tupleSourceStream));
            }
            return index + 1;
        });
    }

    public int extractTupleStoreSize(Stream_ tupleSourceStream) {
        Integer lastIndex = this.storeIndexMap.put(tupleSourceStream, Integer.MIN_VALUE);
        return lastIndex == null ? 0 : lastIndex + 1;
    }

    public List<AbstractNode> destroyAndGetNodeList() {
        List<AbstractNode> nodeList = this.reversedNodeList;
        Collections.reverse(nodeList);
        this.reversedNodeList = null;
        return nodeList;
    }

    public Stream_ getNodeCreatingStream(AbstractNode node) {
        return (Stream_)((BavetStream)this.nodeCreatorMap.get(node));
    }

    public AbstractNode findParentNode(Stream_ childNodeCreator) {
        if (childNodeCreator == null) {
            throw new IllegalStateException("Impossible state: node-creating stream (%s) has no parent node.".formatted(childNodeCreator));
        }
        for (Map.Entry<AbstractNode, Stream_> entry : this.nodeCreatorMap.entrySet()) {
            if (entry.getValue() != childNodeCreator) continue;
            return entry.getKey();
        }
        return this.findParentNode((BavetStream)childNodeCreator.getParent());
    }

    public static NodeNetwork buildNodeNetwork(List<AbstractNode> nodeList, Map<Class<?>, List<AbstractForEachUniNode<?, ?>>> declaredClassToNodeMap) {
        TreeMap<Long, List> layerMap = new TreeMap<Long, List>();
        for (AbstractNode node : nodeList) {
            layerMap.computeIfAbsent(node.getLayerIndex(), k -> new ArrayList()).add(node.getPropagator());
        }
        int layerCount = layerMap.size();
        Propagator[][] layeredNodes = new Propagator[layerCount][];
        for (int i = 0; i < layerCount; ++i) {
            List layer = (List)layerMap.get(i);
            layeredNodes[i] = layer.toArray(new Propagator[0]);
        }
        return new NodeNetwork(declaredClassToNodeMap, layeredNodes);
    }

    public <BuildHelper_ extends AbstractNodeBuildHelper<Stream_>> List<AbstractNode> buildNodeList(Set<Stream_> streamSet, BuildHelper_ buildHelper, BiConsumer<Stream_, BuildHelper_> nodeBuilder, Consumer<AbstractNode> nodeProcessor) {
        ArrayList<Stream_> reversedStreamList = new ArrayList<Stream_>(streamSet);
        Collections.reverse(reversedStreamList);
        for (BavetStream constraintStream : reversedStreamList) {
            nodeBuilder.accept(constraintStream, buildHelper);
        }
        List<AbstractNode> nodeList = buildHelper.destroyAndGetNodeList();
        long nextNodeId = 0L;
        for (AbstractNode node : nodeList) {
            node.setId(nextNodeId++);
            node.setLayerIndex(AbstractNodeBuildHelper.determineLayerIndex(node, buildHelper));
            nodeProcessor.accept(node);
        }
        return nodeList;
    }

    private static <Stream_ extends BavetStream> long determineLayerIndex(AbstractNode node, AbstractNodeBuildHelper<Stream_> buildHelper) {
        if (node instanceof AbstractForEachUniNode) {
            return 0L;
        }
        if (node instanceof AbstractTwoInputNode) {
            AbstractTwoInputNode joinNode = (AbstractTwoInputNode)node;
            BavetStreamBinaryOperation nodeCreator = (BavetStreamBinaryOperation)buildHelper.getNodeCreatingStream(joinNode);
            Object leftParent = nodeCreator.getLeftParent();
            Object rightParent = nodeCreator.getRightParent();
            AbstractNode leftParentNode = buildHelper.findParentNode((BavetStream)leftParent);
            AbstractNode rightParentNode = buildHelper.findParentNode((BavetStream)rightParent);
            return Math.max(leftParentNode.getLayerIndex(), rightParentNode.getLayerIndex()) + 1L;
        }
        Stream_ nodeCreator = buildHelper.getNodeCreatingStream(node);
        AbstractNode parentNode = buildHelper.findParentNode((BavetStream)nodeCreator.getParent());
        return parentNode.getLayerIndex() + 1L;
    }
}

