/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common;

import ai.timefold.solver.core.impl.bavet.common.AbstractPropagationMetadataCarrier;
import ai.timefold.solver.core.impl.bavet.common.PropagationQueue;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleState;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.Consumer;

final class DynamicPropagationQueue<Tuple_ extends AbstractTuple, Carrier_ extends AbstractPropagationMetadataCarrier<Tuple_>>
implements PropagationQueue<Carrier_> {
    private static final int INITIAL_CAPACITY = 1000;
    private final Consumer<Carrier_> preprocessor;
    private final List<Carrier_> dirtyList;
    private final BitSet retractQueue;
    private final BitSet insertQueue;
    private final TupleLifecycle<Tuple_> nextNodesTupleLifecycle;

    private DynamicPropagationQueue(TupleLifecycle<Tuple_> nextNodesTupleLifecycle, Consumer<Carrier_> preprocessor, int size) {
        this.preprocessor = preprocessor;
        this.dirtyList = new ArrayList<Carrier_>(size);
        this.retractQueue = new BitSet(size);
        this.insertQueue = new BitSet(size);
        this.nextNodesTupleLifecycle = nextNodesTupleLifecycle;
    }

    public DynamicPropagationQueue(TupleLifecycle<Tuple_> nextNodesTupleLifecycle) {
        this(nextNodesTupleLifecycle, null, 1000);
    }

    public DynamicPropagationQueue(TupleLifecycle<Tuple_> nextNodesTupleLifecycle, Consumer<Carrier_> preprocessor) {
        this(nextNodesTupleLifecycle, preprocessor, 1000);
    }

    @Override
    public void insert(Carrier_ carrier) {
        int positionInDirtyList = ((AbstractPropagationMetadataCarrier)carrier).positionInDirtyList;
        if (positionInDirtyList < 0) {
            this.makeDirty(carrier, this.insertQueue);
        } else {
            switch (((AbstractPropagationMetadataCarrier)carrier).getState()) {
                case UPDATING: {
                    this.insertQueue.set(positionInDirtyList);
                    break;
                }
                case ABORTING: 
                case DYING: {
                    this.retractQueue.clear(positionInDirtyList);
                    this.insertQueue.set(positionInDirtyList);
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible state: Cannot insert (%s), already inserting.".formatted(carrier));
                }
            }
        }
        ((AbstractPropagationMetadataCarrier)carrier).setState(TupleState.CREATING);
    }

    private void makeDirty(Carrier_ carrier, BitSet queue) {
        this.dirtyList.add(carrier);
        int position = this.dirtyList.size() - 1;
        queue.set(position);
        ((AbstractPropagationMetadataCarrier)carrier).positionInDirtyList = position;
    }

    @Override
    public void update(Carrier_ carrier) {
        int positionInDirtyList = ((AbstractPropagationMetadataCarrier)carrier).positionInDirtyList;
        if (positionInDirtyList < 0) {
            this.dirtyList.add(carrier);
            ((AbstractPropagationMetadataCarrier)carrier).positionInDirtyList = this.dirtyList.size() - 1;
        } else {
            switch (((AbstractPropagationMetadataCarrier)carrier).getState()) {
                case CREATING: {
                    this.insertQueue.clear(positionInDirtyList);
                    break;
                }
                case ABORTING: 
                case DYING: {
                    this.retractQueue.clear(positionInDirtyList);
                    break;
                }
            }
        }
        ((AbstractPropagationMetadataCarrier)carrier).setState(TupleState.UPDATING);
    }

    @Override
    public void retract(Carrier_ carrier, TupleState state) {
        if (state.isActive() || state == TupleState.DEAD) {
            throw new IllegalArgumentException("Impossible state: The state (%s) is not a valid retract state.".formatted(new Object[]{state}));
        }
        int positionInDirtyList = ((AbstractPropagationMetadataCarrier)carrier).positionInDirtyList;
        if (positionInDirtyList < 0) {
            this.makeDirty(carrier, this.retractQueue);
        } else {
            switch (((AbstractPropagationMetadataCarrier)carrier).getState()) {
                case CREATING: {
                    this.insertQueue.clear(positionInDirtyList);
                    this.retractQueue.set(positionInDirtyList);
                    break;
                }
                case UPDATING: {
                    this.retractQueue.set(positionInDirtyList);
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible state: Cannot retract (%s), already retracting.".formatted(carrier));
                }
            }
        }
        ((AbstractPropagationMetadataCarrier)carrier).setState(state);
    }

    @Override
    public void propagateRetracts() {
        if (this.retractQueue.isEmpty()) {
            return;
        }
        int i = this.retractQueue.nextSetBit(0);
        while (i != -1) {
            AbstractPropagationMetadataCarrier carrier = (AbstractPropagationMetadataCarrier)this.dirtyList.get(i);
            TupleState state = carrier.getState();
            switch (state) {
                case DYING: {
                    DynamicPropagationQueue.clean(carrier, TupleState.DEAD);
                    this.nextNodesTupleLifecycle.retract(carrier.getTuple());
                    break;
                }
                case ABORTING: {
                    DynamicPropagationQueue.clean(carrier, TupleState.DEAD);
                }
            }
            i = this.retractQueue.nextSetBit(i + 1);
        }
    }

    private static void clean(AbstractPropagationMetadataCarrier<?> carrier, TupleState tupleState) {
        carrier.setState(tupleState);
        carrier.positionInDirtyList = -1;
    }

    @Override
    public void propagateUpdates() {
        int dirtyListSize = this.dirtyList.size();
        BitSet insertAndRetractQueue = DynamicPropagationQueue.buildInsertAndRetractQueue(this.insertQueue, this.retractQueue);
        if (insertAndRetractQueue == null) {
            for (int i = 0; i < dirtyListSize; ++i) {
                this.propagateInsertOrUpdate((AbstractPropagationMetadataCarrier)this.dirtyList.get(i), true);
            }
        } else {
            int i = insertAndRetractQueue.nextClearBit(0);
            while (i != -1 && i < dirtyListSize) {
                this.propagateInsertOrUpdate((AbstractPropagationMetadataCarrier)this.dirtyList.get(i), true);
                i = insertAndRetractQueue.nextClearBit(i + 1);
            }
        }
    }

    private static BitSet buildInsertAndRetractQueue(BitSet insertQueue, BitSet retractQueue) {
        boolean noInserts = insertQueue.isEmpty();
        boolean noRetracts = retractQueue.isEmpty();
        if (noInserts && noRetracts) {
            return null;
        }
        if (noInserts) {
            return retractQueue;
        }
        if (noRetracts) {
            return insertQueue;
        }
        BitSet updateQueue = new BitSet(Math.max(insertQueue.length(), retractQueue.length()));
        updateQueue.or(insertQueue);
        updateQueue.or(retractQueue);
        return updateQueue;
    }

    private void propagateInsertOrUpdate(Carrier_ carrier, boolean isUpdate) {
        if (this.preprocessor != null) {
            this.preprocessor.accept(carrier);
        }
        DynamicPropagationQueue.clean(carrier, TupleState.OK);
        if (isUpdate) {
            this.nextNodesTupleLifecycle.update(((AbstractPropagationMetadataCarrier)carrier).getTuple());
        } else {
            this.nextNodesTupleLifecycle.insert(((AbstractPropagationMetadataCarrier)carrier).getTuple());
        }
    }

    @Override
    public void propagateInserts() {
        if (!this.insertQueue.isEmpty()) {
            int i = this.insertQueue.nextSetBit(0);
            while (i != -1) {
                this.propagateInsertOrUpdate((AbstractPropagationMetadataCarrier)this.dirtyList.get(i), false);
                i = this.insertQueue.nextSetBit(i + 1);
            }
            this.insertQueue.clear();
        }
        this.retractQueue.clear();
        this.dirtyList.clear();
    }
}

