/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common.index;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.impl.bavet.bi.joiner.DefaultBiJoiner;
import ai.timefold.solver.core.impl.bavet.common.index.ComparisonIndexer;
import ai.timefold.solver.core.impl.bavet.common.index.EqualsIndexer;
import ai.timefold.solver.core.impl.bavet.common.index.IndexKeys;
import ai.timefold.solver.core.impl.bavet.common.index.Indexer;
import ai.timefold.solver.core.impl.bavet.common.index.IndexerKey;
import ai.timefold.solver.core.impl.bavet.common.index.NoneIndexer;
import ai.timefold.solver.core.impl.bavet.common.joiner.AbstractJoiner;
import ai.timefold.solver.core.impl.bavet.common.joiner.JoinerType;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.BiTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.QuadTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TriTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.bavet.penta.joiner.DefaultPentaJoiner;
import ai.timefold.solver.core.impl.bavet.quad.joiner.DefaultQuadJoiner;
import ai.timefold.solver.core.impl.bavet.tri.joiner.DefaultTriJoiner;
import ai.timefold.solver.core.impl.util.Pair;
import ai.timefold.solver.core.impl.util.Quadruple;
import ai.timefold.solver.core.impl.util.Triple;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;

public final class IndexerFactory<Right_> {
    private final AbstractJoiner<Right_> joiner;
    private final NavigableMap<Integer, JoinerType> joinerTypeMap;

    public IndexerFactory(AbstractJoiner<Right_> joiner) {
        this.joiner = joiner;
        int joinerCount = joiner.getJoinerCount();
        if (joinerCount < 2) {
            this.joinerTypeMap = null;
        } else {
            this.joinerTypeMap = new TreeMap<Integer, JoinerType>();
            for (int i = 1; i <= joinerCount; ++i) {
                JoinerType joinerType = i < joinerCount ? joiner.getJoinerType(i) : null;
                JoinerType previousJoinerType = joiner.getJoinerType(i - 1);
                if (joinerType == JoinerType.EQUAL && previousJoinerType == joinerType) continue;
                this.joinerTypeMap.put(i, previousJoinerType);
            }
        }
    }

    public boolean hasJoiners() {
        return this.joiner.getJoinerCount() > 0;
    }

    public <A> UniKeysExtractor<A> buildUniLeftKeysExtractor() {
        DefaultBiJoiner castJoiner = (DefaultBiJoiner)this.joiner;
        return this.buildUniKeysExtractor(castJoiner::getLeftMapping);
    }

    private <A> UniKeysExtractor<A> buildUniKeysExtractor(IntFunction<Function<A, Object>> mappingExtractor) {
        int joinerCount = this.joiner.getJoinerCount();
        if (joinerCount == 0) {
            return tuple -> IndexKeys.none();
        }
        if (joinerCount == 1) {
            return IndexerFactory.toKeysExtractor(mappingExtractor.apply(0));
        }
        int startIndexInclusive = 0;
        ArrayList<Function<A, Object>> keyFunctionList = new ArrayList<Function<A, Object>>();
        for (Map.Entry entry : this.joinerTypeMap.entrySet()) {
            Integer endIndexExclusive = (Integer)entry.getKey();
            int keyFunctionLength = endIndexExclusive - startIndexInclusive;
            Function<A, Object> keyFunction = switch (keyFunctionLength) {
                case 1 -> mappingExtractor.apply(startIndexInclusive);
                case 2 -> {
                    Function mapping1 = mappingExtractor.apply(startIndexInclusive);
                    Function mapping2 = mappingExtractor.apply(startIndexInclusive + 1);
                    yield a -> new Pair(mapping1.apply(a), mapping2.apply(a));
                }
                case 3 -> {
                    Function mapping1 = mappingExtractor.apply(startIndexInclusive);
                    Function mapping2 = mappingExtractor.apply(startIndexInclusive + 1);
                    Function mapping3 = mappingExtractor.apply(startIndexInclusive + 2);
                    yield a -> new Triple(mapping1.apply(a), mapping2.apply(a), mapping3.apply(a));
                }
                case 4 -> {
                    Function mapping1 = mappingExtractor.apply(startIndexInclusive);
                    Function mapping2 = mappingExtractor.apply(startIndexInclusive + 1);
                    Function mapping3 = mappingExtractor.apply(startIndexInclusive + 2);
                    Function mapping4 = mappingExtractor.apply(startIndexInclusive + 3);
                    yield a -> new Quadruple(mapping1.apply(a), mapping2.apply(a), mapping3.apply(a), mapping4.apply(a));
                }
                default -> {
                    Function[] mappings = new Function[joinerCount];
                    for (int i = 0; i < joinerCount; ++i) {
                        Function<A, Object> mapping;
                        mappings[i] = mapping = mappingExtractor.apply(i);
                    }
                    yield IndexerFactory.toCompositeKeyFunction(mappings);
                }
            };
            keyFunctionList.add(keyFunction);
            startIndexInclusive = endIndexExclusive;
        }
        return IndexerFactory.toKeysExtractor(keyFunctionList);
    }

    @SafeVarargs
    private static <A> Function<A, Object> toCompositeKeyFunction(Function<A, Object> ... mappings) {
        return a -> {
            int mappingCount = mappings.length;
            Object[] result = new Object[mappingCount];
            for (int i = 0; i < mappingCount; ++i) {
                result[i] = mappings[i].apply(a);
            }
            return new IndexerKey(result);
        };
    }

    private static <A> UniKeysExtractor<A> toKeysExtractor(Function<A, Object> keyFunction) {
        return tuple -> {
            Object a = tuple.factA;
            return IndexKeys.of(keyFunction.apply(a));
        };
    }

    private static <A> UniKeysExtractor<A> toKeysExtractor(List<Function<A, Object>> keyFunctionList) {
        int keyFunctionCount = keyFunctionList.size();
        return switch (keyFunctionCount) {
            case 1 -> IndexerFactory.toKeysExtractor(keyFunctionList.get(0));
            case 2 -> {
                Function keyFunction1 = keyFunctionList.get(0);
                Function keyFunction2 = keyFunctionList.get(1);
                yield tuple -> {
                    Object a = tuple.factA;
                    return IndexKeys.of(keyFunction1.apply(a), keyFunction2.apply(a));
                };
            }
            default -> tuple -> {
                Object a = tuple.factA;
                Object[] arr = new Object[keyFunctionCount];
                for (int i = 0; i < keyFunctionCount; ++i) {
                    arr[i] = ((Function)keyFunctionList.get(i)).apply(a);
                }
                return IndexKeys.ofMany(arr);
            };
        };
    }

    public <A, B> BiKeysExtractor<A, B> buildBiLeftKeysExtractor() {
        int joinerCount = this.joiner.getJoinerCount();
        DefaultTriJoiner castJoiner = (DefaultTriJoiner)this.joiner;
        if (joinerCount == 0) {
            return tuple -> IndexKeys.none();
        }
        if (joinerCount == 1) {
            return IndexerFactory.toKeysExtractor(castJoiner.getLeftMapping(0));
        }
        int startIndexInclusive = 0;
        ArrayList keyFunctionList = new ArrayList();
        for (Map.Entry entry : this.joinerTypeMap.entrySet()) {
            Integer endIndexExclusive = (Integer)entry.getKey();
            int keyFunctionLength = endIndexExclusive - startIndexInclusive;
            BiFunction keyFunction = switch (keyFunctionLength) {
                case 1 -> castJoiner.getLeftMapping(startIndexInclusive);
                case 2 -> {
                    BiFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                    BiFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                    yield (a, b) -> new Pair(mapping1.apply(a, b), mapping2.apply(a, b));
                }
                case 3 -> {
                    BiFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                    BiFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                    BiFunction mapping3 = castJoiner.getLeftMapping(startIndexInclusive + 2);
                    yield (a, b) -> new Triple(mapping1.apply(a, b), mapping2.apply(a, b), mapping3.apply(a, b));
                }
                case 4 -> {
                    BiFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                    BiFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                    BiFunction mapping3 = castJoiner.getLeftMapping(startIndexInclusive + 2);
                    BiFunction mapping4 = castJoiner.getLeftMapping(startIndexInclusive + 3);
                    yield (a, b) -> new Quadruple(mapping1.apply(a, b), mapping2.apply(a, b), mapping3.apply(a, b), mapping4.apply(a, b));
                }
                default -> {
                    BiFunction[] mappings = new BiFunction[joinerCount];
                    for (int i = 0; i < joinerCount; ++i) {
                        BiFunction mapping;
                        mappings[i] = mapping = castJoiner.getLeftMapping(i);
                    }
                    yield (a, b) -> {
                        int mappingCount = mappings.length;
                        Object[] result = new Object[mappingCount];
                        for (int i = 0; i < mappingCount; ++i) {
                            result[i] = mappings[i].apply(a, b);
                        }
                        return new IndexerKey(result);
                    };
                }
            };
            keyFunctionList.add(keyFunction);
            startIndexInclusive = endIndexExclusive;
        }
        int keyFunctionCount = keyFunctionList.size();
        return switch (keyFunctionCount) {
            case 1 -> IndexerFactory.toKeysExtractor((BiFunction)keyFunctionList.get(0));
            case 2 -> {
                BiFunction keyFunction1 = (BiFunction)keyFunctionList.get(0);
                BiFunction keyFunction2 = (BiFunction)keyFunctionList.get(1);
                yield tuple -> {
                    Object a = tuple.factA;
                    Object b = tuple.factB;
                    return IndexKeys.of(keyFunction1.apply(a, b), keyFunction2.apply(a, b));
                };
            }
            default -> tuple -> {
                Object a = tuple.factA;
                Object b = tuple.factB;
                Object[] arr = new Object[keyFunctionCount];
                for (int i = 0; i < keyFunctionCount; ++i) {
                    arr[i] = ((BiFunction)keyFunctionList.get(i)).apply(a, b);
                }
                return IndexKeys.ofMany(arr);
            };
        };
    }

    private static <A, B> BiKeysExtractor<A, B> toKeysExtractor(BiFunction<A, B, Object> keyFunction) {
        return tuple -> {
            Object a = tuple.factA;
            Object b = tuple.factB;
            return IndexKeys.of(keyFunction.apply(a, b));
        };
    }

    public <A, B, C> TriKeysExtractor<A, B, C> buildTriLeftKeysExtractor() {
        int joinerCount = this.joiner.getJoinerCount();
        DefaultQuadJoiner castJoiner = (DefaultQuadJoiner)this.joiner;
        if (joinerCount == 0) {
            return tuple -> IndexKeys.none();
        }
        if (joinerCount == 1) {
            return IndexerFactory.toKeysExtractor(castJoiner.getLeftMapping(0));
        }
        int startIndexInclusive = 0;
        ArrayList keyFunctionList = new ArrayList();
        for (Map.Entry entry : this.joinerTypeMap.entrySet()) {
            Integer endIndexExclusive = (Integer)entry.getKey();
            int keyFunctionLength = endIndexExclusive - startIndexInclusive;
            TriFunction keyFunction = switch (keyFunctionLength) {
                case 1 -> castJoiner.getLeftMapping(startIndexInclusive);
                case 2 -> {
                    TriFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                    TriFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                    yield (a, b, c) -> new Pair(mapping1.apply(a, b, c), mapping2.apply(a, b, c));
                }
                case 3 -> {
                    TriFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                    TriFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                    TriFunction mapping3 = castJoiner.getLeftMapping(startIndexInclusive + 2);
                    yield (a, b, c) -> new Triple(mapping1.apply(a, b, c), mapping2.apply(a, b, c), mapping3.apply(a, b, c));
                }
                case 4 -> {
                    TriFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                    TriFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                    TriFunction mapping3 = castJoiner.getLeftMapping(startIndexInclusive + 2);
                    TriFunction mapping4 = castJoiner.getLeftMapping(startIndexInclusive + 3);
                    yield (a, b, c) -> new Quadruple(mapping1.apply(a, b, c), mapping2.apply(a, b, c), mapping3.apply(a, b, c), mapping4.apply(a, b, c));
                }
                default -> {
                    TriFunction[] mappings = new TriFunction[joinerCount];
                    for (int i = 0; i < joinerCount; ++i) {
                        TriFunction mapping;
                        mappings[i] = mapping = castJoiner.getLeftMapping(i);
                    }
                    yield (a, b, c) -> {
                        int mappingCount = mappings.length;
                        Object[] result = new Object[mappingCount];
                        for (int i = 0; i < mappingCount; ++i) {
                            result[i] = mappings[i].apply(a, b, c);
                        }
                        return new IndexerKey(result);
                    };
                }
            };
            keyFunctionList.add(keyFunction);
            startIndexInclusive = endIndexExclusive;
        }
        int keyFunctionCount = keyFunctionList.size();
        return switch (keyFunctionCount) {
            case 1 -> IndexerFactory.toKeysExtractor((TriFunction)keyFunctionList.get(0));
            case 2 -> {
                TriFunction keyFunction1 = (TriFunction)keyFunctionList.get(0);
                TriFunction keyFunction2 = (TriFunction)keyFunctionList.get(1);
                yield tuple -> {
                    Object a = tuple.factA;
                    Object b = tuple.factB;
                    Object c = tuple.factC;
                    return IndexKeys.of(keyFunction1.apply(a, b, c), keyFunction2.apply(a, b, c));
                };
            }
            default -> tuple -> {
                Object a = tuple.factA;
                Object b = tuple.factB;
                Object c = tuple.factC;
                Object[] arr = new Object[keyFunctionCount];
                for (int i = 0; i < keyFunctionCount; ++i) {
                    arr[i] = ((TriFunction)keyFunctionList.get(i)).apply(a, b, c);
                }
                return IndexKeys.ofMany(arr);
            };
        };
    }

    private static <A, B, C> TriKeysExtractor<A, B, C> toKeysExtractor(TriFunction<A, B, C, Object> keyFunction) {
        return tuple -> {
            Object a = tuple.factA;
            Object b = tuple.factB;
            Object c = tuple.factC;
            return IndexKeys.of(keyFunction.apply(a, b, c));
        };
    }

    public <A, B, C, D> QuadKeysExtractor<A, B, C, D> buildQuadLeftKeysExtractor() {
        int joinerCount = this.joiner.getJoinerCount();
        DefaultPentaJoiner castJoiner = (DefaultPentaJoiner)this.joiner;
        if (joinerCount == 0) {
            return tuple -> IndexKeys.none();
        }
        if (joinerCount == 1) {
            return IndexerFactory.toKeysExtractor(castJoiner.getLeftMapping(0));
        }
        int startIndexInclusive = 0;
        ArrayList keyFunctionList = new ArrayList();
        for (Map.Entry entry : this.joinerTypeMap.entrySet()) {
            Integer endIndexExclusive = (Integer)entry.getKey();
            int keyFunctionLength = endIndexExclusive - startIndexInclusive;
            QuadFunction keyFunction = switch (keyFunctionLength) {
                case 1 -> castJoiner.getLeftMapping(startIndexInclusive);
                case 2 -> {
                    QuadFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                    QuadFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                    yield (a, b, c, d) -> new Pair(mapping1.apply(a, b, c, d), mapping2.apply(a, b, c, d));
                }
                case 3 -> {
                    QuadFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                    QuadFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                    QuadFunction mapping3 = castJoiner.getLeftMapping(startIndexInclusive + 2);
                    yield (a, b, c, d) -> new Triple(mapping1.apply(a, b, c, d), mapping2.apply(a, b, c, d), mapping3.apply(a, b, c, d));
                }
                case 4 -> {
                    QuadFunction mapping1 = castJoiner.getLeftMapping(startIndexInclusive);
                    QuadFunction mapping2 = castJoiner.getLeftMapping(startIndexInclusive + 1);
                    QuadFunction mapping3 = castJoiner.getLeftMapping(startIndexInclusive + 2);
                    QuadFunction mapping4 = castJoiner.getLeftMapping(startIndexInclusive + 3);
                    yield (a, b, c, d) -> new Quadruple(mapping1.apply(a, b, c, d), mapping2.apply(a, b, c, d), mapping3.apply(a, b, c, d), mapping4.apply(a, b, c, d));
                }
                default -> {
                    QuadFunction[] mappings = new QuadFunction[joinerCount];
                    for (int i = 0; i < joinerCount; ++i) {
                        QuadFunction mapping;
                        mappings[i] = mapping = castJoiner.getLeftMapping(i);
                    }
                    yield (a, b, c, d) -> {
                        int mappingCount = mappings.length;
                        Object[] result = new Object[mappingCount];
                        for (int i = 0; i < mappingCount; ++i) {
                            result[i] = mappings[i].apply(a, b, c, d);
                        }
                        return new IndexerKey(result);
                    };
                }
            };
            keyFunctionList.add(keyFunction);
            startIndexInclusive = endIndexExclusive;
        }
        int keyFunctionCount = keyFunctionList.size();
        return switch (keyFunctionList.size()) {
            case 1 -> IndexerFactory.toKeysExtractor((QuadFunction)keyFunctionList.get(0));
            case 2 -> {
                QuadFunction keyFunction1 = (QuadFunction)keyFunctionList.get(0);
                QuadFunction keyFunction2 = (QuadFunction)keyFunctionList.get(1);
                yield tuple -> {
                    Object a = tuple.factA;
                    Object b = tuple.factB;
                    Object c = tuple.factC;
                    Object d = tuple.factD;
                    return IndexKeys.of(keyFunction1.apply(a, b, c, d), keyFunction2.apply(a, b, c, d));
                };
            }
            default -> tuple -> {
                Object a = tuple.factA;
                Object b = tuple.factB;
                Object c = tuple.factC;
                Object d = tuple.factD;
                Object[] arr = new Object[keyFunctionCount];
                for (int i = 0; i < keyFunctionCount; ++i) {
                    arr[i] = ((QuadFunction)keyFunctionList.get(i)).apply(a, b, c, d);
                }
                return IndexKeys.ofMany(arr);
            };
        };
    }

    private static <A, B, C, D> QuadKeysExtractor<A, B, C, D> toKeysExtractor(QuadFunction<A, B, C, D, Object> keyFunction) {
        return tuple -> {
            Object a = tuple.factA;
            Object b = tuple.factB;
            Object c = tuple.factC;
            Object d = tuple.factD;
            return IndexKeys.of(keyFunction.apply(a, b, c, d));
        };
    }

    public UniKeysExtractor<Right_> buildRightKeysExtractor() {
        return this.buildUniKeysExtractor(this.joiner::getRightMapping);
    }

    public <T> Indexer<T> buildIndexer(boolean isLeftBridge) {
        Supplier<Indexer> noneIndexerSupplier;
        if (!this.hasJoiners()) {
            return new NoneIndexer();
        }
        if (this.joiner.getJoinerCount() == 1) {
            JoinerType joinerType = this.joiner.getJoinerType(0);
            if (joinerType == JoinerType.EQUAL) {
                return new EqualsIndexer();
            }
            return new ComparisonIndexer(isLeftBridge ? joinerType : joinerType.flip());
        }
        NavigableMap<Integer, JoinerType> descendingJoinerTypeMap = this.joinerTypeMap.descendingMap();
        Supplier<Indexer> downstreamIndexerSupplier = noneIndexerSupplier = NoneIndexer::new;
        int indexPropertyId = descendingJoinerTypeMap.size() - 1;
        for (Map.Entry entry : descendingJoinerTypeMap.entrySet()) {
            JoinerType joinerType = (JoinerType)((Object)entry.getValue());
            if (downstreamIndexerSupplier == noneIndexerSupplier && indexPropertyId == 0) {
                if (joinerType == JoinerType.EQUAL) {
                    downstreamIndexerSupplier = EqualsIndexer::new;
                } else {
                    JoinerType actualJoinerType = isLeftBridge ? joinerType : joinerType.flip();
                    downstreamIndexerSupplier = () -> new ComparisonIndexer(actualJoinerType);
                }
            } else {
                Supplier<Indexer> actualDownstreamIndexerSupplier = downstreamIndexerSupplier;
                int effectivelyFinalIndexPropertyId = indexPropertyId;
                if (joinerType == JoinerType.EQUAL) {
                    downstreamIndexerSupplier = () -> new EqualsIndexer(effectivelyFinalIndexPropertyId, actualDownstreamIndexerSupplier);
                } else {
                    JoinerType actualJoinerType = isLeftBridge ? joinerType : joinerType.flip();
                    downstreamIndexerSupplier = () -> new ComparisonIndexer(actualJoinerType, effectivelyFinalIndexPropertyId, actualDownstreamIndexerSupplier);
                }
            }
            --indexPropertyId;
        }
        return downstreamIndexerSupplier.get();
    }

    @FunctionalInterface
    public static interface UniKeysExtractor<A>
    extends KeysExtractor<UniTuple<A>> {
    }

    @FunctionalInterface
    public static interface BiKeysExtractor<A, B>
    extends KeysExtractor<BiTuple<A, B>> {
    }

    @FunctionalInterface
    public static interface TriKeysExtractor<A, B, C>
    extends KeysExtractor<TriTuple<A, B, C>> {
    }

    @FunctionalInterface
    public static interface QuadKeysExtractor<A, B, C, D>
    extends KeysExtractor<QuadTuple<A, B, C, D>> {
    }

    @FunctionalInterface
    public static interface KeysExtractor<Tuple_ extends AbstractTuple>
    extends Function<Tuple_, Object> {
    }
}

