/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.penta.joiner;

import ai.timefold.solver.core.api.function.PentaPredicate;
import ai.timefold.solver.core.api.score.stream.penta.PentaJoiner;
import ai.timefold.solver.core.impl.bavet.penta.joiner.DefaultPentaJoiner;
import ai.timefold.solver.core.impl.bavet.penta.joiner.FilteringPentaJoiner;
import java.util.ArrayList;
import java.util.List;

public final class PentaJoinerComber<A, B, C, D, E> {
    private final DefaultPentaJoiner<A, B, C, D, E> mergedJoiner;
    private final PentaPredicate<A, B, C, D, E> mergedFiltering;

    public static <A, B, C, D, E> PentaJoinerComber<A, B, C, D, E> comb(PentaJoiner<A, B, C, D, E>[] joiners) {
        ArrayList defaultJoinerList = new ArrayList(joiners.length);
        ArrayList filteringList = new ArrayList(joiners.length);
        int indexOfFirstFilter = -1;
        for (int i = 0; i < joiners.length; ++i) {
            PentaJoiner<A, B, C, D, E> joiner = joiners[i];
            if (joiner instanceof FilteringPentaJoiner) {
                indexOfFirstFilter = i;
                filteringList.add(((FilteringPentaJoiner)joiner).getFilter());
                continue;
            }
            if (joiner instanceof DefaultPentaJoiner) {
                if (indexOfFirstFilter >= 0) {
                    throw new IllegalStateException("Indexing joiner (" + String.valueOf(joiner) + ") must not follow a filtering joiner (" + String.valueOf(joiners[indexOfFirstFilter]) + ").\nMaybe reorder the joiners such that filtering() joiners are later in the parameter list.");
                }
                defaultJoinerList.add((DefaultPentaJoiner)joiner);
                continue;
            }
            throw new IllegalArgumentException("The joiner class (" + String.valueOf(joiner.getClass()) + ") is not supported.");
        }
        DefaultPentaJoiner mergedJoiner = DefaultPentaJoiner.merge(defaultJoinerList);
        PentaPredicate<A, B, C, D, E> mergedFiltering = PentaJoinerComber.mergeFiltering(filteringList);
        return new PentaJoinerComber(mergedJoiner, mergedFiltering);
    }

    private static <A, B, C, D, E> PentaPredicate<A, B, C, D, E> mergeFiltering(List<PentaPredicate<A, B, C, D, E>> filteringList) {
        if (filteringList.isEmpty()) {
            return null;
        }
        switch (filteringList.size()) {
            case 1: {
                return filteringList.get(0);
            }
            case 2: {
                return filteringList.get(0).and(filteringList.get(1));
            }
        }
        return (a, b, c, d, e) -> {
            for (PentaPredicate predicate : filteringList) {
                if (predicate.test(a, b, c, d, e)) continue;
                return false;
            }
            return true;
        };
    }

    public PentaJoinerComber(DefaultPentaJoiner<A, B, C, D, E> mergedJoiner, PentaPredicate<A, B, C, D, E> mergedFiltering) {
        this.mergedJoiner = mergedJoiner;
        this.mergedFiltering = mergedFiltering;
    }

    public DefaultPentaJoiner<A, B, C, D, E> getMergedJoiner() {
        return this.mergedJoiner;
    }

    public PentaPredicate<A, B, C, D, E> getMergedFiltering() {
        return this.mergedFiltering;
    }
}

