/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.quad;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.impl.bavet.common.AbstractMapNode;
import ai.timefold.solver.core.impl.bavet.common.tuple.QuadTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TriTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import java.util.Objects;

public final class MapQuadToTriNode<A, B, C, D, NewA, NewB, NewC>
extends AbstractMapNode<QuadTuple<A, B, C, D>, TriTuple<NewA, NewB, NewC>> {
    private final QuadFunction<A, B, C, D, NewA> mappingFunctionA;
    private final QuadFunction<A, B, C, D, NewB> mappingFunctionB;
    private final QuadFunction<A, B, C, D, NewC> mappingFunctionC;

    public MapQuadToTriNode(int mapStoreIndex, QuadFunction<A, B, C, D, NewA> mappingFunctionA, QuadFunction<A, B, C, D, NewB> mappingFunctionB, QuadFunction<A, B, C, D, NewC> mappingFunctionC, TupleLifecycle<TriTuple<NewA, NewB, NewC>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(mapStoreIndex, nextNodesTupleLifecycle, outputStoreSize);
        this.mappingFunctionA = Objects.requireNonNull(mappingFunctionA);
        this.mappingFunctionB = Objects.requireNonNull(mappingFunctionB);
        this.mappingFunctionC = Objects.requireNonNull(mappingFunctionC);
    }

    @Override
    protected TriTuple<NewA, NewB, NewC> map(QuadTuple<A, B, C, D> tuple) {
        Object factA = tuple.factA;
        Object factB = tuple.factB;
        Object factC = tuple.factC;
        Object factD = tuple.factD;
        return new TriTuple<NewA, NewB, NewC>(this.mappingFunctionA.apply(factA, factB, factC, factD), this.mappingFunctionB.apply(factA, factB, factC, factD), this.mappingFunctionC.apply(factA, factB, factC, factD), this.outputStoreSize);
    }

    @Override
    protected void remap(QuadTuple<A, B, C, D> inTuple, TriTuple<NewA, NewB, NewC> outTuple) {
        Object factA = inTuple.factA;
        Object factB = inTuple.factB;
        Object factC = inTuple.factC;
        Object factD = inTuple.factD;
        NewA newA = this.mappingFunctionA.apply(factA, factB, factC, factD);
        NewB newB = this.mappingFunctionB.apply(factA, factB, factC, factD);
        NewC newC = this.mappingFunctionC.apply(factA, factB, factC, factD);
        outTuple.factA = newA;
        outTuple.factB = newB;
        outTuple.factC = newC;
    }
}

