/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.tri;

import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.impl.bavet.common.AbstractMapNode;
import ai.timefold.solver.core.impl.bavet.common.tuple.TriTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import java.util.Objects;

public final class MapTriToTriNode<A, B, C, NewA, NewB, NewC>
extends AbstractMapNode<TriTuple<A, B, C>, TriTuple<NewA, NewB, NewC>> {
    private final TriFunction<A, B, C, NewA> mappingFunctionA;
    private final TriFunction<A, B, C, NewB> mappingFunctionB;
    private final TriFunction<A, B, C, NewC> mappingFunctionC;

    public MapTriToTriNode(int mapStoreIndex, TriFunction<A, B, C, NewA> mappingFunctionA, TriFunction<A, B, C, NewB> mappingFunctionB, TriFunction<A, B, C, NewC> mappingFunctionC, TupleLifecycle<TriTuple<NewA, NewB, NewC>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(mapStoreIndex, nextNodesTupleLifecycle, outputStoreSize);
        this.mappingFunctionA = Objects.requireNonNull(mappingFunctionA);
        this.mappingFunctionB = Objects.requireNonNull(mappingFunctionB);
        this.mappingFunctionC = Objects.requireNonNull(mappingFunctionC);
    }

    @Override
    protected TriTuple<NewA, NewB, NewC> map(TriTuple<A, B, C> tuple) {
        Object factA = tuple.factA;
        Object factB = tuple.factB;
        Object factC = tuple.factC;
        return new TriTuple<NewA, NewB, NewC>(this.mappingFunctionA.apply(factA, factB, factC), this.mappingFunctionB.apply(factA, factB, factC), this.mappingFunctionC.apply(factA, factB, factC), this.outputStoreSize);
    }

    @Override
    protected void remap(TriTuple<A, B, C> inTuple, TriTuple<NewA, NewB, NewC> outTuple) {
        Object factA = inTuple.factA;
        Object factB = inTuple.factB;
        Object factC = inTuple.factC;
        NewA newA = this.mappingFunctionA.apply(factA, factB, factC);
        NewB newB = this.mappingFunctionB.apply(factA, factB, factC);
        NewC newC = this.mappingFunctionC.apply(factA, factB, factC);
        outTuple.factA = newA;
        outTuple.factB = newB;
        outTuple.factC = newC;
    }
}

