/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.uni;

import ai.timefold.solver.core.impl.bavet.common.AbstractMapNode;
import ai.timefold.solver.core.impl.bavet.common.tuple.BiTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import java.util.Objects;
import java.util.function.Function;

public final class MapUniToBiNode<A, NewA, NewB>
extends AbstractMapNode<UniTuple<A>, BiTuple<NewA, NewB>> {
    private final Function<A, NewA> mappingFunctionA;
    private final Function<A, NewB> mappingFunctionB;

    public MapUniToBiNode(int mapStoreIndex, Function<A, NewA> mappingFunctionA, Function<A, NewB> mappingFunctionB, TupleLifecycle<BiTuple<NewA, NewB>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(mapStoreIndex, nextNodesTupleLifecycle, outputStoreSize);
        this.mappingFunctionA = Objects.requireNonNull(mappingFunctionA);
        this.mappingFunctionB = Objects.requireNonNull(mappingFunctionB);
    }

    @Override
    protected BiTuple<NewA, NewB> map(UniTuple<A> tuple) {
        Object factA = tuple.factA;
        return new BiTuple<NewA, NewB>(this.mappingFunctionA.apply(factA), this.mappingFunctionB.apply(factA), this.outputStoreSize);
    }

    @Override
    protected void remap(UniTuple<A> inTuple, BiTuple<NewA, NewB> outTuple) {
        Object factA = inTuple.factA;
        NewA newA = this.mappingFunctionA.apply(factA);
        NewB newB = this.mappingFunctionB.apply(factA);
        outTuple.factA = newA;
        outTuple.factB = newB;
    }
}

