/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.common.accessor.gizmo;

import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.AbstractGizmoMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.AbstractReadOnlyGizmoMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.AbstractReadWriteGizmoMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoClassLoader;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberDescriptor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberInfo;
import ai.timefold.solver.core.impl.util.MutableReference;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

public final class GizmoMemberAccessorImplementor {
    static final String GENERIC_TYPE_FIELD = "genericType";
    static final String ANNOTATED_ELEMENT_FIELD = "annotatedElement";

    public static void defineAccessorFor(String className, ClassOutput classOutput, GizmoMemberInfo memberInfo) {
        Class<? extends AbstractGizmoMemberAccessor> superClass = GizmoMemberAccessorImplementor.getCorrectSuperclass(memberInfo);
        try (ClassCreator classCreator = ClassCreator.builder().className(className).superClass(superClass).classOutput(classOutput).setFinal(true).build();){
            classCreator.getFieldCreator(GENERIC_TYPE_FIELD, Type.class).setModifiers(16);
            classCreator.getFieldCreator(ANNOTATED_ELEMENT_FIELD, AnnotatedElement.class).setModifiers(16);
            GizmoMemberAccessorImplementor.createConstructor(classCreator, memberInfo);
            GizmoMemberAccessorImplementor.createGetDeclaringClass(classCreator, memberInfo);
            GizmoMemberAccessorImplementor.createGetType(classCreator, memberInfo);
            GizmoMemberAccessorImplementor.createGetGenericType(classCreator);
            GizmoMemberAccessorImplementor.createGetName(classCreator, memberInfo);
            GizmoMemberAccessorImplementor.createExecuteGetter(classCreator, memberInfo);
            if (superClass == AbstractReadWriteGizmoMemberAccessor.class) {
                GizmoMemberAccessorImplementor.createExecuteSetter(classCreator, memberInfo);
            }
            GizmoMemberAccessorImplementor.createGetAnnotation(classCreator);
            GizmoMemberAccessorImplementor.createDeclaredAnnotationsByType(classCreator);
        }
    }

    private static Class<? extends AbstractGizmoMemberAccessor> getCorrectSuperclass(GizmoMemberInfo memberInfo) {
        AtomicBoolean supportsSetter = new AtomicBoolean();
        memberInfo.descriptor().whenIsMethod(method -> supportsSetter.set(memberInfo.descriptor().getSetter().isPresent()));
        memberInfo.descriptor().whenIsField(field -> supportsSetter.set(true));
        if (supportsSetter.get()) {
            return AbstractReadWriteGizmoMemberAccessor.class;
        }
        return AbstractReadOnlyGizmoMemberAccessor.class;
    }

    static MemberAccessor createAccessorFor(Member member, Class<? extends Annotation> annotationClass, boolean returnTypeRequired, GizmoClassLoader gizmoClassLoader) {
        String className = GizmoMemberAccessorFactory.getGeneratedClassName(member);
        if (gizmoClassLoader.hasBytecodeFor(className)) {
            return GizmoMemberAccessorImplementor.createInstance(className, gizmoClassLoader);
        }
        MutableReference<Object> classBytecodeHolder = new MutableReference<Object>(null);
        ClassOutput classOutput = (path, byteCode) -> classBytecodeHolder.setValue(byteCode);
        GizmoMemberInfo memberInfo = new GizmoMemberInfo(new GizmoMemberDescriptor(member), returnTypeRequired, annotationClass);
        GizmoMemberAccessorImplementor.defineAccessorFor(className, classOutput, memberInfo);
        byte[] classBytecode = classBytecodeHolder.getValue();
        gizmoClassLoader.storeBytecode(className, classBytecode);
        return GizmoMemberAccessorImplementor.createInstance(className, gizmoClassLoader);
    }

    private static MemberAccessor createInstance(String className, GizmoClassLoader gizmoClassLoader) {
        try {
            return (MemberAccessor)gizmoClassLoader.loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static MethodCreator getMethodCreator(ClassCreator classCreator, Class<?> returnType, String methodName, Class<?> ... parameters) {
        return classCreator.getMethodCreator(methodName, returnType, (Class[])parameters);
    }

    private static void createConstructor(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.ofConstructor((String)classCreator.getClassName(), (String[])new String[0]));
        ResultHandle thisObj = methodCreator.getThis();
        methodCreator.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)classCreator.getSuperClass(), (String[])new String[0]), thisObj, new ResultHandle[0]);
        ResultHandle declaringClass = methodCreator.loadClass(memberInfo.descriptor().getDeclaringClassName());
        memberInfo.descriptor().whenMetadataIsOnField(fd -> {
            ResultHandle name = methodCreator.load(fd.getName());
            ResultHandle field = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredField", Field.class, (Class[])new Class[]{String.class}), declaringClass, new ResultHandle[]{name});
            ResultHandle type = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Field.class, (String)"getGenericType", Type.class, (Class[])new Class[0]), field, new ResultHandle[0]);
            methodCreator.writeInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)GENERIC_TYPE_FIELD, Type.class), thisObj, type);
            methodCreator.writeInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)ANNOTATED_ELEMENT_FIELD, AnnotatedElement.class), thisObj, field);
        });
        memberInfo.descriptor().whenMetadataIsOnMethod(md -> {
            ResultHandle name = methodCreator.load(md.getName());
            ResultHandle method = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), declaringClass, new ResultHandle[]{name, methodCreator.newArray(Class.class, 0)});
            if (memberInfo.returnTypeRequired()) {
                ResultHandle type = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Method.class, (String)"getGenericReturnType", Type.class, (Class[])new Class[0]), method, new ResultHandle[0]);
                methodCreator.writeInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)GENERIC_TYPE_FIELD, Type.class), thisObj, type);
            }
            methodCreator.writeInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)ANNOTATED_ELEMENT_FIELD, AnnotatedElement.class), thisObj, method);
        });
        methodCreator.returnValue(thisObj);
    }

    private static void createGetDeclaringClass(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, Class.class, "getDeclaringClass", new Class[0]);
        ResultHandle out = methodCreator.loadClass(memberInfo.descriptor().getDeclaringClassName());
        methodCreator.returnValue(out);
    }

    private static void assertIsGoodMethod(MethodDescriptor method, boolean returnTypeRequired) {
        String methodName = method.getName();
        if (method.getParameterTypes().length != 0) {
            throw new IllegalStateException("The getterMethod (%s) must not have any parameters, but has parameters (%s).".formatted(methodName, Arrays.toString(method.getParameterTypes())));
        }
        if (methodName.startsWith("get")) {
            if (method.getReturnType().equals("V")) {
                throw new IllegalStateException("The getterMethod (%s) must have a non-void return type.".formatted(methodName));
            }
        } else if (methodName.startsWith("is")) {
            if (!method.getReturnType().equals("Z")) {
                throw new IllegalStateException("The getterMethod (%s) must have a primitive boolean return type but returns (%s).\nMaybe rename the method (get%s)?".formatted(methodName, method.getReturnType(), methodName.substring(2)));
            }
        } else if (returnTypeRequired && method.getReturnType().equals("V")) {
            throw new IllegalStateException("The readMethod (%s) must have a non-void return type.".formatted(methodName));
        }
    }

    private static void assertIsGoodMethod(MethodDescriptor method, boolean returnTypeRequired, Class<? extends Annotation> annotationClass) {
        String methodName = method.getName();
        if (method.getParameterTypes().length != 0) {
            throw new IllegalStateException("The getterMethod (%s) with a %s annotation must not have any parameters, but has parameters (%s).".formatted(methodName, annotationClass.getSimpleName(), Arrays.toString(method.getParameterTypes())));
        }
        if (methodName.startsWith("get")) {
            if (method.getReturnType().equals("V")) {
                throw new IllegalStateException("The getterMethod (%s) with a %s annotation must have a non-void return type.".formatted(methodName, annotationClass.getSimpleName()));
            }
        } else if (methodName.startsWith("is")) {
            if (!method.getReturnType().equals("Z")) {
                throw new IllegalStateException("The getterMethod (%s) with a %s annotation must have a primitive boolean return type but returns (%s).\nMaybe rename the method (get%s)?".formatted(methodName, annotationClass.getSimpleName(), method.getReturnType(), methodName.substring(2)));
            }
        } else if (returnTypeRequired && method.getReturnType().equals("V")) {
            throw new IllegalStateException("The readMethod (%s) with a %s annotation must have a non-void return type.".formatted(methodName, annotationClass.getSimpleName()));
        }
    }

    private static void createGetName(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, String.class, "getName", new Class[0]);
        memberInfo.descriptor().whenIsMethod(method -> {
            Class<? extends Annotation> annotationClass = memberInfo.annotationClass();
            if (annotationClass == null) {
                GizmoMemberAccessorImplementor.assertIsGoodMethod(method, memberInfo.returnTypeRequired());
            } else {
                GizmoMemberAccessorImplementor.assertIsGoodMethod(method, memberInfo.returnTypeRequired(), annotationClass);
            }
        });
        String fieldName = memberInfo.descriptor().getName();
        ResultHandle out = methodCreator.load(fieldName);
        methodCreator.returnValue(out);
    }

    private static void createGetType(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, Class.class, "getType", new Class[0]);
        ResultHandle out = methodCreator.loadClass(memberInfo.descriptor().getTypeName());
        methodCreator.returnValue(out);
    }

    private static void createGetGenericType(ClassCreator classCreator) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, Type.class, "getGenericType", new Class[0]);
        ResultHandle thisObj = methodCreator.getThis();
        ResultHandle out = methodCreator.readInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)GENERIC_TYPE_FIELD, Type.class), thisObj);
        methodCreator.returnValue(out);
    }

    private static void createExecuteGetter(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, Object.class, "executeGetter", Object.class);
        ResultHandle bean = methodCreator.getMethodParam(0);
        if (memberInfo.returnTypeRequired()) {
            methodCreator.returnValue(memberInfo.descriptor().readMemberValue((BytecodeCreator)methodCreator, bean));
        } else {
            memberInfo.descriptor().readMemberValue((BytecodeCreator)methodCreator, bean);
            methodCreator.returnNull();
        }
    }

    private static void createExecuteSetter(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, Void.TYPE, "executeSetter", Object.class, Object.class);
        ResultHandle bean = methodCreator.getMethodParam(0);
        ResultHandle value = methodCreator.getMethodParam(1);
        if (memberInfo.descriptor().writeMemberValue((BytecodeCreator)methodCreator, bean, value)) {
            methodCreator.returnValue(null);
        } else {
            methodCreator.throwException(UnsupportedOperationException.class, "Setter not supported");
        }
    }

    private static MethodCreator getAnnotationMethodCreator(ClassCreator classCreator, Class<?> returnType, String methodName, Class<?> ... parameters) {
        return classCreator.getMethodCreator(GizmoMemberAccessorImplementor.getAnnotationMethod(returnType, methodName, parameters));
    }

    private static MethodDescriptor getAnnotationMethod(Class<?> returnType, String methodName, Class<?> ... parameters) {
        return MethodDescriptor.ofMethod(AnnotatedElement.class, (String)methodName, returnType, (Class[])parameters);
    }

    private static void createGetAnnotation(ClassCreator classCreator) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getAnnotationMethodCreator(classCreator, Annotation.class, "getAnnotation", Class.class);
        ResultHandle thisObj = methodCreator.getThis();
        ResultHandle annotatedElement = methodCreator.readInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)ANNOTATED_ELEMENT_FIELD, AnnotatedElement.class), thisObj);
        ResultHandle query = methodCreator.getMethodParam(0);
        ResultHandle out = methodCreator.invokeInterfaceMethod(GizmoMemberAccessorImplementor.getAnnotationMethod(Annotation.class, "getAnnotation", Class.class), annotatedElement, new ResultHandle[]{query});
        methodCreator.returnValue(out);
    }

    private static void createDeclaredAnnotationsByType(ClassCreator classCreator) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getAnnotationMethodCreator(classCreator, Annotation[].class, "getDeclaredAnnotationsByType", Class.class);
        ResultHandle thisObj = methodCreator.getThis();
        ResultHandle annotatedElement = methodCreator.readInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)ANNOTATED_ELEMENT_FIELD, AnnotatedElement.class), thisObj);
        ResultHandle query = methodCreator.getMethodParam(0);
        ResultHandle out = methodCreator.invokeInterfaceMethod(GizmoMemberAccessorImplementor.getAnnotationMethod(Annotation[].class, "getDeclaredAnnotationsByType", Class.class), annotatedElement, new ResultHandle[]{query});
        methodCreator.returnValue(out);
    }

    private GizmoMemberAccessorImplementor() {
    }
}

