/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution.descriptor;

import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningSolutionMetaModel;
import ai.timefold.solver.core.preview.api.domain.solution.diff.PlanningEntityDiff;
import ai.timefold.solver.core.preview.api.domain.solution.diff.PlanningSolutionDiff;
import ai.timefold.solver.core.preview.api.domain.solution.diff.PlanningVariableDiff;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class DefaultPlanningSolutionDiff<Solution_>
implements PlanningSolutionDiff<Solution_> {
    private static final int TO_STRING_ITEM_LIMIT = 5;
    private final PlanningSolutionMetaModel<Solution_> solutionMetaModel;
    private final Solution_ oldSolution;
    private final Solution_ newSolution;
    private final Set<Object> removedEntities;
    private final Set<Object> addedEntities;
    private final Map<Class<?>, Set<PlanningEntityDiff<Solution_, ?>>> entityDiffMap = new LinkedHashMap();

    DefaultPlanningSolutionDiff(PlanningSolutionMetaModel<Solution_> solutionMetaModel, Solution_ oldSolution, Solution_ newSolution, Set<?> removedEntities, Set<?> addedEntities) {
        this.solutionMetaModel = Objects.requireNonNull(solutionMetaModel);
        this.oldSolution = Objects.requireNonNull(oldSolution);
        this.newSolution = Objects.requireNonNull(newSolution);
        this.removedEntities = Collections.unmodifiableSet(Objects.requireNonNull(removedEntities));
        this.addedEntities = Collections.unmodifiableSet(Objects.requireNonNull(addedEntities));
    }

    @Override
    public PlanningSolutionMetaModel<Solution_> solutionMetaModel() {
        return this.solutionMetaModel;
    }

    @Override
    public <Entity_> @Nullable PlanningEntityDiff<Solution_, Entity_> entityDiff(Entity_ entity) {
        return this.entityDiffs(entity.getClass()).stream().filter(entityDiff -> entityDiff.entity().equals(entity)).findFirst().orElse(null);
    }

    @Override
    public Set<PlanningEntityDiff<Solution_, ?>> entityDiffs() {
        if (this.entityDiffMap.isEmpty()) {
            return Collections.emptySet();
        }
        return this.entityDiffMap.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public <Entity_> Set<PlanningEntityDiff<Solution_, Entity_>> entityDiffs(Class<Entity_> entityClass) {
        Set<PlanningEntityDiff<Solution_, ?>> entityDiffSet = this.entityDiffMap.get(entityClass);
        if (entityDiffSet == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(entityDiffSet);
    }

    void addEntityDiff(PlanningEntityDiff<Solution_, ?> entityDiff) {
        this.entityDiffMap.computeIfAbsent(entityDiff.entityMetaModel().type(), k -> new LinkedHashSet()).add(entityDiff);
    }

    @Override
    public Solution_ oldSolution() {
        return this.oldSolution;
    }

    @Override
    public Solution_ newSolution() {
        return this.newSolution;
    }

    @Override
    public Set<Object> removedEntities() {
        return this.removedEntities;
    }

    @Override
    public Set<Object> addedEntities() {
        return this.addedEntities;
    }

    public String toString() {
        return this.toString(5);
    }

    String toString(int limit) {
        String removedEntityString = DefaultPlanningSolutionDiff.collectionToString(this.removedEntities, limit);
        String addedEntityString = DefaultPlanningSolutionDiff.collectionToString(this.addedEntities, limit);
        List<String> entityDiffStringList = this.entityDiffMap.values().stream().flatMap(Collection::stream).map(DefaultPlanningSolutionDiff::entityDiffToString).toList();
        String entityDiffString = DefaultPlanningSolutionDiff.collectionToString(entityDiffStringList, limit);
        return "Difference(s) between old planning solution (%s) and new planning solution (%s):\n\n- Old solution entities not present in new solution:\n%s\n\n- New solution entities not present in old solution:\n%s\n\n- Entities changed between the solutions:\n%s\n".formatted(this.oldSolution, this.newSolution, removedEntityString, addedEntityString, entityDiffString);
    }

    private static String collectionToString(Collection<?> entitySet, int limit) {
        if (entitySet.isEmpty()) {
            return "  (None.)";
        }
        Object addedEntityString = entitySet.stream().limit(limit).map(s -> "  " + s.toString()).collect(Collectors.joining(System.lineSeparator()));
        if (entitySet.size() > limit) {
            addedEntityString = (String)addedEntityString + System.lineSeparator() + "  ...";
        }
        return addedEntityString;
    }

    static String entityDiffToString(PlanningEntityDiff<?, ?> entityDiff) {
        Object entity = entityDiff.entity();
        Collection<PlanningVariableDiff<?, ?, ?>> variableDiffs = entityDiff.variableDiffs();
        if (entityDiff.entityMetaModel().variables().size() == 1) {
            PlanningVariableDiff<?, ?, ?> variableDiff = variableDiffs.iterator().next();
            return "%s (%s -> %s)".formatted(entity, variableDiff.oldValue(), variableDiff.newValue());
        }
        String variableDiffString = variableDiffs.stream().map(diff -> "    %s (%s): %s -> %s".formatted(diff.variableMetaModel().name(), diff.variableMetaModel().isGenuine() ? "genuine" : "shadow", diff.oldValue(), diff.newValue())).collect(Collectors.joining(System.lineSeparator()));
        return "%s:\n%s".formatted(entity, variableDiffString);
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof DefaultPlanningSolutionDiff)) {
            return false;
        }
        DefaultPlanningSolutionDiff that = (DefaultPlanningSolutionDiff)o;
        return Objects.equals(this.solutionMetaModel, that.solutionMetaModel) && Objects.equals(this.oldSolution, that.oldSolution) && Objects.equals(this.newSolution, that.newSolution);
    }

    public int hashCode() {
        return Objects.hash(this.solutionMetaModel, this.oldSolution, this.newSolution);
    }
}

