/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.valuerange.descriptor;

import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.api.domain.valuerange.ValueRangeProvider;
import ai.timefold.solver.core.api.domain.variable.PlanningVariable;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.collection.ListValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.AbstractValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractFromPropertyValueRangeDescriptor<Solution_>
extends AbstractValueRangeDescriptor<Solution_> {
    protected final MemberAccessor memberAccessor;
    protected boolean collectionWrapping;
    protected boolean arrayWrapping;
    protected boolean countable;

    public AbstractFromPropertyValueRangeDescriptor(GenuineVariableDescriptor<Solution_> variableDescriptor, boolean addNullInValueRange, MemberAccessor memberAccessor) {
        super(variableDescriptor, addNullInValueRange);
        this.memberAccessor = memberAccessor;
        ValueRangeProvider valueRangeProviderAnnotation = memberAccessor.getAnnotation(ValueRangeProvider.class);
        if (valueRangeProviderAnnotation == null) {
            throw new IllegalStateException("The member (%s) must have a valueRangeProviderAnnotation (%s).".formatted(memberAccessor, valueRangeProviderAnnotation));
        }
        this.processValueRangeProviderAnnotation(valueRangeProviderAnnotation);
        if (addNullInValueRange && !this.countable) {
            throw new IllegalStateException("The valueRangeDescriptor (%s) allows unassigned values, but not countable (%s).\nMaybe the member (%s) should return %s.".formatted(this, this.countable, memberAccessor, CountableValueRange.class.getSimpleName()));
        }
    }

    private void processValueRangeProviderAnnotation(ValueRangeProvider valueRangeProviderAnnotation) {
        Class<?> arrayElementClass;
        EntityDescriptor entityDescriptor = this.variableDescriptor.getEntityDescriptor();
        Class<?> type = this.memberAccessor.getType();
        this.collectionWrapping = Collection.class.isAssignableFrom(type);
        this.arrayWrapping = type.isArray();
        if (!(this.collectionWrapping || this.arrayWrapping || ValueRange.class.isAssignableFrom(type))) {
            throw new IllegalArgumentException("The entityClass (%s) has a @%s-annotated property (%s) that refers to a @%s-annotated member (%s) that does not return a %s, an array or a %s.".formatted(entityDescriptor.getEntityClass(), PlanningVariable.class.getSimpleName(), this.variableDescriptor.getVariableName(), ValueRangeProvider.class.getSimpleName(), this.memberAccessor, Collection.class.getSimpleName(), ValueRange.class.getSimpleName()));
        }
        if (this.collectionWrapping) {
            Class<?> collectionElementClass = ConfigUtils.extractGenericTypeParameterOrFail("solutionClass or entityClass", this.memberAccessor.getDeclaringClass(), this.memberAccessor.getType(), this.memberAccessor.getGenericType(), ValueRangeProvider.class, this.memberAccessor.getName());
            if (!this.variableDescriptor.acceptsValueType(collectionElementClass)) {
                throw new IllegalArgumentException("The entityClass (%s) has a @%s-annotated property (%s) that refers to a @%s-annotated member (%s) that returns a %s with elements of type (%s) which cannot be assigned to the type of %s (%s).".formatted(entityDescriptor.getEntityClass(), PlanningVariable.class.getSimpleName(), this.variableDescriptor.getVariableName(), ValueRangeProvider.class.getSimpleName(), this.memberAccessor, Collection.class.getSimpleName(), collectionElementClass, PlanningVariable.class.getSimpleName(), this.variableDescriptor.getVariablePropertyType()));
            }
        } else if (this.arrayWrapping && !this.variableDescriptor.acceptsValueType(arrayElementClass = type.getComponentType())) {
            throw new IllegalArgumentException("The entityClass (%s) has a @%s-annotated property (%s) that refers to a @%s-annotated member (%s) that returns an array with elements of type (%s) which cannot be assigned to the type of the @%s (%s);".formatted(entityDescriptor.getEntityClass(), PlanningVariable.class.getSimpleName(), this.variableDescriptor.getVariableName(), ValueRangeProvider.class.getSimpleName(), this.memberAccessor, arrayElementClass, PlanningVariable.class.getSimpleName(), this.variableDescriptor.getVariablePropertyType()));
        }
        this.countable = this.collectionWrapping || this.arrayWrapping || CountableValueRange.class.isAssignableFrom(type);
    }

    @Override
    public boolean isCountable() {
        return this.countable;
    }

    protected <Value_> ValueRange<Value_> readValueRange(Object bean) {
        ValueRange valueRange;
        Object valueRangeObject = this.memberAccessor.executeGetter(bean);
        if (valueRangeObject == null) {
            throw new IllegalStateException("The @%s-annotated member (%s) called on bean (%s) must not return a null valueRangeObject (%s).".formatted(ValueRangeProvider.class.getSimpleName(), this.memberAccessor, bean, valueRangeObject));
        }
        if (this.collectionWrapping || this.arrayWrapping) {
            List list;
            List<Object> list2 = list = this.collectionWrapping ? this.transformCollectionToList((Collection)valueRangeObject) : ReflectionHelper.transformArrayToList(valueRangeObject);
            if (!(list.isEmpty() || list.get(0) != null && list.get(list.size() - 1) != null)) {
                throw new IllegalStateException("The @%s-annotated member (%s) called on bean (%s) must not return a %s (%s) with an element that is null.\nMaybe remove that null element from the dataset.\nMaybe use @%s(allowsUnassigned = true) instead.".formatted(ValueRangeProvider.class.getSimpleName(), this.memberAccessor, bean, this.collectionWrapping ? Collection.class.getSimpleName() : "array", list, PlanningVariable.class.getSimpleName()));
            }
            valueRange = new ListValueRange(list);
        } else {
            valueRange = (ValueRange)valueRangeObject;
        }
        valueRange = this.doNullInValueRangeWrapping(valueRange);
        if (valueRange.isEmpty()) {
            throw new IllegalStateException("The @%s-annotated member (%s) called on bean (%s) must not return an empty valueRange (%s).\nMaybe apply over-constrained planning as described in the documentation.".formatted(ValueRangeProvider.class.getSimpleName(), this.memberAccessor, bean, valueRangeObject));
        }
        return valueRange;
    }

    protected long readValueRangeSize(Object bean) {
        long size;
        Object valueRangeObject = this.memberAccessor.executeGetter(bean);
        if (valueRangeObject == null) {
            throw new IllegalStateException("The @%s-annotated member (%s) called on bean (%s) must not return a null valueRangeObject (%s).".formatted(ValueRangeProvider.class.getSimpleName(), this.memberAccessor, bean, valueRangeObject));
        }
        long l = size = this.addNullInValueRange ? 1L : 0L;
        if (this.collectionWrapping) {
            return size + (long)((Collection)valueRangeObject).size();
        }
        if (this.arrayWrapping) {
            return size + (long)Array.getLength(valueRangeObject);
        }
        ValueRange valueRange = (ValueRange)valueRangeObject;
        if (valueRange.isEmpty()) {
            throw new IllegalStateException("The @%s-annotated member (%s) called on bean (%s) must not return an empty valueRange (%s).\nMaybe apply over-constrained planning as described in the documentation.".formatted(ValueRangeProvider.class.getSimpleName(), this.memberAccessor, bean, valueRangeObject));
        }
        if (valueRange instanceof CountableValueRange) {
            CountableValueRange countableValueRange = (CountableValueRange)valueRange;
            return size + countableValueRange.getSize();
        }
        throw new UnsupportedOperationException("The @%s-annotated member (%s) called on bean (%s) is not countable and therefore does not support getSize().".formatted(ValueRangeProvider.class.getSimpleName(), this.memberAccessor, bean));
    }

    private <T> List<T> transformCollectionToList(Collection<T> collection) {
        if (collection instanceof List) {
            List list = (List)collection;
            if (collection instanceof LinkedList) {
                LinkedList linkedList = (LinkedList)collection;
                return new ArrayList(linkedList);
            }
            return list;
        }
        return new ArrayList<T>(collection);
    }
}

